#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "talken1.img",
      "talken2.img",
      "talken3.img",
      "talken4.img",
      "talken5.img"
};
PRIVATE Pixmap pixmap[5];
PRIVATE Pixmap pixmap_mask[5];
PRIVATE GC gc[5];
PRIVATE int anim[10] = {4,4,3,3,2,2,1,1,0,0};
PRIVATE int shot_p[5][3] = {
      {15,20,25},
      {20,25,35},
      {35,38,40},
      {40,45,60},
      {60,70,80}
};

void TalkenSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;
      
      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 5 ; c_no++) {
            int x,y;
            
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));

            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void TalkenFree()
{
      int i;

      for(i = 0 ; i < 5 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void TalkenInit(enemy_no)
     int enemy_no;
{
      short sgnx,sgny,absxy,v;
      int i;

      enemy[enemy_no].enemy_no = TALKEN;
      enemy[enemy_no].tmp1 = 9;
      enemy[enemy_no].tmp2 = 0;
      
      if(jx.sht[UNION] < XSIZE/2) {
	    enemy[enemy_no].x.dummy = (XSIZE - rand() % (XSIZE/2))*65536;
	    enemy[enemy_no].y.dummy = -32*65536;
      }
      else
        {
	      enemy[enemy_no].x.dummy = 65536*(rand() % (XSIZE/2));
              enemy[enemy_no].y.dummy = -32*65536;
        }

      sgnx = jx.sht[UNION] - enemy[enemy_no].x.sht[UNION];
      sgny = jy.sht[UNION] - enemy[enemy_no].y.sht[UNION];
      absxy = 1+ABS(sgnx) + ABS(sgny);

      v = (rand() % 10+ 6)*STPF;
      enemy[enemy_no].vx = v*sgnx*33000/absxy;
      enemy[enemy_no].vy = v*sgny*33000/absxy;
}

int Talken(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      register int dx,dy;
      int sx,sy;
      
      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];

      if(enemy[enemy_no].tmp1 > 0)
	enemy[enemy_no].tmp1 += enemy[enemy_no].tmp2 ;

      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
      
      if(dx > -20 && dx < 20 && dy > -20 && dy < 20)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;
	      
	      if((shot[i].x.sht[UNION] - sx) > -20 && 
		 (shot[i].x.sht[UNION] - sx) < 20
		 && (shot[i].y.sht[UNION] - sy) > -24 && 
		 (shot[i].y.sht[UNION] - sy) < 24)
		{
		      score += 50;
		      shot[i].flag = 0;
                      BombInit(enemy_no);
		      return 0;
                }
        }
      
      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)
	{
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
              if(sy > (YSIZE/2+128 - (rand() & 255)))
                {
		      enemy[enemy_no].tmp2 = -STPF/2;
		      if(enemy[enemy_no].tmp1 == 9 &&
			 (rand() & 127) < shot_p[game_level][level]) {
			    EShut(enemy_no,enemy[enemy_no].x.dummy,
				  enemy[enemy_no].y.dummy);
		      }
		      enemy[enemy_no].vx = 0;
		      enemy[enemy_no].vy = 0;
		}
	      
	      if(enemy[enemy_no].tmp1 == 0) {
		    enemy[enemy_no].vy = -8*65536*STPF;
		    enemy[enemy_no].vx = STPF*(8 - rand() & 3)*65536;
	      }
              
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[anim[enemy[enemy_no].tmp1]],
			gc[anim[enemy[enemy_no].tmp1]],
			CSIZE,CSIZE);
        }
      
      return yararetaTL;
}



