"""Synthetic client side command interface."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import string
import re

import empDb
import empQueue

#######################
# Alias

class EmpParse:
    """Implements a set of aliasing commands"""

    def regCommand(self, lst, parser, names):
	"""Register a command."""
	for i in names:
	    lst[i] = parser

    class delayedDisp(empQueue.baseDisp):
	def __init__(self, env, match, disp, func):
	    empQueue.baseDisp.__init__(self, disp)
	    self.env = env
	    self.match = match
	    self.func = func
	def Begin(self, msg):
	    self.out.Begin(msg)
	    self.func(self.env, self.match, self.out)

    def delayedCommand(self, lst, parser, names):
	"""Register a command that is syncronized with server output."""
	def f(self, match, out, parser=parser):
	    self.sock.AddHandler(
		empQueue.DummyHandler(
		    match.string,
		    EmpParse.delayedDisp(self, match, out, parser),
		    empQueue.QU_BURST, empQueue.QU_FULLSYNC))
	for i in names:
	    lst[i] = f

    def __init__(self, queue):
	self.sock = queue
	self.HandleInput = self.sock.HandleInput
	self.fileno = self.sock.fileno
	self.SendNow = self.sock.SendNow

	self.preList = {}
	for i in (
## 	    (self.regCommand, EmpParse.CmdExit,
## 	     'exit'),
	    (self.delayedCommand, EmpParse.CmdAlias,
##		   re.compile(r"^(\S+)\s+(.*?)\s*$"),
	     'alias'),
	    (self.delayedCommand, EmpParse.CmdDefList,
	     'define'),
	    (self.regCommand, EmpParse.CmdWin,
	     'wind'),
	    (self.regCommand, EmpParse.CmdNull,
	     'null'),
	    (self.delayedCommand, EmpParse.CmdEval,
##		   re.compile(r"^((\w+)=(\w+)\s+)?(-?\d+),(-?\d+)\s+(.*)"),
	     'eval'),
	    (self.delayedCommand, EmpParse.CmdForEach,
##		   re.compile(r"^(\S+)\s+(?:\?(\S+)\s+)?(.*)$"),
	     'foreach'),
	    ):
	    i[0](self.preList, i[1], i[2:])

	self.syntaxList = (
	    (re.compile(
		r"^(?P<cmd>.*?)\s+>(?P<append>>)?(?P<force>!)?"
		+r"\s+(?P<file>\S+)\s*$"),
	     EmpParse.CmdRedirect),
	    (re.compile(r"(?P<cmd1>.*)\s*;\s*(?P<cmd2>.*)"),
	     EmpParse.CmdMulti),
	    (re.compile(r"^\s*(?P<flags>[eslpno]*)(?P<total>re)?sync\s*$"),
	     EmpParse.CmdSync),
##	    (re.compile(r"^\s*([eslpno]*)out"), EmpParse.CmdOut),
	    )

	self.postList = {}
	for i in (
	    (self.regCommand, EmpParse.CmdWinRead,
	     'wread'),
	    (self.regCommand, EmpParse.CmdShow,
##	     re.compile(r"^(\S+)(.*)$"),
	     'cshow'),
	    (self.regCommand, EmpParse.WinMap,
	     'Map'),
	    (self.regCommand, EmpParse.CmdExec,
	     'execute', 'execut', 'execu', 'exec', 'exe'),
	    (self.delayedCommand, EmpParse.CmdSect,
##		   re.compile(r"^(\S+)(?:\s+\?(\S+))?\s*$"),
	     'sect', 'sec'),
	    (self.delayedCommand, EmpParse.CmdOut,
	     'out'),
	    (self.delayedCommand, EmpParse.CmdNova,
#		   re.compile("^ "+s_comd+" "+s_sector+" (?:"+s_sector+")?$")
	     'nova'),
	    ):
	    i[0](self.postList, i[1], i[2:])

    commandFormat = re.compile(
	r"^\s*(?P<command>\S+)(?:\s+(?P<args>.*))?$")
    def Send(self, cmd, disp=None, prepend=0,
	     preFlag=empQueue.QU_SYNC, postFlag=empQueue.QU_SYNC):
	"""Search command line for smart commands."""
	if disp == None:
	    disp = viewer

	# Find root word
	mm = self.commandFormat.match(cmd)
	if mm:
	    # Check pre-syntax list
	    f = self.preList.get(mm.group('command'))
	    if f != None:
		f(self, mm, disp)
		return
	    # Check syntax list
	    for i in self.syntaxList:
		test = i[0].match(cmd)
		if test != None:
		    i[1](self, test, disp)
		    return
	    # Check post-syntax list
	    f = self.postList.get(mm.group('command'))
	    if f != None:
		f(self, mm, disp)
		return
	# Command not aliased - send raw
	hdlr = empQueue.NormalHandler(cmd, disp, preFlag, postFlag)
	if prepend:
	    self.sock.prependHandler(hdlr)
	else:
	    self.sock.AddHandler(hdlr)

##     def CmdExit(self, match, out):
## 	"""Leave client immediately"""
## 	sys.exit()

    def CmdDefList(self, match, out):
	"""List all online commands"""
	if not out.data:
	    return
	out.data('Pre-syntax:')
	t = self.preList.items()
	t.sort()
	for i, j in t:
	    out.data('%-10s - %s' % (i, j.__doc__))
	out.data('Syntax:')
	for i in self.syntaxList:
	    out.data('%-35s - %s' % (i[0].pattern, i[1].__doc__))
	out.data('Post-syntax:')
	t = self.postList.items()
	t.sort()
	for i, j in t:
	    out.data('%-10s - %s' % (i, j.__doc__))

    aliasFormat = re.compile(
	r"^(?P<newName>\S+)\s+(?P<value>.*?)\s*$")
    def CmdAlias(self, match, out):
	"""Generate a definition for a simple alias."""
	mm = self.aliasFormat.match(match.group('args'))
	if not mm:
	    viewer.flash("Alias regex failure.")
	    return
	exec compile('def tmp(self, m, out): "Aliased to '
		     +repr(mm.group('value'))
		     +'" ; self.Send('+repr(mm.group('value'))
		     +' + " " + (m.group("args") or ""), out, 1)',
		     '<string>', 'exec')
	self.preList[mm.group('newName')] = tmp

    def CmdMulti(self, match, out):
	"""Multi-Command line."""
	self.Send(match.group('cmd1'), out)
	self.Send(match.group('cmd2'), out)

    class storeFile(empQueue.baseDisp):
	def __init__(self, disp, name, flags):
	    empQueue.baseDisp.__init__(self, disp)
	    self.name = name
	    self.flags = flags
	def Begin(self, cmd):
##	    print 'opening'
	    if self.out.Begin is empQueue.doNothing:
		return
	    self.out.Begin(cmd)
	    self.file = open(self.name, self.flags)
	def End(self, cmd):
	    self.out.End(cmd)
	    self.file.close()
	def data(self, msg):
	    self.file.write(msg+"\n")

    def CmdRedirect(self, match, out):
	"""Redirect output to a file."""
##	print "redirect"
	if match.group('append'):
	    flg = "a"
	else:
	    flg = "w"
	self.Send(match.group('cmd'),
		  self.storeFile(out, match.group('file'), flg))

    def CmdExec(self, match, out):
	"""Run commands from a file."""
	try:
	    file = open(match.group('args'))
	except IOError:
	    viewer.flash("Unable to open file [%s]." % match.group('args'))
	    return
	lst = file.readlines()
	file.close()
	for i in lst:
	    i = string.strip(i)
	    if not i or i[0] == '#':
		continue
	    self.Send(i, out)

    def CmdWin(self, match, out):
	"""Output command to Tk Window."""
	self.Send(match.group('args'),
		  viewer.CmdWind(out, match.group('args')))

    def WinMap(self, match, out):
	"""Open an additional map window."""
	viewer.CmdMap()

    def CmdWinRead(self, match, out):
	"""Graphical correspondence tool."""
	viewer.CmdWRead()

    showFormat = re.compile(
	r"^(?P<unitType>\S+)(?P<techLevel>.*)$")
    def CmdShow(self, match, out):
	"""Hack for show command."""
	new = ParseShow(viewer.CmdWind(out, match.string, 140))
	mm = self.showFormat.match(match.group('args'))
	if not mm:
	    viewer.flash("CShow regex failure.")
	    return
	if mm.group('techLevel') == None:
	    tl = ""
	else:
	    tl = mm.group('techLevel')
	self.Send("show "+mm.group('unitType')+" build"+tl, new)
	self.Send("show "+mm.group('unitType')+" stat"+tl, new)
	self.Send("show "+mm.group('unitType')+" cap"+tl, new)

    class ReallySilentDisp(empQueue.baseDisp):
	"""Display class that discards all input."""
	Begin = data = Answer = End = empQueue.doNothing

    class SilentDisp(empQueue.baseDisp):
	"""Display class that discards most input."""
	def __init__(self, disp, name):
	    empQueue.baseDisp.__init__(self, disp)
	    self.name = name
	def __del__(self):
	    self.out.End(self.name)
	    if self.updateDB is empQueue.doNothing:
		self.out.updateDB()
	def updateDB(self):
	    self.updateDB = empQueue.doNothing
	def Begin(self, cmd):
	    if self.Begin is not empQueue.doNothing:
		self.out.Begin(self.name)
	    self.Begin = empQueue.doNothing
	data = Answer = End = empQueue.doNothing

    class QuietDisp(empQueue.baseDisp):
	"""Display class that discards some input."""
	data = empQueue.doNothing

    def CmdNull(self, match, out):
	"""Run command with no output."""
	self.Send(match.group('args'), self.SilentDisp(out, match.string))

    def CmdSync(self, match, out):
	"""Sync server and client."""
	nullDisp = self.SilentDisp(out, match.string)
##	self.Send("null bmap *", out)
	cmds = [('e', 'SECTOR', 'dump'),
		('l', 'LAND UNITS', 'ldump'),
		('s', 'SHIPS', 'sdump'),
		('p', 'PLANES', 'pdump'),
		('n', 'NUKES', 'ndump'),
		('o', 'LOST ITEMS', 'lost')]
	c = match.group('flags')
	if not c:
##	    c = 'elspno'
	    c = 'elspo'
##	   first = empQueue.QU_SYNC
	for i in cmds:
	    if not i[0] in c:
		continue
	    ts = ""
	    if (not match.group('total')
		# HACK!	 Always do a full dump of the nuke database
		and i[0] != 'n'):
		ts = " ?timestamp>%s" % (empDb.megaDB[i[1]].timestamp,)
	    self.Send(i[2] + " *" + ts, nullDisp)
##	    self.Send(i[2] + " *" + ts, nullDisp, 1, first,
##			 empQueue.QU_BURST)
##	       first = empQueue.QU_BURST

    def convertTypes(self, nd, dict):
	"""Convert an all ascii database to integer/float/string database."""
	atoi = empDb.fixedAtoI
	for i, j in dict.items():
	    try: nd[i] = atoi(j)
	    except ValueError:
		try: nd[i] = string.atof(j)
		except ValueError:
		    nd[i] = j
	    except TypeError:
		nd[i] = j

    def makeLocalDB(self, nd, dict):
	"""Make a local database copy for a sector."""
	convertTypes(nd, dict)

    s_var = r"(?P<var>\w+)"
    s_val = r"(?P<val>\w+)"
    s_command = r"(?P<command>.*)"
    evalFormat = re.compile(
	r"^(?:"+s_var+"="+s_val+"\s+)?"+empDb.s_sector+"\s+"+s_command+"$")
    ss_normal = "[^\]\"']"
    ss_quoted1 = "'.*?'"
    ss_quoted2 = '".*?"'
    s_pre = r"(?P<pre>.*?)"
    s_eval = r"(?P<eval>(?:"+ss_normal+"|"+ss_quoted1+"|"+ss_quoted2+")*)"
    s_post = r"(?P<post>.*)"
    exprFormat = re.compile("^"+s_pre+"\["+s_eval+"\]"+s_post+"$")
    def CmdEval(self, match, out):
	"""Evaluate an expression for a sector."""
	mm = self.evalFormat.match(match.group('args'))
	if not mm:
	    viewer.flash("eval regex failure")
	    return
	try: db = empDb.megaDB['SECTOR'][mm.group('sectorX', 'sectorY')]
	except KeyError:
	    viewer.flash("Could not find sector")
	    return

	# Create local name space
	ldb = {}
	if mm.group('var'):
	    self.convertTypes(ldb, {mm.group('var'):mm.group('val')})
	self.convertTypes(ldb, db)

	# Add a few extras
	try: ldb['newdes'] = (ldb['sdes'] == '_' and ldb['des']) or ldb['sdes']
	except KeyError: pass
	try: ldb['sect'] = `ldb['x']` + ',' + `ldb['y']`
	except KeyError: pass
	try: ldb['dist'] = `ldb['dist_x']` + ',' + `ldb['dist_y']`
	except KeyError: pass

	cmd = ""
	txt = mm.group('command')
	try:
	    while txt:
		mc = self.exprFormat.match(txt)
		if not mc:
		    cmd = cmd + txt
		    break
		cmd = cmd + mc.group('pre')
		e = mc.group('eval')
		txt = mc.group('post')
		cmd = cmd + str(eval(e, ldb))
	except:
	    viewer.flash('[%s] raised %s with detail "%s".'
			 % ((e,)+tuple(sys.exc_info()[:2])))
	else:
	    self.Send(cmd, out, 1)

    s_all = r"\*"
    s_realm = r"#(?P<realm>\d+)?"
    s_sectors = (r"(?P<minX>"+empDb.ss_sect+")(?::(?P<maxX>"
		 +empDb.ss_sect+"))?,(?P<minY>"+empDb.ss_sect
		 +")(?::(?P<maxY>"+empDb.ss_sect+"))?")
    sectorsFormat = re.compile("^"+s_all+"$|^"+s_realm+"$|^"+s_sectors+"$")
    conditionsFormat = re.compile(
	r"^(?P<var>\S+?)(?P<opr>[=<>#])(?P<val>\S+?)(?:&(?P<next>\S+))?$")
    getSectorsError = "getSectorsError"
    def getSectors(self, range, cond, dbname='SECTOR'):
	"""Returns a list of sectors that meet the given empire selector."""
	mc = self.sectorsFormat.match(range)
	if not mc:
	    raise self.getSectorsError, "Coordinate regexp failure."

	if mc.group('realm') != None:
	    # Realm
	    if mc.group('realm') == "":
		rm = 0
	    else:
		rm = string.atoi(mc.group('realm'))
	    try: val = empDb.megaDB['realm'][rm]
	    except KeyError:
		raise self.getSectorsError, "Realm not in database."
	    conditions = ("x>=%d and x<=%d and y>=%d and y<=%d" % val)
##	    minx, maxx, miny, maxy = val
##	elif not mc.group(2):
##	    # All
##	    minx, maxx, miny, maxy = (-99999, 99999, -99999, 99999)
##	else:
	elif mc.group('minX'):
	    # Range
	    if mc.group('maxX'):
##		minx, maxx = map(string.atoi, mc.group('minX', 'maxX'))
		conditions = ("x>=%s and x<=%s"
			      % mc.group('minX', 'maxX'))
	    else:
##		minx = maxx = string.atoi(mc.group('minX'))
		conditions = "x==%s" % (mc.group('minX'),)
	    if mc.group('maxY'):
##		miny, maxy = map(string.atoi, mc.group('minY', 'maxY'))
		conditions = (conditions + " and y>=%s and y<=%s"
			      % mc.group('minY', 'maxY'))
	    else:
##		miny = maxy = string.atoi(mc.group('minY'))
		conditions = conditions + " and y==%s" % (mc.group('minY'),)
	else:
	    conditions = "1"

	# Convert selectors into an eval string
	forceOwner = 1
	slcts = empDb.selectors[dbname]
	while cond:
	    mc = self.conditionsFormat.match(cond)
	    if not mc:
		raise self.getSectorsError, "Condition regexp failure."
	    # Convert the two variables
	    vars = []
	    for i in mc.group('var', 'val'):
		if len(i) == 1 and not i in string.digits:
		    vars.append(repr(i))
		else:
		    vars.append(slcts.get(i, i))
		    # Hack - check if owner is explicitly checked.
		    if vars[-1] == "owner":
			forceOwner = 0
	    conditions = (conditions + " and %s%s%s" % (
		vars[0],
		{'=':'==', '#':'!=', '<':'<', '>':'>'}[mc.group('opr')],
		vars[1]))
	    cond = mc.group('next')

	# If owner is never explicitly checked, assume only owned sectors
	# are desired.
	if forceOwner:
	    conditions = conditions + " and owner==%s" % (empDb.CN_OWNED,)

	# Find every sector that applies
	try:
	    expre = compile(conditions, '<string>', 'eval')
	except:
	    raise self.getSectorsError, "Compile exception!"
	db = empDb.megaDB[dbname]
	list = {}
	for i, j in db.items():
	    ldb = {}
	    self.convertTypes(ldb, j)
	    try:
		if eval(expre, ldb):
		    list[i] = j
	    except NameError:
		pass

	return list

##	# build a dictionary that has a reference to every sector
##	# in the main database.
##	for i, j in db.items():
##	    dx = string.atoi(j['x'])
##	    dy = string.atoi(j['y'])
##	    if dx < minx or dx > maxx or dy < miny or dy > maxy:
##		continue
##	    if j.get('__own') == -1:
##		list[i] = j

##	while cond:
##	    m = self.match_conditions.match(cond)
##	    if not m:
##		viewer.flash("cond regex failure.")
##		return {}
##	    valx = slcts.get(m.group(1), m.group(1))
##	    comp = m.group(2)
##	    valy = slcts.get(m.group(3), m.group(3))
##	    if comp == '=':
##		for i, j in list.items():
##		    if not j.has_key(valx) or not j[valx] == valy:
##			del list[i]
##	    elif comp == '#':
##		for i, j in list.items():
##		    if not j.has_key(valx) or not j[valx] != valy:
##			del list[i]
##	    elif comp == '<':
##		try:
##		    ty = string.atoi(valy)
##		except ValueError:
##		    viewer.flash("cond < and > requires integer values.")
##		    return {}
##		for i, j in list.items():
##		    try:
##			tmp = string.atoi(j[valx])
##		    except (ValueError, KeyError):
##			del list[i]
##		    else:
##			if not tmp < ty:
##			    del list[i]
##	    elif comp == '>':
##		try:
##		    ty = string.atoi(valy)
##		except ValueError:
##		    viewer.flash("cond < and > requires integer values.")
##		    return {}
##		for i, j in list.items():
##		    try:
##			tmp = string.atoi(j[valx])
##		    except (ValueError, KeyError):
##			del list[i]
##		    else:
##			if not tmp > ty:
##			    del list[i]
##	    cond = m.group(4)
##	return list

    sectFormat = re.compile(
	r"^(?P<sectors>\S+)(?:\s+\?(?P<selectors>\S+))?\s*$|^$")
    def CmdSect(self, match, out):
	"""Highlight specified sectors on main map."""
	if not match.group('args'):
	    # Disable highlighting
	    viewer.markSectors([], "sect")
	    return

	mm = self.sectFormat.match(match.group('args'))
	if not mm:
	    viewer.flash("sect regex failure")
	    return

	try:
	    list = self.getSectors(mm.group('sectors'), mm.group('selectors'))
	except self.getSectorsError, e:
	    viewer.flash(e)
	else:
	    list = map(map, [string.atoi]*len(list), list.keys())
	    viewer.markSectors(list, "sect")

    foreachFormat = re.compile(
	r"^(?P<sectors>\S+)\s+(?:\?(?P<selectors>\S+)\s+)?(?P<cmd>.*)$")
    def CmdForEach(self, match, out):
	"""Run given command on specified sectors."""
	# parse command line further
	mm = self.foreachFormat.match(match.group('args'))

	if not mm:
	    viewer.flash("foreach regex failure.")
	    return

	try:
	    list = self.getSectors(mm.group('sectors'), mm.group('selectors'))
	except self.getSectorsError, e:
	    viewer.flash(e)
	else:
	    for i in list.keys():
		self.CmdEval(
		    self.commandFormat.match(
			"eval %s,%s %s" % (i[0], i[1], mm.group('cmd'))),
		    out)

    outFormat = re.compile(r"\s+(\S+)\s*$")
    def CmdOut(self, match, out):
	"""Debugging tool - dumps database."""
	out.data(str(empDb.megaDB))
##	cmds = [('e', 'SECTOR', 'dump'),
##		('l', 'LAND UNITS', 'ldump'),
##		('s', 'SHIPS', 'sdump'),
##		('p', 'PLANES', 'pdump'),
## #		('n', 'NUKES', 'ndump'),
##		('o', 'LOST ITEMS', 'lost')]
##	c = match.group(1)
##	if not c:
##	    c = 'elspno'

##	mm = self.match_out.search(match.string)

##	if not mm:
##	    val = '*'
##	else:
##	    val = mm.group(1)

##	for dbt in cmds:
##	    if not dbt[0] in c:
##		continue

##	    out.data(dbt[1]+":" + `self.getSectors(val, "", dbt[1])`)

    novaFormat = re.compile(
	"^"+empDb.s_comm+"\s+"+empDb.s_sector
	+"\s*(?:"+empDb.s_sector2+")?\s*$")
    def CmdNova(self, match, out):
	"""Auto-explore sectors."""
	mm = self.novaFormat.match(match.group('args'))
	if not mm:
	    viewer.flash("Nova regex failure.")
	    return
	start = map(string.atoi, mm.group('sectorX', 'sectorY'))
	if mm.group('sector2X'):
	    dest = map(string.atoi, mm.group('sector2X', 'sector2Y'))
	else:
	    dest = start
	if dest == start:
	    estr = "%s,%s 1" % tuple(start)
	else:
	    estr = "%s,%s 1 %s,%s" % tuple(start+dest)
	db = empDb.megaDB['SECTOR']
	# Check if there are wilderness sectors around destination.
	world = empDb.megaDB['version']['worldsize']
	for i, j, d in sector_directions:
	    newcoord = ((dest[0]+i+world[0]/2)%world[0]-world[0]/2,
			(dest[1]+j+world[1]/2)%world[1]-world[1]/2)
	    sect = db.get((str(newcoord[0]), str(newcoord[1])), {})
	    if sect.get('owner') != empDb.CN_OWNED and sect.get('des') == '-':
		print "exploring to %s,%s a (%s) owned by (%s)" % (
		    newcoord+(sect.get('des'), sect.get('owner')))
		break
	else:
	    # No sectors to explore
	    return
	self.Send("explore " + mm.group('comm') + " " + estr,
		  HandleNova(out, self, mm.group('comm'), start, dest),
		  1, empQueue.QU_BURST, empQueue.QU_FULLSYNC)
	self.Send("des * ?newdes=-&mob=0 +", out)
##	self.Send("esync")

sector_directions =  ((-2, 0, 'g'), (-1, -1, 'y'), (1, -1, 'u'),
		      (2, 0, 'j'), (1, 1, 'n'), (-1, 1, 'b'))

class HandleNova(empQueue.baseDisp):
    def __init__(self, disp, slf, comd, start, dest):
	empQueue.baseDisp.__init__(self, disp)
	self.slf = slf
	self.comd = comd
	self.start = start
	self.dest = dest
	self.oldflush = None
	self.direc = 0
    def flush(self, msg):
	if self.oldflush != None and msg != self.oldflush:
	    # Looks like we succeeded in moving.
	    self.out.data(msg+'h')
	    self.slf.SendNow('h')
	    return
	self.oldflush = msg
	world = empDb.megaDB['version']['worldsize']
	db = empDb.megaDB['SECTOR']
	# Failed to move.
	while 1:
	    if self.direc >= len(sector_directions):
		# No more directions left
		self.out.data(msg+'h')
		self.slf.SendNow('h')
		return
	    d = sector_directions[self.direc]
	    newcoord = ((self.dest[0]+d[0]+world[0]/2)%world[0]-world[0]/2,
			(self.dest[1]+d[1]+world[1]/2)%world[1]-world[1]/2)
	    sect = db.get((str(newcoord[0]), str(newcoord[1])), {})
	    if sect.get('owner') != empDb.CN_OWNED and sect.get('des') == '-':
		self.out.data(msg+d[2])
		self.slf.SendNow(d[2])
		break
	    self.direc = self.direc + 1
	self.direc = self.direc + 1
    ownSector = empDb.ParseMove.ownSector
    def data(self, msg):
	self.out.data(msg)
	mm = self.ownSector.match(msg)
	if mm:
	    if self.direc < len(sector_directions):
		self.slf.CmdNova(
		    EmpParse.commandFormat.match(
			"nova %s %s,%s %s,%s" % (
			    self.comd, self.start[0], self.start[1],
			    self.dest[0], self.dest[1])),
		    self.out)
	    self.slf.Send(
		"nova %s %s,%s %s,%s" % (
		    (self.comd, self.start[0], self.start[1],
		    mm.group('sectorX'), mm.group('sectorY'))),
		self.out)

class HandleFlush(empQueue.baseDisp):
    """Class to handle programable sub-prompts."""
    def __init__(self, disp, prompts):
	empQueue.baseDisp.__init__(self, disp)
	self.prompts = list(prompts)
    def flush(self, msg):
	for i in range(prompts):
	    val = prompts[i]
	    if type(val) == types.tuple:
		match, val = val
		mm = match.match(msg)
		if mm:
		    if callable(val):
			viewer.SendNow(val(mm))
		    else:
			viewer.SendNow(val)
		    break
	    elif callable(val):
		viewer.SendNow(val(msg))
		del self.prompts[i]
		break
	    else:
		viewer.SendNow(val)
		del self.prompts[i]
		break
	else:
	    self.out.flush(msg)

class ParseShow(empQueue.baseDisp):
    """Rearrange output from multiple commands into a set of columns.

    This is a hack!  - It is really only usefull for show XXX YYY.
    Now this hack got hacked by Bernhard to let capability listings
	not grow to big. So it is special for cshow. :-)
	It is important that "cap" are the last char of the last command
	which this class is called with.

    Kevin has arranged a list Body. The last element is printed first,
    so that commands with more overhead lines can append to the list.
    """

    def __init__(self, disp):
	empQueue.baseDisp.__init__(self, disp)

	self.CBody = []
	self.Body = []
	self.first = 1
	self.foundheader = 0

    def __del__(self):
    	# do the output
	for i in range(1, len(self.Body)+1):
	    self.out.data(self.Body[-i])

    def End(self, cmd):
	self.out.End(cmd)
	# stuff to do at the end of each block, put CBody in Body

	if self.Body:
	    mx = max(map(len, self.Body))
	else:
	    mx = 0

	# next lines just to test that i have understood this --Bernhard
## 	sys.stdout.write('cmd=' + cmd + "\n")
	if  cmd[-3:] == "cap" : 
## 	    sys.stdout.write('found cap cmd\n')
## 	    sys.stdout.flush()
	    mfc=140-mx-1  # max width for cap output (should be determined dynmc)

	al=0 	# added lines, only >0 when formatting cap output
	for i in range(len(self.CBody)):
	    if cmd[-3:] == "cap": 
		while len(self.CBody[i])>mfc:
		    # insert enough additional lines in Body and truncate CBody
		    # a better approach would be to find a word to split
		    ll= len(self.CBody[i])
		    if (ll/mfc)*mfc==ll:
			ii=(ll/mfc - 1)*mfc
		    else:
			ii=(ll/mfc)*mfc
		    self.Body.insert(i+al,' '*mx + ' ' + self.CBody[i][ii:])
		    self.CBody[i]= self.CBody[i][:ii]
		    al=al+1

	    if i+1 > len(self.Body):
		self.Body.append(' '*mx + self.CBody[i])
	    else:
		self.Body[i+al] =  ( self.Body[i+al] 
					+ ' '*(mx-len(self.Body[i+al]))
				      	+ self.CBody[i])
	self.CBody = []
	self.Bpos = -1
	self.first = 0
	self.foundheader = 0

    def data(self, msg):
	# prepend message to CBody
	if not self.foundheader:
	    if string.lstrip(msg[:25]) == '':
		self.foundheader = 1
	    else:
		return
	if self.first:
	    self.CBody[0:0] = [ msg ]
	else:
	    self.CBody[0:0] = [ msg[25:] ]
