
/*
 * Copyright 1996 by Daniel B. Suthers, Pleasanton, Ca 94588 USA
 * Email dbs@tanj.com
 * Original code written for the cp290 series by Larry Campbell,
 * 73 Concord Street, Maynard MA 01754 USA. (maynard!campbell)
 *
 * You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 */

#include <stdio.h>
#include <time.h>
#include "x10.h"
#include <syslog.h>

extern int tty;
extern int sptty;
extern struct tm *localtime();
extern long time();
extern char *wdays[];
extern int i_am_relay;

extern int x10_housecode;
extern int verbose;

/* ARGSUSED */

c_setclock(argc, argv)
char *argv[];
{
    unsigned char data[9];
    unsigned char buf[3];
    char msgbuf[1000];
    unsigned int n;
    unsigned int clear;
    struct tm *tp;
    long dtime;
    char RCSID[]= "@(#) $Id: setclock.c,v 1.5 1997/12/07 22:25:26 dbs Exp $\n";

    if (argc < 1 || argc > 2)
	usage(E_2MANY);
    clear = 0;
    if( argc == 2 && strcmp( "reset", argv[1]) == 0 )
        clear = 1;
    dtime = time((long *) 0);
    tp = localtime(&dtime);
    data[0] = 0x9b;		/* CM11A timer download code */
    data[1] = tp->tm_sec ;
    data[2] = tp->tm_min + (((tp->tm_hour) %2) * 60 ) ;  /* minutes 0 - 119 */
    data[3] = tp->tm_hour / 2 ;			/* hour / 2         0 - 11 */
    data[4] = tp->tm_yday % 256 ;		/* mantisa of julian date */
    data[5] = ((tp->tm_yday / 256 ) << 7);	/* radix of julian date */
    data[5] |= (0x01 << (tp->tm_wday)); /* bits 0-6 =  single bit mask day */
    					 /* of week ( smtwtfs ) */
    data[6] = (x10_housecode << 4);
    data[6] |= clear;
    if (verbose)
    {

        sprintf(msgbuf, "would send %0x %0x %0x %0x %0x %0x %0x\n",
	        data[0], data[1], data[2], data[3], data[4], data[5],
		data[6]);
	if( i_am_relay == 1 )
	    syslog(LOG_ERR, msgbuf);
	else
	    fprintf(stderr, msgbuf);
    }
    (void) xwrite(tty, (char *) data, 7);
    n = exread(sptty, buf, 1, 1);
    /*
    if( n == 1 )
    {
	printf( "sum = %0x, returned = %0x\n", chksum(data,7), buf[0]);
        
    }
    */
    if( argc == 2 )
    {
	check4poll(0,1);		/* zero means to discard data */
	get_status();
	if( clear == 0)
	{
	    if( ! i_am_relay )
	    (void) fprintf(stderr, "CM11A clock set to %s, %d:%02d\n",
		      wdays[tp->tm_wday], tp->tm_hour, tp->tm_min);
	}
	else
	{
	    (void) printf("CM11A house code set to %c\n", hc2char( x10_housecode));
	}
    }
}
