/* This module has some functions unique to the CM11A interface.
 * Copyright Daniel B. Suthers, 1996, 1997, Pleasanton, Ca. USA 93988
 * dbs@tanj.com
 *
 */
 
#include <stdio.h>
#include "x10.h"

extern unsigned char cm11map[];
extern unsigned char map2cm11[];

char *funcmap[] = {
        "All Off",
	"All On",
	"On",
	"Off",
	"Dim",
	"Bright",
	"All Lights Off",
	"Extended Code",
	"Hail Request",
	"Hail Acknowledge",
	"Pre Set Dim %5",
	"Pre Set Dim %75",
	"Extended Data Transfer",
	"Status is On",
	"Status is Off",
	"Status Request" } ;


/* This function returns an integer between 1 and 16.
 * It expects hex_unit to be the hex number coresponding to a
 * unit number.
 * Return -1 upon failure to find a match.
 */

unit2int(hex_unit)
int hex_unit;
{
      char RCSID[]= "@(#) $Id: cm11a.c,v 1.4 1998/05/08 01:50:08 dbs Exp dbs $\n";

  int unhexed;
  /* Unit numbers may be 1 to 16.  Enforce this restriction */
  hex_unit &= 0x0F;

  /* search through the external array 'cm11map'
   * Return the index that matches the value
   */

  unhexed = 0;
  while ( unhexed < 16 )
  {
      if( hex_unit == cm11map[unhexed++] )
          break;
  }
  if( unhexed == 16  && hex_unit != cm11map[15]  )
      unhexed = -1;

  return(unhexed);
}

/* This function will transform a 16 bit bitmap of devices in X10 format,
 * IE bit 6 is device 1 to a human readable map where bit 0 is device 1.
 * The map is bigendian, IE bit 0 is at the far right.
 * Unit 1 example:starting with 040 (1000000b)  will return 1 (0001b)
 * Unit 4 example:starting with 0400 (10000000000b)  will return 8 (1000b)
 */
unsigned int x2unitmap(xmap)
int xmap;
{
    unsigned int ret_map;
    int cntr;

    cntr = ret_map = 0;
    while( cntr < 16)
    {
        if( (xmap & ( 0x01 << cntr)) != 0 )
	    ret_map  |= (0x1 << (map2cm11[cntr] - 1));
		/* Note:  The ret_map is 0 relative and the map2cm11 array 
		 *        is 1 relative, so we must adjust by one.
		 */
	cntr++;
    }
    
return(ret_map);
}


/* b2s converts a 16 bit int to a 16 byte binary ascii string, msb on the left
 * It's used for visualizing the bits as they are displayed.
 * (Good for debugging)
 */
char *b2s(bin)
unsigned int bin;
{
    static char bite[17];
    int i, ii;

    i = 16;
    ii = 0;
    while( i > 0  )
    {
        bite[--i] = ((bin & (0x01 << ii++)) != 0 ) +'0' ;
    }
    bite[16] = '\0';

    return(bite);
}
