#ifndef NODELIST_H
#define NODELIST_H

#include "ftn.h"

#define MAXUFLAGS 8

typedef struct _node {
	faddr addr;
	unsigned short hub;
	unsigned char type;
	unsigned char pflag;
	char *name;
	char *location;
	char *sysop;
	char *phone;
	unsigned speed;
	unsigned long flags;
	char *uflags[MAXUFLAGS];
} node;

/* type values */
#define NL_NONE		0
#define NL_ZONE		1
#define NL_NET		2
#define NL_NODE		3
#define NL_POINT	4

/* pflag values */
#define NL_DOWN		0x01
#define NL_HOLD		0x02
#define NL_DUMMY	0x04
#define NL_HUB		0x08
#define NL_PVT		0x10
#define NL_REGION	0x20

/* flag values */
#define NL_CM	0x00000001L
#define NL_MO	0x00000002L
#define NL_LO	0x00000004L
#define NL_V21	0x00000008L
#define NL_V22	0x00000010L
#define NL_V29	0x00000020L
#define NL_V32	0x00000040L
#define NL_V32B	0x00000080L
#define NL_V33	0x00000100L
#define NL_V34	0x00000200L
#define NL_V42	0x00000400L
#define NL_V42B	0x00000800L
#define NL_MNP	0x00001000L
#define NL_H96	0x00002000L
#define NL_HST	0x00004000L
#define NL_H14	0x00008000L
#define NL_H16	0x00010000L
#define NL_MAX	0x00020000L
#define NL_PEP	0x00040000L
#define NL_CSP	0x00080000L
#define NL_ZYX	0x00100000L

#define NL_MN	0x08000000L

#define NL_RQMODE	0xf0000000L
#define NL_RQ_BR	0x10000000L
#define NL_RQ_BU	0x20000000L
#define NL_RQ_WR	0x40000000L
#define NL_RQ_WU	0x80000000L
#define NL_XA	(NL_RQ_BR | NL_RQ_BU | NL_RQ_WR | NL_RQ_WU)
#define NL_XB	(NL_RQ_BR | NL_RQ_BU | NL_RQ_WR		  )
#define NL_XC	(NL_RQ_BR |	       NL_RQ_WR | NL_RQ_WU)
#define NL_XP	(NL_RQ_BR | NL_RQ_BU			  )
#define NL_XR	(NL_RQ_BR |	       NL_RQ_WR		  )
#define NL_XW	(		       NL_RQ_WR		  )
#define NL_XX	(		       NL_RQ_WR | NL_RQ_WU)

extern node *getnlent();
extern void *endnlent();
extern int flagexp();

extern struct _fkey {
	char *key;
	unsigned long flag;
} fkey[];

#endif
