#ifndef FILE_H
#define FILE_H

/* 
   file.h
   include file for xlogmaster file-subroutines
*/


/*{{{  Variables  */

char* load_path;
char* save_path;
char* log_path;

/*}}}*/

/*{{{  Config-File REGEX strings  */
static re_pattern_buffer* tail_regex = NULL;
static gchar* tail_string = "^TAIL *{.*}";
static re_pattern_buffer* cat_regex = NULL;
static gchar* cat_string = "^CAT *{.*}";

static re_pattern_buffer* raise_regex = NULL;
static gchar* raise_string = "RAISE.*{.*}";
static re_pattern_buffer* lower_regex = NULL;
static gchar* lower_string = "LOWER.*{.*}";
static re_pattern_buffer* hide_regex = NULL;
static gchar* hide_string = "HIDE.*{.*}";
static re_pattern_buffer* alert_regex = NULL;
static gchar* alert_string = "ALERT.*{.*}";
static re_pattern_buffer* notice_regex = NULL;
static gchar* notice_string = "NOTICE.*{.*}";
static re_pattern_buffer* uniconify_regex = NULL;
static gchar* uniconify_string = "UNICONIFY.*{.*}";
static re_pattern_buffer* execute_regex = NULL;
static gchar* execute_string = "EXECUTE.*{.*}.*{.*}";
static re_pattern_buffer* invert_regex = NULL;
static gchar* invert_string = "INVERT.*{.*}";
static re_pattern_buffer* case_sensitive_regex = NULL;
static gchar* case_sensitive_string = "CASE_SENSITIVE.*{.*}";


static re_pattern_buffer** all_regex[] =
{
  &tail_regex,
  &cat_regex,
  &raise_regex,
  &lower_regex,
  &hide_regex,
  &alert_regex,
  &notice_regex,
  &uniconify_regex,
  &execute_regex,
  &invert_regex,
  &case_sensitive_regex,
  NULL
};

static gchar* all_string[] =
{
  tail_string,
  cat_string,
  raise_string,
  lower_string,
  hide_string,
  alert_string,
  notice_string,
  uniconify_string,
  execute_string,
  invert_string,
  case_sensitive_string,
  NULL
};

static re_pattern_buffer** mode_regex[] =
{
  &tail_regex,
  &cat_regex,
  NULL
};

static gint mode_flags[] =
{
  TAIL_FILE,
  CAT_FILE
};

static re_pattern_buffer** filter_regex[] =
{
  &raise_regex,
  &lower_regex,
  &hide_regex,
  &alert_regex,
  &notice_regex,
  &uniconify_regex,
  &execute_regex,
  &invert_regex,
  &case_sensitive_regex,
  NULL
};

static gint filter_flags[] =
{
  RAISE,
  LOWER,
  HIDE,
  ALERT,
  NOTICE,
  UNICONIFY,
  EXECUTE,
  INVERT,
  CASE_SENSITIVE
};

/*}}}*/





/*{{{  Subroutines  */
int read_configuration(char*);
void add_mode_entry(gint, gchar*, gchar*, gchar*, gint);
void add_filter_entry(gchar*, gint, gchar*);

/*}}}*/

/*{{{  Matching subroutines  */

gint legalize(gint, gint);
int match(char*, char*, int);
int searchfor(char, char*, int);
char* getstring(char , char* , int );
char* clean_string(char*);

/*}}}*/

/*{{{  REGEX Soubroutines  */
void create_regex_patterns();
void free_regex_patterns();

/*}}}*/

/*{{{  Write configuration  */
int write_configuration(char*);
/*}}}*/


#endif /* FILE_H */
