/*
 * $Id: fileops.c,v 1.7 1998/08/18 19:58:03 jochen Exp $
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * File operations module.
 */

#include "main.h"

extern gxsnmp    *app_info;
extern int        errno;
extern char      *yytext;

/*
 * Local function declarations 
 */
static void     create_file_dialog       (void);
static void     cancel_button_cb         (GtkWidget *widget,
					  gpointer  data);
/* 
 * Local module variables
 */
static GtkWidget *file_dialog = NULL;

/* 
 * Local functions
 */
static void
create_file_dialog ()
{
  struct passwd  *entry;
  char           buf[255];

  entry = getpwuid (getuid ());
  file_dialog = gtk_file_selection_new ("Get Filename");
  gtk_window_position (GTK_WINDOW (file_dialog), GTK_WIN_POS_MOUSE);
  snprintf (buf, sizeof(buf), "%s/%s", entry->pw_dir, DEF_CONFIG_PATH);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_dialog),
				   buf);
  g_print ("%s\n", buf);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION 
				  (file_dialog)->cancel_button),
				  "clicked", 
				  GTK_SIGNAL_FUNC (cancel_button_cb),
				  NULL);
  gtk_widget_show (file_dialog);
}

static void
cancel_button_cb (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide (file_dialog);
}

/*
 * Global functions
 */

int
file_open (char *filename)
{
  /* needs to be written */
  return 1;
}

int 
file_close (char *filename)
{
  /* needs to be written */
  return 1;
}

void
close_file_dialog ()
{
  if (file_dialog)
    gtk_widget_destroy (file_dialog);
}

void 
open_file_dialog ()
{
  if (!file_dialog)
    {
      create_file_dialog ();
      return ;
    }
  if (!GTK_WIDGET_VISIBLE (file_dialog))
    {
      gtk_widget_show (file_dialog);
    }
}

gboolean
load_config ()
{
  struct passwd  *entry;
  char           buf[255];
  struct stat    st_buf;
  extern FILE    *yyin;

  entry = getpwuid (getuid());
  snprintf (buf, sizeof (buf), "%s/%s", entry->pw_dir, DEF_CONFIG_PATH);
  if (stat (buf, &st_buf) < 0)
    {
      if (errno == ENOENT)
	{
	  g_print ("%s don't exist\n", buf);
	}
    }
  else
    {
      snprintf (buf, sizeof (buf), "%s/%s/%s", entry->pw_dir, DEF_CONFIG_PATH,
		DEF_CONFIG_NAME);
      if ( (yyin = fopen (buf, "r")))
	{
	  config_prelude ();
	  if (yyparse ())
	    {
	      config_epilog ();
	      g_print ("parse failed!\n");
	      fclose (yyin);
	      return FALSE;
	    }
	  else
	    {
	      config_epilog ();
	      g_print ("parse success!\n");
	      fclose (yyin);
	      return TRUE;
	    }
	}

    }
  return FALSE;
}

gboolean
save_config ()
{
  char          datebuf[20];
  char          filename[255];
  struct tm     *tim;
  time_t        gm_time;
  struct passwd *entry;
  FILE          *save;
  struct stat   st_buf;
  mode_t        mode;

  mode = S_IRUSR | S_IWUSR | S_IXUSR;
  entry = getpwuid (getuid ());
  snprintf (filename, sizeof (filename), "%s/%s", entry->pw_dir,
	    DEF_CONFIG_PATH);
  if (stat (filename, &st_buf) < 0)
    {
      if (mkdir (filename, mode) < 0 )
	{
	  g_print ("mkdir failed.\n");
	}
    }
  else
    {
      snprintf (filename, sizeof (filename), "%s/%s/%s",
		entry->pw_dir, DEF_CONFIG_PATH, DEF_CONFIG_NAME);
      if ( (save = fopen (filename, "w")))
	{
	  fprintf (save, "%s\n", CONFIG_HEADER);
	  fprintf (save, "/* SNMP CONFIGURATION */\n");
	  fprintf (save, "def_snmp_read = \"%s\"\n", 
		   app_info->current_config.def_snmp_com);
	  fprintf (save, "def_snmp_write = \"%s\"\n",
		   app_info->current_config.def_snmp_wcom);
	  fprintf (save, "def_snmp_retr = %d\n", 
		   app_info->current_config.def_snmp_retr);
	  fprintf (save, "def_snmp_time = %d\n",
		   app_info->current_config.def_snmp_time);
	  fprintf (save, "def_snmp_port = %d\n",
		   app_info->current_config.def_snmp_port);
	  fprintf (save, "/* SQL configuration */\n");
	  fprintf (save, "def_sql_host = \"%s\"\n",
		   app_info->current_config.def_sql_host);
	  fprintf (save, "def_sql_user = \"%s\"\n",
		   app_info->current_config.def_sql_user);
	  fprintf (save, "def_sql_pass = \"%s\"\n",
		   app_info->current_config.def_sql_pass);
	  fprintf (save, "def_sql_db = \"%s\"\n",
		   app_info->current_config.def_sql_db);
	  fprintf (save, "/* End of configuration */\n");
	  gm_time = time (NULL);
	  tim     = localtime (&gm_time);
	  strftime (datebuf, sizeof (datebuf), "%Y/%m/%d %H:%M:%S", tim);
	  fprintf (save, "/* Configuration generated on %s */\n", 
		   datebuf);
	  fclose (save);
	}
    }
  return TRUE;
}

int
yywrap ()
{
   return (1);
}

void
yyerror (char *err_str)
{
  fprintf (stderr, "%s, %s\n", err_str, yytext);
}

void
warning (char *warn, char *t)
{
  fprintf (stderr, "%s", warn);
  if (t)
    fprintf (stderr, " %s\n", t);
}
/* EOF */
