#! /bin/sh

# Debian uses a patch for egcs-1.1.1, which changes the name of the
# shared library; nothing is required to run binaries (compiled on other
# systems) on Debian GNU/Linux. If you want to run binaries compiled
# against the Debian libstdc++ on another non Debian system not using
# this patch, you have to generate this library on the other system:

# 	g++ -shared -o /usr/local/lib/libstdc++-libc6.0-1.so.2 -lm
# 	ldconfig # as root

# This patch already is in the mainline sources, so this library isn't
# necessary in the (far) future, when egcs-1.2 probably will be released.
# For a rationale why Debian applied this patch, please see
# 	http://www.cygnus.com/ml/egcs-patches/1998-Jun/0663.html
# and followups. On some architectures Debian is already migrating to libc6.1.

PATH=/usr/bin:/bin:/sbin

if [ -f /etc/debian_version ]; then
    echo >&2 "This script isn't supposed to run on a Debian system."
    exit 1
fi

if [ -w /usr/local/lib ]; then
    dir=/usr/local/lib
elif [ -w /usr/lib ]; then
    dir=/usr/lib
else
    echo >&2 "Unable to write to /usr/local/lib or /usr/lib"
    exit 1
fi

lib=libstdc++-libc6.0-1.so.2

if [ -e "$dir/$lib" ]; then
    echo >&2 "The file $dir/$lib already exists."
    echo >&2 "Please rename or remove it and rerun this script"
    exit 1
fi

if g++ -shared -o $dir/$lib -lm ; then
    echo "Installed $dir/$lib"
else
    echo >&2 "Could not install $dir/$lib"
    exit 1
fi

if [ "$dir" != /usr/lib ]; then
    if grep -q "^$dir$" /etc/ld.so.conf; then
	:
    else
	echo "Please add $dir to /etc/ld.so.conf, then run ldconfig (as root)"
	exit 1
    fi
fi

if [ `whoami` != root ]; then
    echo >&2 "Please run (as root): ldconfig"
    exit 1
fi

ldconfig

echo "Configured $dir/$lib"
