 /*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: file_list.cpp,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "file_list.h"

/*---------------------------------------------------------------------------*/
FileListWidget::FileListWidget(QWidget         *parent,
                               const char      *name,
                               UpDownScroll    *ud,
                               LeftRightScroll *lr,
                               VFSL_Class      *temp_class,
                               OptionsPopup    *temp_pr,
                               OperationPopup  *temp_op):QWidget(parent,
                                                                name)
{
	tree_top = NULL;
	tree_node = NULL;

	scroll_ud = ud;
	scroll_lr = lr;

	y_off_right = 0;

	dnd_active = FALSE;
    attempt_dnd= FALSE;

	//multiple_select = FALSE;
	select_active = 0;
	has_focus = FALSE;
	x_new = 0;
	y_new = 0;
	x_start = 0;
	y_start = 0;
	x_old = 0;
	y_old = 0;

	still_dragging_on = FALSE;

	mouse_popup =temp_pr;
	op_popup    =temp_op;

	io_class    = temp_class;
}
/*---------------------------------------------------------------------------*/
void FileListWidget::remove_focus (void)
{
 has_focus=FALSE;
}
/*---------------------------------------------------------------------------*/
void FileListWidget::set_focus (void)
{
 has_focus=TRUE;
}
/*---------------------------------------------------------------------------*/
char FileListWidget::get_focus (void)
{
 return (has_focus);
}
/*---------------------------------------------------------------------------*/
void FileListWidget::drag_and_drop(bool yes_or_no)
{
 dnd_active=yes_or_no;

}
/*---------------------------------------------------------------------------*/
int FileListWidget::count_selection()
{
 int i=0;

 FileTreeNode *temp_list=tree_top;

 while (temp_list!=NULL)
 {
  if (temp_list->node_selected ()==TRUE)
    i++;

  temp_list=temp_list->get_next();
 }

 return (i);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileListWidget::get_target()
{
  return (the_root->get_target ());
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileListWidget::get_filelist()
{
  return (tree_top);
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::update_pane()
{
	update();
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::update_uds(int new_val)
{
	y_off_right = new_val;
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::deselect()
{
	if (tree_top != NULL)
		tree_top->deselect_nodes();
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::redraw()
{
	// update();
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::set_root_node(FileTreeNode * new_root)
{
	tree_top = new_root;
	tree_node = new_root;
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::set_the_root(FileTreeNode * new_root)
{
	the_root = new_root;
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::selection_removed()
{
   select_active = 1;
   repaint (FALSE);
   select_active = 0;

   deselect();
}
/*---------------------------------------------------------------------------*/
void FileListWidget::compose_directory(FileTreeNode * selected_node)
{
	compose_dir[0] = 0;

	if ((selected_node != NULL) && (the_root != NULL))
	{
		selected_node->set_target(TRUE);
		the_root->compose_directory();
		selected_node->set_target(FALSE);
	}
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::reset_root_node(FileTreeNode * new_root)
{
	tree_top = new_root;
	tree_node = new_root;
	update();
}
/*---------------------------------------------------------------------------*/
void FileListWidget::select_all (void)
{
 
 if (tree_top!=NULL)
 {
   if (has_focus==FALSE)
   {
    emit take_focus ();     // selfish code, weird
    emit update_widgets (); // make sure all is clear 
   }
 
   FileTreeNode *temp_node=tree_top;

   while (temp_node!=NULL)
   {
    temp_node->select_node (TRUE);
    temp_node=temp_node->get_next ();
   }
 }

 update ();
}
/*---------------------------------------------------------------------------*/
void FileListWidget::select_inverse (void)
{
 if (tree_top!=NULL)
 { 
   if (has_focus==FALSE)
   {
    emit take_focus ();     // selfish code, weird
    emit update_widgets (); // make sure all is clear
   }

   FileTreeNode *temp_node=tree_top;

   while (temp_node!=NULL)
   {
    if (temp_node->node_selected ()==TRUE)
      temp_node->select_node (FALSE);
    else
      temp_node->select_node (TRUE);

    temp_node=temp_node->get_next ();
   }
 }

 update ();
}
/*---------------------------------------------------------------------------*/
/*  WARNING, this function should get a locking mechanism !!!!               */
/*---------------------------------------------------------------------------*/
void    FileListWidget::reread_dir (const char *target_dir)
{
 FileTreeNode *the_parent;

 the_parent=tree_top->get_parent ();

 the_parent->remove_tree ();

 io_class->vfsl_read_directory (the_parent,
								(char *) target_dir); 

 set_root_node (the_parent->get_tree_top ());

 if (tree_top==NULL)
  the_parent->set_expandable (FALSE);
 else  
  the_parent->set_expandable (TRUE);

 emit update_widgets ();
 update ();
}
/*---------------------------------------------------------------------------*/
/*  WARNING, this function should get a locking mechanism !!!!               */
/*---------------------------------------------------------------------------*/
void FileListWidget::reread_list ()
{
 FileTreeNode *the_parent;

 the_parent=tree_top->get_parent ();

 the_parent->remove_tree ();

 the_parent->set_target (TRUE);
 the_root->compose_directory();
 the_parent->set_target (FALSE);

 io_class->vfsl_read_directory (the_parent,
								compose_dir); 

 set_root_node (the_parent->get_tree_top ());

 if (tree_top==NULL)
  the_parent->set_expandable (FALSE);
 else  
  the_parent->set_expandable (TRUE);

 emit update_widgets ();
 update ();
}
/*---------------------------------------------------------------------------*/
void FileListWidget::resizeEvent(QResizeEvent * /*e*/)
{

}
/*---------------------------------------------------------------------------*/
void FileListWidget::paintEvent(QPaintEvent * e)
{
	int     y_diff;

	nr_objects = 0;
	y_wide     = Y_BORDER;
	x_offset   = X_BORDER;		// reset all icons 
	y_offset   = Y_BORDER;		// reset all icons 

	if (multiple_select == FALSE)
	{
		if (select_active == 0)
		{
			// >------- Draw file icons + names

			if ((tree_top != NULL) && (isVisible()))
			{
               if (tree_top->has_access ()==TRUE)
               {
                  if (dnd_active == TRUE)
                    tree_top->show_node_list_target (e, this, height(), TRUE);
                  else
                    tree_top->show_node_list(e, this, height(), get_focus ());

                  emit set_nr_objects(nr_objects);

                  if (y_wide > height())
                  {
                    y_diff = y_wide - height();
                    scroll_ud->setRange(0, y_diff);
                    scroll_ud->setSteps(NODE_HEIGHT, height());
                  }
                  else
                    scroll_ud->setRange(0, 0);
               } 
            }
            else
            {
                emit set_nr_objects (0);
                scroll_ud->setRange (0,0);
            }

			// >------- Draw file sizes

			if ((tree_top != NULL) && (isVisible()))
			{
               if (tree_top->has_access ()==TRUE)
               {
                 total_size = 0;
                 total_files = 0;
                 x_offset = X_BORDER;	// reset all icons 
                 y_offset = Y_BORDER;	// reset all icons 

                 tree_top->show_size_list(e, this, height());

                 emit    set_files_info(total_files, total_size);
               }  
            }
            else
            {
                // frame4->set_info (0,0);
                emit set_files_info(0, 0);
            }

			// >--------- Draw file rights

			if ((tree_top != NULL) && (isVisible()))
			{
               if (tree_top->has_access ()==TRUE)
               {  
                  x_offset = X_BORDER;	// reset all icons 
                  y_offset = Y_BORDER;	// reset all icons 
                  tree_top->show_rights_list(e, this, height());
               }  
            }
		}
		else
		{
			if ((tree_top != NULL) && (isVisible()))
			{
               if (tree_top->has_access ()==TRUE)
               {   
              
                  if (select_active == 1)
                    tree_top->show_node_list_selected(e, this, height(), TRUE);
                  else
                  {
                    tree_top->show_node_list_selected(e, this, height(), FALSE);
                      select_active = 0;
                  }
               } 
            }
        }
	}
	else
	{
		QPainter paint;

		paint.begin(this);
		paint.setPen(white);
		paint.setBrush(NoBrush);

		paint.setRasterOp(XorROP);

		draw_rect (&paint,
                   x_start,y_start, 
                   x_old  ,y_old);

		draw_rect (&paint,
                   x_start,y_start, 
                   x_new  ,y_new);

		paint.setRasterOp(CopyROP);

		paint.end();
	}

}
/*---------------------------------------------------------------------------*/
/*
   static FileTreeNode *last_node=0; 

  if (e->state() & ShiftButton)
  {
    emit dragging_and_dropping(FALSE);

    selected_node = tree_top->find_selected_node_list(e->pos().x(),
                                                      e->pos().y());

    if (!selected_node)
      return;

    deselect();

    FileTreeNode *p;
    int action = 0;

    if (!last_node)
    {
      select_active = 1;
      repaint (FALSE);

      emit remove_selection ();  

      selected_node->select_node(TRUE);

      select_active = 2;
      repaint (FALSE);
      last_node = selected_node;

      return;

    }

    // select all nodes between last and this node..-

    p = tree_top;

    select_active = 1;
    repaint (FALSE);

    deselect();

    select_active = 2;
    repaint (FALSE);

    for (; p != 0; p = p->get_next())
    {
       if (p == last_node || p == selected_node)
       {
          if (action)
          {
             if (p)
              p->select_node(TRUE);
             break;
          }

          action = 1;

       }
       if (action && p)
       {
         // fprintf(stderr,"select %s\n",p->get_node_name());
         p->select_node(TRUE);
       }
    }

    selected_node->select_node(TRUE);

    update();
    mouse_locked=FALSE;
    return;
  }

  last_node = selected_node;
*/
/*---------------------------------------------------------------------------*/
void FileListWidget::evaluate_mbutton (QMouseEvent *e,
                                       FileTreeNode *selected_node)
{
  emit take_focus (); 

  select_active = 1;
  repaint (FALSE);
                  
  if (!(e->state() & ControlButton))
  {
    deselect();                 
    emit remove_selection (); 
  }  

  selected_node->select_node (TRUE);

  select_active = 2;
  repaint (FALSE);
}
/*---------------------------------------------------------------------------*/
void FileListWidget::mouseReleaseEvent(QMouseEvent * e)
{
 FileTreeNode *selected_node = NULL;

 QPoint  new_coors = mapToGlobal(e->pos());

 // you get a MouseReleaseEvent after a press even this means
 // we do not have to recalc the list

 if ((e->button() == RightButton) && (tree_top != NULL))
 {
    selected_node = NULL;
    selected_node = tree_top->find_selected_node_list (e->pos().x(),
                                                       e->pos().y());

    if (selected_node != NULL)
    {
       if (selected_node->node_selected() == TRUE)
       {
         if (dnd_active==FALSE)
         {
           if (mouse_popup!=NULL)
           {  
              if (count_selection()>1)
                mouse_popup->set_multiple_entries (TRUE); 
              else
                mouse_popup->set_multiple_entries (FALSE);
 
              // >---------- create directory to the node
              compose_directory(selected_node);
 
              mouse_popup->move(new_coors.x(),
                                new_coors.y());
              mouse_popup->assign_node(selected_node,
                                       compose_dir);
              mouse_popup->show();
           }
         }
       }
    }
    else
    {
      if ((op_popup!=NULL) && (dnd_active==TRUE))
      {           
             // >---------- create directory to the node
             compose_directory(selected_node);

             op_popup->move (new_coors.x(),
                             new_coors.y());
             op_popup->assign_node(selected_node,
                                   compose_dir);
             op_popup->show ();
      }
    }
 }
  
 if ((e->button() == LeftButton) && (dnd_active==TRUE))
  emit dragging_and_dropping (FALSE);

 if (multiple_select==TRUE)
 {
   x_new=x_start;
   y_new=y_start;
   multiple_select=FALSE;
   update ();
 } 

}
/*---------------------------------------------------------------------------*/
void FileListWidget::mousePressEvent(QMouseEvent * e)
{
 FileTreeNode *selected_node;

 if (mouse_locked == FALSE)
 {
   mouse_locked = TRUE;


   // first calculate some important variables


   // QPoint  new_coors = mapToGlobal(e->pos()); UNUSED

   x_offset = X_BORDER;
   y_offset = Y_BORDER;

   if (tree_top!=NULL)
     tree_top->recalc_list();


   // Check for the right mouse button


   if ((e->button() == RightButton) && (tree_top != NULL))
   {
     selected_node = NULL;
     selected_node = tree_top->find_selected_node_list (e->pos().x(),
                                                        e->pos().y());

     if (selected_node != NULL)
     {
        if (selected_node->node_selected() == TRUE)
          attempt_dnd=TRUE;  
     }  

   }

   // Then check for the left mouse button


   if ((e->button() == LeftButton) && (tree_top != NULL))
   {
       selected_node = NULL;
       selected_node = tree_top->find_selected_node_list (e->pos().x(),
                                                          e->pos().y());

       if (selected_node == NULL)
       {
         x_old = x_start = x_new = e->pos().x();
         y_old = y_start = y_new = e->pos().y();

         select_active = 1;
         repaint (FALSE);

         deselect();

         select_active = 2;
         repaint (FALSE);

         if (has_focus==FALSE)
         { 
           emit take_focus (); 
           emit remove_selection ();
         }

         multiple_select = TRUE;
       }
       else
       {
         if (selected_node->node_selected() == TRUE)
           emit dragging_and_dropping(TRUE);
         else
           evaluate_mbutton (e,selected_node); 
       }
   }

   mouse_locked = FALSE;
 }
}
/*---------------------------------------------------------------------------*/
void FileListWidget::mouseDoubleClickEvent(QMouseEvent * e)
{
 if (mouse_locked == FALSE)
 {
   mouse_locked = TRUE;

   emit take_focus ();

   // >-------- in this case it means executing the command if it is 
   // >-------- a program --x 

   // >-------- or entering a directory if the node represents a directory
   FileTreeNode *selected_node = NULL;

   if ((e->button() == LeftButton) && (tree_top != NULL))
   {
      x_offset = X_BORDER;
      y_offset = Y_BORDER;
      tree_top->recalc_list();

      selected_node = tree_top->find_selected_node_list (e->pos().x(),
                                                         e->pos().y());
      if (selected_node!=NULL)
      { 
         if (selected_node->get_file_type() == NODE_ISDIR)
         {
          deselect();		// current files

          multiple_select = FALSE;

          emit    change_dir(selected_node);

          // skipRelease =1; // skip release call..
         }
      } 
   }

   mouse_locked = FALSE;
  }
}
/*---------------------------------------------------------------------------*/
void FileListWidget::mouseMoveEvent (QMouseEvent *e)
{
	int     x1,
	        y1,
	        x2,
	        y2;

	if (mouse_locked == FALSE)
	{
		mouse_locked = TRUE;

        if (attempt_dnd==TRUE)
        {
         emit dragging_and_dropping(TRUE);
         attempt_dnd=FALSE;
        } 

        if (dnd_active==TRUE)
        {
         QPoint new_point=mapToGlobal (e->pos());
         emit signal_movement (new_point);   
        }

		// >-------- only valid if we are NOT dragging and dropping

		if ((multiple_select == TRUE) && (still_dragging_on == FALSE))
		{
			still_dragging_on = TRUE;

			x_new = e->pos().x();
			y_new = e->pos().y();

			repaint(FALSE);

			if (tree_top != NULL)
			{
				multiple_select = FALSE;
				select_active = 1;
				repaint (FALSE);

				// >-------------- make sure x2 is larger than x1

				if (x_new < x_start)
				{
					x1 = x_new;
					x2 = x_start;
				}
				else
				{
					x1 = x_start;
					x2 = x_new;
				}

				// >-------------- make sure y2 is larger than y1

				if (y_new < y_start)
				{
					y1 = y_new;
					y2 = y_start;
				}
				else
				{
					y1 = y_start;
					y2 = y_new;
				}

                // >-------------- compensate for clipping region

                if (x2>button1_clip)
                 x2=button1_clip; 

				// >-------------- now see if we can stir some nodes

				tree_top->find_selected_node_list_m (x1, y1, x2, y2);

				select_active = 2;
				repaint (FALSE);
				multiple_select = TRUE;
			}

			x_old = x_new;
			y_old = y_new;

			still_dragging_on = FALSE;
		}

		mouse_locked = FALSE;
	}
}
/*---------------------------------------------------------------------------*/
void    FileListWidget::closeEvent(QCloseEvent * /* e */)
{
//	delete(this); Hmmm 
}
/*---------------------------------------------------------------------------*/
void FileListWidget::set_clip_bounds (int clip1,int clip2,int clip3)
{
 button1_clip=clip1;
 button2_clip=clip2;
 button3_clip=clip3;
}
/*---------------------------------------------------------------------------*/






/*---------------------------------------------------------------------------*/
FileListContainer::FileListContainer(QWidget        *parent,
                                     const char     *name,
                                     VFSL_Class     *temp_class,
                                     OptionsPopup   *temp_op,
                                     OperationPopup *temp_pr):QFrame(parent,
                                                                     name)
{

	setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

	Name = new QPushButton("Name", this, "Name");
	Size = new QPushButton("Size", this, "Size");
	Rights = new QPushButton("Permissions", this, "Permissions");

	fill_btn2 = new QPushButton(" ", this, "Dummy");

	scroll_ud = new UpDownScroll(this, &y_off_right);
	scroll_lr = new LeftRightScroll(this, &y_off_right);

	child_widget = new FileListWidget(this,
									  "filecontainer",
									  scroll_ud,
									  scroll_lr,
									  temp_class,
                                      temp_op,
                                      temp_pr);

	scroll_ud->set_parent(child_widget);
	scroll_lr->set_parent(child_widget);
}
/*---------------------------------------------------------------------------*/
FileListWidget *FileListContainer::get_child(void)
{
	return (child_widget);
}
/*---------------------------------------------------------------------------*/
void    FileListContainer::resizeEvent(QResizeEvent * /* e */)
{
	int     wdth = width() - 14;	// compensate for right scroll bar

	child_widget->setGeometry(2,
							  2 + BUTTON_HEIGHT,
							  width() - 4 - 14,
							  height() - 4 - 14 - BUTTON_HEIGHT);

	// >--------- button sizes

	name_size = (wdth / 3) - 1;
	size_size = (wdth / 3) - 2;
	rights_size = (wdth / 3) - 3;

    child_widget->set_clip_bounds (name_size,
                                   name_size+size_size,
                                   name_size+size_size+rights_size);

	Name->setGeometry(2,
					  2,
					  (wdth / 3) - 1,
					  BUTTON_HEIGHT);

	Size->setGeometry(wdth / 3 + 2,
					  2,
					  (wdth / 3) - 2,
					  BUTTON_HEIGHT);

	Rights->setGeometry((2 * (wdth / 3)) - 1 + 2,
						2,
						(wdth / 3) - 2 - 3 + 14,
						BUTTON_HEIGHT);

	// >--------- 

	fill_btn2->setGeometry(width() - 16, height() - 16, 14, 14);

	scroll_ud->setGeometry(width() - 16, 2, 14, height() - 18);
	scroll_lr->setGeometry(2, height() - 16, width() - 18, 14);
}
/*---------------------------------------------------------------------------*/
 
