/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 *
 * $RCSfile: ecommand.cpp,v $
 *
 * $Revision: 1.1 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 *
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "ecommand.h"

const char *command_line=NULL;
const char *last_command=NULL;

/*---------------------------------------------------------------------------*/
int ECommandClass::create_tokens (int index)
{
 command_line=text (index);
 
 if (last_command==NULL)
  last_command=command_line;
 
 if (strcmp (command_line,last_command)==0)
   printf ("Executing (cached) command\n");
 else
   printf ("Executing command\n");

 last_command=command_line;

 return (0);
}
/*---------------------------------------------------------------------------*/
void ECommandClass::interpret (int index)
{
 int nr_tokens=0,i=0;

 nr_tokens=create_tokens (index);

 // it's just a stupid looptieloop

 while (i<nr_tokens)
 {
    // first the basics 

    if ((strcmp (tokens [i],"exit")==0) || (strcmp (tokens [i],"quit")==0))
     emit c_exit ();

    // explorer specific stuff

    if (strcmp (tokens [i],"select")==0)
     emit c_select (tokens [i+1]); 
 
    if (strcmp (tokens [i],"select_inv")==0)
     emit c_select_inv (); 

    // msdos command versions

    if (strcmp (tokens [i],"copy")==0)
     emit c_copy (tokens [i+1]); 

    if (strcmp (tokens [i],"move")==0)
     emit c_move (tokens [i+1]); 

    if (strcmp (tokens [i],"delete")==0)
     emit c_delete (tokens [i+1]); 

    // unix command versions

    if (strcmp (tokens [i],"cp")==0)
     emit c_copy (tokens [i+1]); 

    if (strcmp (tokens [i],"mv")==0)
     emit c_move (tokens [i+1]); 

    if (strcmp (tokens [i],"rm")==0)
     emit c_delete (tokens [i+1]); 

    // and now for the commands that don't matter 

    if (strcmp (tokens [i],"cd")==0)
     emit c_cd (tokens [i+1]); 

    if (strcmp (tokens [i],"find")==0)
     emit c_find (tokens [i+1]); 

    if (strcmp (tokens [i],"mount")==0)
     emit c_mount (tokens [i+1]); 

    if ((strcmp (tokens [i],"umount")==0) || (strcmp (tokens [i],"unmount")==0))
     emit c_umount (tokens [i+1]); 

  i++;
 }

}
/*---------------------------------------------------------------------------*/
ECommandClass::ECommandClass (QWidget *parent=0,
                              const char *name=0) : QComboBox (TRUE,parent,name)
{
 connect (this,
          SIGNAL (activated (int)),
          this,
          SLOT (interpret (int)));

 setMinimumSize ( 200,20);
 setMaximumSize (4200,20); 
}
/*---------------------------------------------------------------------------*/

