
/******************************************************************************
 * Copyright (c) 1996 Netscape Communications. All rights reserved.
 ******************************************************************************/

#include <stdio.h>
#include "npapi.h"
#include <sys/types.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>


#ifndef NS_DIR
#define NS_DIR "/usr/local/lib/netscape/"
#endif

#ifndef CONF_FILE
#define CONF_FILE "xswallow.conf"
#endif

#define MEMORY_CHUNK_SIZE 4096
#define MAX_ENTRY_LENGTH 512
#define MAX_FIELD_LENGTH 128
#define MAX_FILE_NAME_LENGTH 4096
#define GIVEUP 4000

#define NAME "XSwallow Ver 1"
#define PURPOSE "XSwallow (Ver 1.0.12) can run an ordinary X app or commandline utility \
for each mime type registered in xswallow.conf in response to the html \
embed tag, and then swallows the resulting app (in the case of X apps) into the space created in \
the netscape window giving the illusion that theres a custom built plugin \
for that type. .Full details are \
available at <a href=\"http://skynet.csn.ul.ie/~caolan/docs/Xswallow.html\">this page</a>, \
you should read it as theres a few configuration issues that you'll probably have to \
address"



/************************************************************
this struct holds all the data for a particular
entry in the configuration file

commandLine is the command line to pass to execv
mimeType is the MIME type to register with Netscape
extensions is a comma delimited list of extensions for
the mimeType
next is a link to the next entry in the list

************************************************************/

#define MAXFILELEN 4096
struct nod5
    {
    char word[MAXFILELEN];
    struct nod5 *next;
    };

typedef struct nod5 string_list;


typedef struct singleEntryStructure
    {
    char *mimeType;
    char *extensions;
    char *commandLine;
	string_list *swallownames;
    char *description;
    struct singleEntryStructure *next;
    }
entryStruct;


/************************************************************
This is a pointer to the first entry in the list
************************************************************/

entryStruct *entryHead;

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <string.h>

#define REPARENT_LOOPS 50

int abortflag;


/***********************************************************************
* Instance state information about the plugin.
*
* PLUGIN DEVELOPERS:
* Use this struct to hold per-instance information that you'll
* need in the various functions in this file.
***********************************************************************/

typedef struct _PluginInstance
    {
    Window window;
    Window victim;
    Widget resizewatch;
	Widget netscape_widget;
    Display *display;
    uint32 x, y;
    uint32 width, height;
    entryStruct *entry;
    int ran;
	int child_pid;
	XtIntervalId timerid;
	int count;
	int fullscreen;
	char *fname;
	char *url;
    }
PluginInstance;

void Redraw (Widget w, XtPointer closure, XEvent * event);
void resizeCB (Widget, PluginInstance *, XEvent *, Boolean *);
entryStruct *findEntryForMIMEType (char *);
int validMIMEType (entryStruct *, char *);
void readEntries2 (char *);
string_list *parse_line (char *, int *);
void add_string (char *, string_list *);
void abortswallow(int );
void abortswallowX(Widget, XtPointer , XEvent *);
void do_swallow (PluginInstance * );
void swallow_check(PluginInstance *);
int run_child (char *,const char *,const char *,int ,int );

int validMIMEType (entryStruct * entry, char *mimeType)
    {
    return (strcmp (entry->mimeType,
                    mimeType));
    }

entryStruct * findEntryForMIMEType (char *mimeType)
    {
    entryStruct *currentEntry = entryHead;

    while (currentEntry != NULL)
        {
        if (validMIMEType (currentEntry, mimeType) == 0)
            return (currentEntry);

        currentEntry = currentEntry->next;
        }

    return (NULL);
    }        
            
           
char * removeLeadingSpaces (char *buff)
    {
	int temp=0;
	int to = strlen(buff);
	while(temp<to)
		{
		if (!(isspace(buff[temp])))
			break;
		temp++;
		}
	
	if (temp < strlen(buff))
    	memmove (buff, buff + temp,to+1-temp);
	else
		buff[0] = '\0';
    return (buff);
    }

char * removeTrailingSpaces (char *buff)
    {
    int buffLen = strlen (buff);

    while (isspace(buff[buffLen - 1]) && (buffLen > 0))
        --buffLen;

    buff[buffLen] = '\0';

    return (buff);
    }


void freeEntryStruct (entryStruct * entry)
    {
	string_list *temp1;
	string_list *temp2;
    if (entry != NULL)
        {
        free (entry->mimeType);
        free (entry->extensions);
        free (entry->commandLine);
		temp1 = entry->swallownames;
		if (temp1 != NULL)
			{
			if (temp1->next != NULL)
				temp2 = temp1->next;
			else
				temp2 = NULL;
			free(temp1);
			temp1 = temp2;
			}
        /*free (entry->swallowname);*/
        free (entry->description);

        free (entry);
        }             
    }
    
char *getPluginPath ()
    {
    char *pluginPath;

    if ((pluginPath = getenv ("NPX_PLUGIN_PATH")) == NULL)
        {
        pluginPath = (char *) malloc (sizeof (char) * (2 * MEMORY_CHUNK_SIZE));

#ifdef SNPRINTF
        if (snprintf (pluginPath,2 * MEMORY_CHUNK_SIZE,
		"%s%s:%s/%s", NS_DIR, "plugins/", getenv ("HOME"), 
		".netscape/plugins/") == 2 * MEMORY_CHUNK_SIZE)
		fprintf(stderr,"if you didnt have snprintf youd be dead now\n");
#else
     sprintf (pluginPath,
		"%s%s:%s/%s", NS_DIR, "plugins/", getenv ("HOME"), 
		".netscape/plugins/");
#endif
        }

    return (pluginPath);
    }

char * getNextEntry (FILE * fptr, char *buff)
    {
    while (fgets (buff, MAX_ENTRY_LENGTH, fptr) != NULL)
        {
        if ((buff[0] != '#') && (buff[0] != '\n'))
            {
            if (buff[strlen (buff) - 1] == '\n')
                buff[strlen (buff) - 1] = '\0';
            return (buff);
            }
        }   
           
    return (NULL);
    }       
           
char * removeAllSpaces (char *buff)
    {
    char ch;
    char *newBuff;
    int i = 0, j = 0;
    newBuff = (char *) malloc ((strlen (buff) + 1));

    while ((ch = buff[i++]) != '\0')
        {
        if (ch != ' ')
            newBuff[j++] = ch;
        }
    newBuff[j] = '\0';
    strcpy (buff, newBuff);
    free (newBuff);
    return (buff);
    }            
                
char * removeLeadingAndTrailingSpaces (char *buff)
    {
    removeLeadingSpaces (buff);
    removeTrailingSpaces (buff);
    return (buff);
    } 
    
int countNumberOfTokens (char *str, char *delimeters)
    {
    int numberOfTokens = 0;
    char *strCopy;
    char *nextToken;

    if (str != NULL)
        {
        strCopy = (char *) malloc (strlen (str) + 1);
        strcpy (strCopy, str);

        nextToken = strtok (strCopy, delimeters);

        while ((++numberOfTokens) &&
               (char *) strtok (NULL, delimeters) != NULL)
            {
            }

        free (strCopy);
        }
	return(numberOfTokens);
    }   
       
entryStruct * splitFields (char *buff)
    {
    entryStruct *entry = NULL;
    char *buffCopy;
    char *nextField;
	int no_swallows=0;

    if (buff[strlen (buff) - 1] == '\n')
    	buff[strlen (buff) - 1] = '\0';
        
    if (countNumberOfTokens (buff, ";") >= 4)
        {
        buffCopy = (char *) malloc (sizeof (char) * (strlen (buff) + 1));
        strcpy (buffCopy, buff);

        entry = (entryStruct *) malloc (sizeof (entryStruct));

        entry->mimeType = NULL;
        entry->extensions = NULL;
        entry->commandLine = NULL;
        entry->swallownames = NULL;
        entry->description = NULL;
        entry->next = NULL;

        if ((nextField = (char *) strtok (buffCopy, ";")) != NULL)
            {
            removeLeadingAndTrailingSpaces (nextField);
            entry->mimeType = (char *) malloc (sizeof (char) * (strlen (nextField) + 1));
            strcpy (entry->mimeType, nextField);
            }

        if ((nextField = (char *) strtok (NULL, ";")) != NULL)
            {
            removeAllSpaces (nextField);
            entry->extensions = (char *) malloc (sizeof (char) * (strlen (nextField) + 1));
            strcpy (entry->extensions, nextField);
            }

        if ((nextField = (char *) strtok (NULL, ";")) != NULL)
            {
            removeLeadingAndTrailingSpaces (nextField);
            entry->commandLine = (char *) malloc (sizeof (char) * (strlen (nextField) + 1));
            strcpy (entry->commandLine, nextField);
            }
 
        if ((nextField = (char *) strtok (NULL, ";")) != NULL)
            {
/*            removeLeadingAndTrailingSpaces (nextField);*/
			/*parse to get values*/
			entry->swallownames = parse_line (nextField, &no_swallows);
            }

        if ((nextField = (char *) strtok (NULL, ";")) != NULL)
            {
            removeLeadingAndTrailingSpaces (nextField);
            entry->description = (char *) malloc (sizeof (char) * (strlen (nextField) + 1));
            strcpy (entry->description, nextField);
            }

        if ((entry->mimeType == NULL) ||
            (entry->extensions == NULL) ||
            (entry->commandLine == NULL) ||
            (entry->swallownames == NULL))
            {
            freeEntryStruct (entry);
            entry = NULL;
            }

        free (buffCopy);
        }

    return (entry);
    }


entryStruct * addOrReplaceEntry (entryStruct * head,
                     entryStruct * newEntry)
    {
    entryStruct *current = head;
    entryStruct *previous = NULL;

    while ((current != NULL) &&
           (strcmp (current->mimeType,
                    newEntry->mimeType) < 0))
        {
        previous = current;
        current = current->next;
        }

    if (current == NULL)
        newEntry->next = NULL;
    else if (strcmp (current->mimeType, newEntry->mimeType) == 0)
        newEntry->next = current->next;
    else
        newEntry->next = current;

    if (current == head)
        head = newEntry;
    else
        previous->next = newEntry;

    if ((current != NULL) && (strcmp (current->mimeType,
       newEntry->mimeType) == 0))
        freeEntryStruct (current);

    return (head);
    }

void readEntries2 (char *pluginPath)
    {
    int numberOfPluginPaths = countNumberOfTokens (pluginPath, ":");
    char **pluginPathArray = NULL;
    char *pluginPathCopy = NULL;
    char *nextPluginPath = NULL;
    int i = 0;
    FILE *fptr;
    char confFileName[MAX_FILE_NAME_LENGTH];
    char buff[MAX_ENTRY_LENGTH];
    entryStruct *newEntry = NULL;


    entryHead = NULL;

    if (numberOfPluginPaths <= 0)
        {
        fprintf(stderr,"Xswallow Plugin: Trouble, couldnt find any config file\n");
        return;
        }

    pluginPathCopy = (char *) malloc (sizeof (char) * (strlen (pluginPath) + 1));
    strcpy (pluginPathCopy, pluginPath);

    pluginPathArray = (char **) malloc (sizeof (char *) * (numberOfPluginPaths + 1));

    nextPluginPath = strtok (pluginPathCopy, ":");

    while (nextPluginPath != NULL)
        {
		if (i > numberOfPluginPaths)
			{
			fprintf(stderr,"xswallow: This shouldn't happen\n");
			exit(-1);
			}
        pluginPathArray[i] = (char *) malloc (sizeof (char) * (strlen (nextPluginPath) + 1));
        strcpy (pluginPathArray[i], nextPluginPath);
        nextPluginPath = strtok (NULL, ":");
        ++i;
        }
    /*pluginPathArray[numberOfPluginPaths] = NULL;*/
	pluginPathArray[i]=NULL;

    free (pluginPathCopy);
    i = 0;

 while (pluginPathArray[i] != NULL)
        {
        strncpy (confFileName, pluginPathArray[i],MAX_FILE_NAME_LENGTH-5-
			strlen(CONF_FILE));
        confFileName[MAX_FILE_NAME_LENGTH-5-
			strlen(CONF_FILE)]='\0';

        if (confFileName[strlen (confFileName) - 1] != '/')
            strcat (confFileName, "/");

        strcat (confFileName, "../");
        strcat (confFileName, CONF_FILE);

        if ((fptr = fopen (confFileName, "r")) == NULL)
            {
            if (errno != ENOENT)
                fprintf (stderr, "xswallow: Unable to open %s for reading: %s\n",
                         confFileName, strerror (errno));
            }
        else
            {
            while (getNextEntry (fptr, buff) != NULL)
                {
                newEntry = NULL;

                if ((newEntry = splitFields (buff)) == NULL)
                    fprintf(stderr,"xswallow: Bad line in configuration file\n\t'%s'\n", buff);
                else
                    {
                    newEntry->next = NULL;
                    entryHead = addOrReplaceEntry (entryHead, newEntry);
                    }
                }

            fclose (fptr);
            }
        free (pluginPathArray[i]);
        ++i;
        }

    free (pluginPathArray);
    }

char * NPP_GetMIMEDescription (void)
    {
    char *mimeDesc;
    int mimeDescSize;
    int needSize = 1;
    char extensions[MAX_FIELD_LENGTH];
    char *description;
    char *originalMIMEDesc;
    int mimeDescLen ;
    entryStruct *currentEntry;

    readEntries2 (getPluginPath());

    currentEntry = entryHead;

    mimeDescSize = MEMORY_CHUNK_SIZE;
    mimeDesc = (char *) malloc (sizeof (char) * MEMORY_CHUNK_SIZE);
    mimeDesc[0] = '\0';

    while (currentEntry != NULL)
        {
        strncpy (extensions, currentEntry->extensions,MAX_FIELD_LENGTH-1);
		extensions[MAX_FIELD_LENGTH-1] = '\0';

/*
 * increment the amount of space we need to store another entry
 * magic number of 3 == 2 seperating colons + seperating semi-colon
 */
        needSize += 3;

/*
 * * * increment the amount of space we need to store the MIME type
 */
        needSize += strlen (currentEntry->mimeType);

/*
 * increment the amount of space we need to store the description
 */
        if (currentEntry->description != NULL)
            description = currentEntry->description;
        else
            description = NAME;

        needSize += strlen (description);

/*
 * allocate space in mimeDesc as we need it
 */
        if (mimeDescSize < needSize)
            {
/* store the old one so we don't lose it */
            originalMIMEDesc = mimeDesc;
/* allocate another chunk of memory */
            mimeDescSize += MEMORY_CHUNK_SIZE;
            mimeDesc = (char *) malloc (sizeof (char) * MEMORY_CHUNK_SIZE);

/* copy the old one to the new memory space */
            strncpy (mimeDesc, originalMIMEDesc,MEMORY_CHUNK_SIZE-1);
			mimeDesc[MEMORY_CHUNK_SIZE] = '\0';

/* free up the memory used by the old one */
            free (originalMIMEDesc);
            }                        
                                
#ifdef SNPRINTF
        if(snprintf (mimeDesc,MEMORY_CHUNK_SIZE,
                 "%s%s:%s:%s;",
                 mimeDesc,
                 currentEntry->mimeType,
                 extensions,
                 description) == MEMORY_CHUNK_SIZE)
		fprintf(stderr,"if you didnt have snprintf youd be dead now\n");
#else
		sprintf (mimeDesc,
                 "%s%s:%s:%s;",
                 mimeDesc,
                 currentEntry->mimeType,
                 extensions,
                 description);
#endif

/* move onto the next one */
        currentEntry = currentEntry->next;
        }

/*remove the very last semi-colon */
        mimeDescLen = strlen (mimeDesc);

        if ((mimeDescLen > 0) && (mimeDescLen <= MEMORY_CHUNK_SIZE-1))
            mimeDesc[mimeDescLen - 1] = '\0';
    return (mimeDesc);
    }

NPError
NPP_GetValue (void *future, NPPVariable variable, void *value)
    {
    NPError err = NPERR_NO_ERROR;

    switch (variable)
        {
        case NPPVpluginNameString:
            *((char **) value) = NAME;
            break;
        case NPPVpluginDescriptionString:
            *((char **) value) = PURPOSE;
            break;
        default:
            err = NPERR_GENERIC_ERROR;
        }
    return err;
    }

NPError
NPP_Initialize (void)
    {
    readEntries2 (getPluginPath ());
    return NPERR_NO_ERROR;
    }


jref
NPP_GetJavaClass ()
    {
    return NULL;
    }

void
  NPP_Shutdown (void)
    {
    }


NPError
NPP_New (NPMIMEType mimeType,
         NPP instance,
         uint16 mode,
         int16 argc,
         char *argn[],
         char *argv[],
         NPSavedData * saved)
    {
    PluginInstance *This;


    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;


    instance->pdata = NPN_MemAlloc (sizeof (PluginInstance));

    This = (PluginInstance *) instance->pdata;
    if (This == NULL)
        return NPERR_OUT_OF_MEMORY_ERROR;

/*
 * * * If we know how to handle that MIME type
 */
    if ((This->entry = findEntryForMIMEType (mimeType)) == NULL)
        return (NPERR_FILE_NOT_FOUND);
	This->count=0;
	This->timerid=-1;
	This->child_pid = -1;
	This->fullscreen=0;
    This->victim=0;;
	This->width=0;
	This->height=0;
	This->url=NULL;
	This->fname=NULL;
	This->netscape_widget = NULL;
    return NPERR_NO_ERROR;
    }


NPError
NPP_Destroy (NPP instance, NPSavedData ** save)
    {
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance *) instance->pdata;

    if (This != NULL)
        {
		if ((This->timerid != -1) && (This->timerid != -2))
			XtRemoveTimeOut(This->timerid);

		if (This->ran == 2)
    		XtRemoveEventHandler (This->resizewatch, StructureNotifyMask, False, (XtEventHandler) resizeCB, (XtPointer) This);

		/*kill child*/
		if (This->child_pid != -1)
			kill(This->child_pid*-1,SIGTERM); /*this should kill all children down along*/
/*
			killpg(This->child_pid,SIGTERM); 
*/
		if (This->url != NULL)
			free(This->url);
		if (This->fname != NULL)
			free(This->fname);
		
        NPN_MemFree (instance->pdata);
        instance->pdata = NULL;
        }

    return NPERR_NO_ERROR;
    }



NPError
NPP_SetWindow (NPP instance, NPWindow * window)
    {
    static int t;
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    if (window == NULL)
        return NPERR_NO_ERROR;

    This = (PluginInstance *) instance->pdata;

    if (t == 0)
        This->window = (Window) window->window;


    This->x = window->x;
    This->y = window->y;
    This->width = window->width;
    This->height = window->height;
    This->display = ((NPSetWindowCallbackStruct *) window->ws_info)->display;

/*
 * caolan begin
 * the app wasnt run yet
 */
    if (This->window != (Window) window->window)
        fprintf (stderr, "xswallow: The bastards!! this shouldnt be happening\n");
	else
		{
		This->window = (Window) window->window;
		This->netscape_widget = XtWindowToWidget (This->display, This->window);
		if (This->ran == 2)
			{
			XReparentWindow (This->display, This->victim, This->window, 0, 0);
			XMapWindow (This->display, This->victim);
			XSync (This->display, FALSE);
			XResizeWindow (This->display, This->victim, This->width, This->height);
			XSync (This->display, FALSE);
			}
		else
			{
			XtAddEventHandler(This->netscape_widget, ExposureMask, FALSE, (XtEventHandler)Redraw, This);
			XtAddEventHandler(This->netscape_widget, ButtonPress, FALSE, (XtEventHandler)abortswallowX, This);
			Redraw(This->netscape_widget, (XtPointer)This, NULL);


			if (This->timerid == -2)
				{
				/*the stream is ready, but the window wasnt ready at the time to 
				add the timer*/
				This->child_pid = run_child (This->entry->commandLine,This->fname,This->url,This->width,This->height);
				if (This->child_pid == -1)
					fprintf(stderr,"xswallow: the attempt to run command %s failed\n",This->entry->commandLine);
				else
					{
					setpgid(This->child_pid,This->child_pid);
					if (This->entry->swallownames != NULL)
						if (This->entry->swallownames->word != NULL)
							if (This->entry->swallownames->word[0] != '\0')
								do_swallow (This); /*in here timerid will be set away from -1*/
					}
				}
			}
		}
    return NPERR_NO_ERROR;
    }


NPError
NPP_NewStream (NPP instance,
               NPMIMEType type,
               NPStream * stream,
               NPBool seekable,
               uint16 * stype)
    {
	/*
    NPByteRange range;
	*/
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance *) instance->pdata;
/*
 * we don't understand how to handle streams, so we must insist
 * that we have a local file name we can use instead, i.e., have
 * Netscape download the data into a temporary file and tell us
 * what the temporary file name is by calling NPP_StreamAsFile
 */
    *stype = NP_ASFILEONLY;

    return NPERR_NO_ERROR;
    }


/*
 * PLUGIN DEVELOPERS:
 * These next 2 functions are directly relevant in a plug-in which
 * handles the data in a streaming manner. If you want zero bytes
 * because no buffer space is YET available, return 0. As long as
 * the stream has not been written to the plugin, Navigator will
 * continue trying to send bytes. If the plugin doesn't want them,
 * just return some large number from NPP_WriteReady(), and
 * ignore them in NPP_Write(). For a NP_ASFILE stream, they are
 * still called but can safely be ignored using this strategy.
 */

int32 STREAMBUFSIZE = 0X0FFFFFFF;    /*
                                     * * * If we are reading from a file in NPAsFile
                                     * * * * mode so we can take any size stream in our
                                     * * * * write call (since we ignore it)
                                     */

int32
NPP_WriteReady (NPP instance, NPStream * stream)
    {
    PluginInstance *This;
    if (instance != NULL)
        This = (PluginInstance *) instance->pdata;

    return STREAMBUFSIZE;
    }


int32
NPP_Write (NPP instance, NPStream * stream, int32 offset, int32 len, void *buffer)
    {
	/*
    if (instance != NULL)
        {
        PluginInstance *This = (PluginInstance *) instance->pdata;
        }
	*/

    return len;                 /*
                                 *The number of bytes accepted
                                 */
    }


NPError
NPP_DestroyStream (NPP instance, NPStream * stream, NPError reason)
    {
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;
    This = (PluginInstance *) instance->pdata;

    return NPERR_NO_ERROR;
    }


void
  NPP_StreamAsFile (NPP instance, NPStream * stream, const char *fname)
    {
    PluginInstance *This;
    if (instance != NULL)
        This = (PluginInstance *) instance->pdata;
    This->ran = 1;

	/*ready to roll*/
	/*but wait until we have a window before we do the bizz*/

	abortflag=0;

	if (This->entry->swallownames != NULL)
		if (This->entry->swallownames->word != NULL)
			if (This->entry->swallownames->word[0] != '\0')
				{
				/*
				this app is to be run in a window, so must have a window
				to be usefull
				*/

				if (This->netscape_widget != NULL)
					{
					This->child_pid = run_child (This->entry->commandLine,fname,stream->url,This->width,This->height);
					if (This->child_pid == -1)
						fprintf(stderr,"xswallow: the attempt to run command %s failed\n",This->entry->commandLine);
					else
						{
						setpgid(This->child_pid,This->child_pid);

						do_swallow (This); /*in here timerid will be set away from -1*/

						}
					}
				else
					{
					This->timerid = -2; /*inform setwindow to run it instead*/
					This->fname = (char *) malloc((strlen(fname) +1) *sizeof(char *));
					strcpy(This->fname,fname);
					This->url = (char *) malloc((strlen(stream->url) +1) *sizeof(char *));
					strcpy(This->url,stream->url);
					}
				}
			else
				{
				/*non windowed app, lock and load now*/
				This->child_pid = run_child (This->entry->commandLine,fname,stream->url,This->width,This->height);
				if (This->child_pid == -1)
					fprintf(stderr,"xswallow: the attempt to run command %s failed\n",This->entry->commandLine);
				else
					setpgid(This->child_pid,This->child_pid);
				}
    }


void
  NPP_Print (NPP instance, NPPrint * printInfo)
    {
    if (printInfo == NULL)
        return;

    if (instance != NULL)
        {
		/*
        PluginInstance *This = (PluginInstance *) instance->pdata;
		*/

        if (printInfo->mode == NP_FULL)
            {
/*
 * PLUGIN DEVELOPERS:
 * If your plugin would like to take over
 * printing completely when it is in full-screen mode,
 * set printInfo->pluginPrinted to TRUE and print your
 * plugin as you see fit. If your plugin wants Netscape
 * to handle printing in this case, set
 * printInfo->pluginPrinted to FALSE (the default) and
 * do nothing. If you do want to handle printing
 * yourself, printOne is true if the print button
 * (as opposed to the print menu) was clicked.
 * On the Macintosh, platformPrint is a THPrint; on
 * Windows, platformPrint is a structure
 * (defined in npapi.h) containing the printer name, port,
 * etc.
 */
/*
            void *platformPrint =
            printInfo->print.fullPrint.platformPrint;
            NPBool printOne =
            printInfo->print.fullPrint.printOne;
*/

/*
 *Do the default
 */
            printInfo->print.fullPrint.pluginPrinted = FALSE;
            }
        else
            {                        /*
                                 * * * If not fullscreen, we must be embedded
                                 */
/*
 *PLUGIN DEVELOPERS:
 *If your plugin is embedded, or is full-screen
 *you returned false in pluginPrinted above, NPP_Print
 *will be called with mode == NP_EMBED. The NPWindow
 *in the printInfo gives the location and dimensions of
 *the embedded plugin on the printed page. On the
 *Macintosh, platformPrint is the printer port; on
 *Windows, platformPrint is the handle to the printing
 *device context.
 */
/*
            NPWindow *printWindow =
            &(printInfo->print.embedPrint.window);
            void *platformPrint =
            printInfo->print.embedPrint.platformPrint;
*/
            }
        }
    }
void
  Redraw (Widget w, XtPointer closure, XEvent * event)
    {
    PluginInstance *This = (PluginInstance *) closure;
    GC gc;
    XGCValues gcv;
    char text[1024];
	char *text2 = "Click to Abort Swallow";
#ifdef SNPRINTF
	if (snprintf(text,1024,
	"of type %s",This->entry->mimeType) == 1024)
	fprintf(stderr,"if you didnt have snprintf youd be dead now\n");
#else
	sprintf(text,
	"of type %s",This->entry->mimeType);
#endif

    XtVaGetValues (w, XtNbackground, &gcv.background,
                   XtNforeground, &gcv.foreground, 0);
    gc = XCreateGC (This->display, This->window,
                    GCForeground | GCBackground, &gcv);

    XDrawRectangle (This->display, This->window, gc,
                    2, 2, This->width - 4, This->height - 4);
    XDrawString (This->display, This->window, gc, This->width / 2 - 100, This->height / 2+20, text, strlen (text));
    XDrawString (This->display, This->window, gc, This->width / 2 - 100, This->height / 2, text2, strlen (text2));

    }

void resizeCB (Widget w, PluginInstance * data, XEvent * event, Boolean * cont)
    {
	Arg args[2];
	Widget temp;


	/*search up to cound hildren of drawingArea, if > 0 then delete, if not the resize*/

	temp = data->netscape_widget;
	    while(strcmp(XtName(temp),"drawingArea"))
		        temp = XtParent(temp);

	if (data->fullscreen ==0)
		{
		XReparentWindow (data->display, data->victim, XtWindow (data->resizewatch), 0, 0);
		XSync (data->display, FALSE);
		}
	else 
		{
		XtSetArg (args[0], XtNwidth, (XtArgVal) &(data->width));
		XtSetArg (args[1], XtNheight, (XtArgVal) &(data->height));
		XtGetValues(temp,args,2);
    	XResizeWindow (data->display, data->window, data->width, data->height);
    	XResizeWindow (data->display, data->victim, data->width, data->height);
		}
	}

int run_child (char *commandLine,const char *filename,const char *urlname,int width,int height)
    {
    int childPID;
    char wtemp[128];
    char htemp[128];
    char *cline[4];
	int len;
    const char **array;
    string_list *list;
    string_list *temp2;
	int parentPID;
    int number;
    int i,j;

	parentPID = getpid();
    list = parse_line (commandLine, &number);
    temp2 = list;
    array = (const char **) malloc ((number + 1) * sizeof (char *));
    if (array == NULL)
        {
        fprintf (stderr, "xswallow: no memory, die die die\n");
        exit (-10);
        }
    i = 0;
    while (temp2 != NULL)
        {
        if (i < number)
            {
			if (!strcmp(temp2->word,"%s")) {
                if(!filename) {
                	fprintf(stderr,"Netscape didnt give Xswallow a filename to work with!!\nYou might ensure that the cache dir exists. (Even if the disc cache is disabled,\nthis is some kind of netscape oversight)\n");
                                return(-1); }
            	array[i] = filename;
                }
			else if (!strcmp(temp2->word,"%u"))
            	array[i] = urlname;
			else if (!strcmp(temp2->word,"%w"))
				{
#ifdef SNPRINTF
				if (snprintf(wtemp,128,
"%d",width) == 128)
	fprintf(stderr,"if you didnt have snprintf youd be dead now\n");
#else
			sprintf(wtemp,
"%d",width) ;
#endif
            	array[i] = wtemp;
				}
			else if (!strcmp(temp2->word,"%h"))
				{
#ifdef SNPRINTF
				if (snprintf(htemp,128,
"%d", height) == 128)
	fprintf(stderr,"if you didnt have snprintf youd be dead now\n");
#else
			sprintf(htemp,
"%d", height);
#endif
            	array[i] = htemp;
				}
			else
            	array[i] = temp2->word;
            i++;
            }
        temp2 = temp2->next;
        }
    array[i] = NULL;

    childPID = fork ();

/*
 * if fork failed 
 */
    if (childPID == -1)
        {
        fprintf(stderr,"xswallow: Fork failed: %s\n", strerror (errno));
        childPID = 0;
        }
    else if (childPID == 0)
        {
		pid_t mine = getpid();
		if  (setpgid(mine,mine) < 0)
			fprintf(stderr,"child group set failed\n");
		else
			{
			len=0;
		for(j=0;j<i;j++)
			len+=strlen(array[j]);
		cline[0] = "/bin/sh";
		cline[1] = "-c";
		cline[2] = malloc(len+1+j);
		cline[2][0]='\0';
		cline[3] = NULL;
		for(j=0;j<i;j++)
			{
			strcat(cline[2],array[j]);
			strcat(cline[2]," ");
			}
        	execvp (cline[0], (char* const *) cline);
			}

/*        execvp (array[0], (char* const *) array);*/
        fprintf(stderr,"xswallow: Couldnt run command: %s\n", array[0]);
		/*
		_exit(1);
		*/
        }
	else
		return(childPID);
	return(-1); /*keep compiler happy*/
    }

void swallow_check (PluginInstance * This)
    {
    Arg args[2];
    Widget temp;
    char *word;
    string_list *next;
    int i, k, l, j, m, ready = FALSE;
    int width, height;
    char *windowname;
    unsigned int number_of_subkids=0, number_of_subkids2=0, number_of_kids=0, number_of_kids2=0,
      number_of_subsubkids=0, number_of_subsubkids2=0;
    Window root, parent, *children = NULL, *subchildren = NULL, *subchildren2 = NULL,
     *subsubchildren = NULL, *children2 = NULL, *subsubchildren2 = NULL;


    Atom type_ret;
    int fmt_ret;
    unsigned long nitems_ret;
    unsigned long bytes_after_ret;
    Window *win = NULL;
    Window *win2 = NULL;
    Atom _XA_WM_CLIENT_LEADER;
    XWMHints *leader_change;

    This->timerid = -1;

    if ((This->count < GIVEUP) && (abortflag == 0))
        {
        next = This->entry->swallownames;
        if (NULL != This->entry->swallownames)
            word = This->entry->swallownames->word;
        else
            word = NULL;
        while (word != NULL)
            {
            This->count++;
            if (children != (Window *) NULL)
                XFree (children);
            if (0 != XQueryTree (This->display, RootWindowOfScreen (XtScreen (This->netscape_widget)), &root,
                        &parent, &children, &number_of_kids))
            for (i = 0; i < number_of_kids; i++)
                {
                if (0 != XFetchName (This->display, children[i], &windowname))
                    {
                    if (!strncmp (windowname, word, strlen (word)))
                        {
                        ready = TRUE;
                        This->victim = children[i];
                        }
                    XFree (windowname);
                    }
                if (ready == FALSE)
                    {
                    if (subchildren != (Window *) NULL)
                        XFree (subchildren);
                    if (0 != XQueryTree (This->display, children[i], &root, &parent, &subchildren, &number_of_subkids))
                    for (k = 0; k < number_of_subkids; k++)
                        {
                        if (0 != XFetchName (This->display, subchildren[k], &windowname))
                            {
                            if (!strncmp (windowname, word, strlen (word)))
                                {
                                ready = TRUE;
                                This->victim = subchildren[k];
                                }
                            XFree (windowname);
                            }
                        if (ready == FALSE)
                            {
                            if (subsubchildren != (Window *) NULL)
                                XFree (subsubchildren);
                            if (0 != XQueryTree (This->display, subchildren[k], &root,
                            &parent, &subsubchildren, &number_of_subsubkids))
                            for (l = 0; l < number_of_subsubkids; l++)
                                {
                                if (0 != XFetchName (This->display, subsubchildren[l], &windowname))
                                    {
                                    if (!strncmp (windowname, word, strlen (word)))
                                        {
                                        ready = TRUE;
                                        This->victim = subsubchildren[l];
                                        }
                                    XFree (windowname);
                                    }
                                }
                            }
                        }
                    }
                }
            if (next->next == NULL)
                word = NULL;
            else
                {
                next = next->next;
                if (next->word[0] != 0)
                    word = next->word;
                else
                    word = NULL;
                }

            }

        if (ready == TRUE)
            {

/*
 * *search up the current tree to add a resize event handler
 */
            temp = XtWindowToWidget (This->display, This->window);
            while (strcmp (XtName (temp), "form"))
                {
                temp = XtParent (temp);
                if (!(strcmp (XtName (temp), "scroller")))
                    {
                    XtSetArg (args[0], XtNwidth, (XtArgVal) & width);
                    XtSetArg (args[1], XtNheight, (XtArgVal) & height);
                    XtGetValues (temp, args, 2);
                    if ((width == This->width) && (height == This->height))
                        This->fullscreen = 1;
                    }
                if (!(strcmp (XtName (XtParent (temp)), "drawingArea")))
                    temp = XtParent (temp);
                }
            This->resizewatch = temp;
            This->ran = 2;
            XtAddEventHandler (This->resizewatch, StructureNotifyMask, False, (XtEventHandler) resizeCB, (XtPointer) This);
            XResizeWindow (This->display, This->victim, This->width, This->height);
            XSync (This->display, FALSE);

            _XA_WM_CLIENT_LEADER = XInternAtom (This->display, "WM_CLIENT_LEADER", False);
            if (XGetWindowProperty (This->display, This->victim, _XA_WM_CLIENT_LEADER, 0,
                                    sizeof (Window), False, AnyPropertyType,
                         &type_ret, &fmt_ret, &nitems_ret, &bytes_after_ret,
                                    (unsigned char **) &win) == Success)
				{
                if (win != NULL)
                    if (*win == This->victim)
                        {
/*
 * if im a multiwindow app, i have to check all the toplevel
 * windows to see if they're part of me, highly dodge i know
 * what if they havent popped up yet, and some might later etc
 * etc. And hey you say, havent you just done this XQuery
 * already, and the answer is yeah i have, im giving a
 * possible second window a chance to pop up :-0, so i just
 * cut and pasted the code in again, basically as
 * im breaking so many other rules as im going about it, why
 * stop now. anyhow maybe ill figure out a proper way of doing it
 * anyone want to buy me some advanced X programming books to
 * help me achieve this task ? i take visa too.
 */
                        if (0 != XQueryTree (This->display, RootWindowOfScreen (XtScreen (This->netscape_widget)), &root, &parent, &children2, &number_of_kids2))
                        for (l = 0; l < number_of_kids2; l++)
                            {
                            win2 = NULL;
                            if (XGetWindowProperty (This->display, children2[l], _XA_WM_CLIENT_LEADER, 0,
                                                    sizeof (Window), False, AnyPropertyType, &type_ret, &fmt_ret, &nitems_ret, &bytes_after_ret,
                                       (unsigned char **) &win2) == Success)
                                {
                                if (win2 != NULL)
                                    if (*win2 == *win)
                                        {
                                        leader_change = XGetWMHints (This->display, children2[l]);
                                        leader_change->flags = (leader_change->flags | WindowGroupHint);
                                        leader_change->window_group = RootWindowOfScreen (XtScreen (This->netscape_widget));

                                        XSetWMHints (This->display, children2[l], leader_change);
                                        XFree (win2);
                                        }
                                }
                            if (0 != XQueryTree (This->display, children2[l], &root, &parent, &subchildren2, &number_of_subkids2))
                            for (k = 0; k < number_of_subkids2; k++)
                                {
                                win2 = NULL;
                                if (XGetWindowProperty (This->display, subchildren2[k], _XA_WM_CLIENT_LEADER, 0,
                                                        sizeof (Window), False, AnyPropertyType, &type_ret, &fmt_ret, &nitems_ret, &bytes_after_ret,
                                       (unsigned char **) &win2) == Success)
                                    {
                                    if (win2 != NULL)
                                        if (*win2 == *win)
                                            {

                                            leader_change = XGetWMHints (This->display, subchildren2[k]);
                                            leader_change->flags = (leader_change->flags | WindowGroupHint);
                                            leader_change->window_group = RootWindowOfScreen (XtScreen (This->netscape_widget));

                                            XSetWMHints (This->display, subchildren2[k], leader_change);

                                            XFree (win2);
                                            }
                                    }
                                XQueryTree (This->display, subchildren2[k], &root, &parent, &subsubchildren2, &number_of_subsubkids2);
                                for (m = 0; m < number_of_subsubkids2; m++)
                                    {
                                    win2 = NULL;
                                    if (XGetWindowProperty (This->display, subsubchildren2[m], _XA_WM_CLIENT_LEADER, 0,
                                                            sizeof (Window), False, AnyPropertyType, &type_ret, &fmt_ret, &nitems_ret, &bytes_after_ret,
                                       (unsigned char **) &win2) == Success)
                                        {
                                        if (win2 != NULL)
                                            if (*win2 == *win)
                                                {

                                                leader_change = XGetWMHints (This->display, subsubchildren2[m]);
                                                leader_change->flags = (leader_change->flags | WindowGroupHint);
                                                leader_change->window_group = RootWindowOfScreen (XtScreen (This->netscape_widget));

                                                XSetWMHints (This->display, subsubchildren2[m], leader_change);

                                                XFree (win2);
                                                }
                                        }
                                    }
                                }
                            }
                        if (subsubchildren2 != (Window *) NULL)
                            XFree (subsubchildren2);
                        if (subchildren2 != (Window *) NULL)
                            XFree (subchildren2);
                        if (children2 != (Window *) NULL)
                            XFree (children2);
                        }
					}
            if (win != (Window *) NULL)
                XFree (win);

            XSync (This->display, FALSE);

            XWithdrawWindow (This->display, This->victim, XScreenNumberOfScreen (XtScreen (This->netscape_widget)));
            XSync (This->display, FALSE);
            XMapWindow (This->display, This->window);
            XResizeWindow (This->display, This->window, This->width, This->height);
            XSync (This->display, FALSE);

            for (j = 0; j < REPARENT_LOOPS; j++)
                {
/*
 * more bloody serious dodginess
 */
/**/
XReparentWindow (This->display, This->victim, This->window, 0, 0);
XSync (This->display, FALSE);
/**/
                }


            XMapWindow (This->display, This->victim);
            XSync (This->display, FALSE);

            if (children != (Window *) NULL)
                XFree (children);
            if (subchildren != (Window *) NULL)
                XFree (subchildren);
            if (subsubchildren != (Window *) NULL)
                XFree (subsubchildren);
            }
        else
            This->timerid = XtAppAddTimeOut (XtDisplayToApplicationContext (This->display), 333, (XtTimerCallbackProc) swallow_check, (XtPointer) This);
        }
    }

void do_swallow (PluginInstance * This)
    {
    if (This->entry != NULL)
		{
		This->timerid = XtAppAddTimeOut(XtDisplayToApplicationContext(This->display), 333, (XtTimerCallbackProc) swallow_check, (XtPointer)This);
		/*add a timer*/
		}
    }


string_list *parse_line (char *in, int *total)
    {
    int count = 0;
    char *begin;
    char *end;
    int t;
    int ignore = 0;
    int slash = 0;
    char bucket[MAXFILELEN];
    string_list *temp;
    string_list *temp2;
    string_list *list;

    *total = 0;

    list = malloc (sizeof (string_list));
    if (list == NULL)
        {
        fprintf (stderr, "xswallow: no memory, argh\n");
        exit (-101);
        }
    list->word[0] = '\0';
    list->next = NULL;
    temp = list;
    temp2 = list;
    t = strlen (in);


    begin = in;
    end = in;
    while (end <= in + t)
        {
        if ((isspace (*end)) && (!ignore))
            {
            if (slash)
                slash = 0;
            if (count > 0)
                {
                bucket[count] = '\0';
                add_string (bucket, temp);
                temp2 = malloc (sizeof (string_list));
                if (temp2 == NULL)
                    {
                    fprintf (stderr, "xswallow: No memory argh bombing out\n");
                    exit (-1);
                    }
                temp->next = temp2;
                temp = temp->next;
                temp->word[0] = '\0';
                temp->next = NULL;
                *total = *total + 1;
                count = 0;
                }
            while ((end <= in + t) && (isspace (*end)))
                end++;
            if (end != in + t)
                end--;
            }
        else if (((*end == '"') && (!ignore)) && (!slash))  
            ignore = 1;
        else if (((*end == '"') && (ignore)) && (!slash))
            ignore = 0;
        else if (*end == '\\')
            {
            if (slash)
                {
                if (count < MAXFILELEN - 1)
                    bucket[count] = *end;
                count++;
                slash = 0;
                }
            else
                slash = 1;
            }
        else
            {
            if (slash)
                slash = 0;
            if (count < MAXFILELEN - 1)
                bucket[count] = *end;
            count++;
            }
        end++;
        }

    if (count > 0)
        {
        bucket[count] = '\0';
        add_string (bucket, temp);
        temp2 = malloc (sizeof (string_list));
        if (temp2 == NULL)
            {
            fprintf (stderr, "xswallow: No memory argh bombing out\n");
            exit (-1);
            }
        temp->next = temp2;
        temp = temp->next;
        temp->word[0] = '\0';
        temp->next = NULL;
        *total = *total + 1;
        }
    temp = list;

    return (list);
    }

void add_string (char *bucket, string_list * list)
    {
    strncpy (list->word, bucket, MAXFILELEN);
    removeLeadingAndTrailingSpaces (list->word);
    }

void abortswallow(int ignored)
	{
	fprintf(stderr,"XSwallow:The app to be swallowed appears not to have been launched,dang!\n");
	abortflag=1;
	}

void abortswallowX(Widget w, XtPointer closure,XEvent *whocares)
	{
    PluginInstance *This = (PluginInstance *) closure;
	XtRemoveEventHandler(This->netscape_widget, ExposureMask, FALSE, (XtEventHandler)Redraw, This);
	XtRemoveEventHandler(This->netscape_widget, ButtonPress, FALSE, (XtEventHandler)abortswallowX, This);
	XClearWindow(This->display,This->window);
	if (This->child_pid != -1)
		kill(This->child_pid*-1,SIGTERM); /*this should kill all children down along*/
/*
		killpg(This->child_pid,SIGTERM); 
*/
	abortflag=1;
	}

