// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleLexer_h_
#define _StyleLexer_h_

#include <qobject.h>
#include <qstring.h>

//: The StyleLexer class converts a data stream into a stream of style tokens.
//. The StyleLexer emits a series of tokens, and is usually connected to a
//. StyleParser.  After the last token has been emitted, the StyleLexer
//. automatically deletes itself.
class StyleLexer : public QObject {
    Q_OBJECT
    QString _leftover;
    bool    _done;
public:
    enum Token {
        NullToken,
        CloseBrace,
        CloseParen,
        Colon,
        Comma,
        EqualSign,
        Identifier,
        Integer,
        OpenBrace,
        OpenParen
    };

    struct Table {
        int         length;
        const char* text;
        Token       token;
    };
    
    StyleLexer();
    ~StyleLexer();
public slots:
    //. Tokenize as much of the new data as possible, and store the rest for
    //. later.
    void data( const char* bytes, int length );

    //. Tokenized any remaining text, and die.
    void endOfData();
signals:
    //. Emitted after the last token has been emitted.
    void done();

    //. Emit a token and the actual text that was recognized.
    void token( StyleLexer::Token token, QString text );
};

#endif
