$ save_verify='f$verify(0)
$! set ver 
$!
$!
$!      Compile and link xlock
$!
$! USAGE:
$! @make [link debug clobber clean]
$!       link : linking only
$!       debug : compile with degugger switch
$!       clean : clean all except executable
$!       clobber : clean all
$!
$! If you have
$!              XPM library
$!              XVMSUTILS library (VMS6.2 or lower)
$! insert the correct directory instead of X11:
$ xvmsf="X11:XVMSUTILS.OLB"
$ xpmf="X11:LIBXPM.OLB"
$!
$! Assumes you have the readable bitmaps.  Easily corrected if you have
$! permissions.  Many systems are distributed with a nulls at the end of
$! these include files which causes shapes.c not to compile.
$ cvb=0
$! Assumes corrupt VMS bitmaps.  
$! cvb=1
$!
$! Already assumes DEC C on Alpha.
$! Assume VAX C on VAX.
$ decc=0
$! Assume DEC C on VAX.
$! decc=1
$!
$! if vrt<>0 the use of the root window is enabled
$ vrt=1
$! vrt=0
$!
$!
$! NOTHING SHOULD BE MODIFIED BELOW
$!
$ if p1 .eqs. "CLEAN" then goto Clean
$ if p1 .eqs. "CLOBBER" then goto Clobber
$!
$ xpm=f$search("''xpmf'") .nes. ""
$ axp=f$getsyi("HW_MODEL") .ge. 1024
$ sys_ver=f$edit(f$getsyi("version"),"compress")
$ if f$extract(0,1,sys_ver) .nes. "V"
$ then
$   type sys$input
You appear to be running a Field Test version of VMS. This script will 
assume that the operating system version is at least V7.0. 
$!
$   sys_ver="V7.0"
$ endif
$ sys_maj=0+f$extract(1,1,sys_ver)
$ if sys_maj .lt. 7 then xvms=f$search("''xvmsf'") .nes. ""
$!
$!
$! Create .opt file
$ close/nolog optf
$ open/write optf xlock.opt
$!
$ defs=="VMS"
$ if xpm then defs=="''defs',HAS_XPM"
$ if axp then defs=="''defs',VMS_PLAY"
$ if sys_maj .lt. 7
$ then
$   if xvms then defs=="''defs',XVMSUTILS"
$ endif
$ if cvb then defs=="''defs',CORRUPT_VMS_BITMAPS"
$ if vrt then defs=="''defs',USE_VROOT"
$! If your system does not have bitmaps, you should
$! decw$bitmaps:==[-.bitmaps]
$!
$!
$! Establish the Compiling Environment
$!
$!
$! Set compiler command
$! Put in /include=[] for local include file like a pwd.h ...
$!   not normally required.
$ if axp
$ then
$   cc=="cc/standar=vaxc/define=(''defs')"
$ else
$   if decc
$   then
$     cc=="cc/decc/standard=vaxc/define=(''defs')"
$   else ! VAX C
$     cc=="cc/define=(''defs')"
$   endif
$ endif
$ if p1 .eqs. "DEBUG" .or. p2 .eqs. "DEBUG" .or. p3 .eqs. "DEBUG"
$ then
$   if axp
$   then
$     cc=="cc/deb/noopt/standar=vaxc/define=(''defs')/list"
$   else
$     if decc
$     then
$       cc=="cc/deb/noopt/decc/standar=vaxc/define=(''defs')/list"
$     else ! VAX C
$       cc=="cc/deb/noopt/define=(''defs'")/list"
$     endif
$   endif
$   link=="link/deb"
$ endif
$!
$ if p1 .nes. "LINK"
$ then
$   if axp .or. .not. decc
$   then
$     define/nolog sys sys$library
$   endif
$!
$   write sys$output "Copying Main Files"
$   call make xlock.h    "copy [-]xlock.h []"    [-]xlock.h
$   call make vroot.h    "copy [-]vroot.h []"    [-]vroot.h
$   call make ras.h      "copy [-]ras.h []"      [-]ras.h
$   call make xlock.c    "copy [-]xlock.c []"    [-]xlock.c
$   call make passwd.c   "copy [-]passwd.c []"   [-]passwd.c
$   call make resource.c "copy [-]resource.c []" [-]resource.c
$   call make utils.c    "copy [-]utils.c []"    [-]utils.c
$   call make logout.c   "copy [-]logout.c []"   [-]logout.c
$   call make ras.c      "copy [-]ras.c []"      [-]ras.c
$   call make xbm.c      "copy [-]xbm.c []"      [-]xbm.c
$   call make color.c    "copy [-]color.c []"    [-]color.c
$   call make random.c   "copy [-]random.c []"   [-]random.c
$   if axp
$   then
$     call make amd.h      "copy [-]amd.h []"      [-]amd.h
$     call make amd.c      "copy [-]amd.c []"      [-]amd.c
$     call make vms_play.c "copy [-]vms_play.c []" [-]vms_play.c
$   endif
$!
$   write sys$output "Copying Include Files"
$!   call make ghost.xbm  "copy [.bitmaps]m-x11.xbm ghost.xbm"   [.bitmaps]m-x11.xbm
$   call make ghost.xbm   "copy [.bitmaps]m-ghost.xbm ghost.xbm" [.bitmaps]m-ghost.xbm
$!
$   write sys$output "Compiling XLock"
$   call make xlock.obj     "cc xlock.c"     xlock.c xlock.h mode.h vroot.h
$   call make passwd.obj    "cc passwd.c"    passwd.c xlock.h
$   call make resource.obj  "cc resource.c"  resource.c xlock.h mode.h
$   call make utils.obj     "cc utils.c"     utils.c xlock.h
$   call make logout.obj    "cc logout.c"    logout.c xlock.h
$   call make mode.obj      "cc mode.c"      mode.c xlock.h mode.h
$   call make ras.obj       "cc ras.c"       ras.c xlock.h
$   call make xbm.obj       "cc xbm.c"       xbm.c xlock.h
$   call make color.obj     "cc color.c"     color.c xlock.h
$   call make ball.obj      "cc ball.c"      ball.c xlock.h mode.h
$   call make bomb.obj      "cc bomb.c"      bomb.c xlock.h mode.h
$   call make cartoon.obj   "cc cartoon.c"   cartoon.c xlock.h mode.h
$   call make dclock.obj    "cc dclock.c"    dclock.c xlock.h mode.h
$   call make flamen.obj    "cc flamen.c"    flamen.c xlock.h mode.h
$   call make gear.obj      "cc gear.c"      gear.c xlock.h mode.h
$   call make husker.obj    "cc husker.c"    husker.c xlock.h mode.h
$   call make julia.obj     "cc julia.c"     julia.c xlock.h mode.h
$   call make pacman.obj    "cc pacman.c"    pacman.c xlock.h mode.h
$   call make polygon.obj   "cc polygon.c"   polygon.c xlock.h mode.h
$   call make sphere2.obj   "cc sphere2.c"   sphere2.c xlock.h mode.h
$   call make star.obj      "cc star.c"      star.c xlock.h mode.h
$   call make turtle.obj    "cc turtle.c"    turtle.c xlock.h mode.h
$   call make random.obj    "cc random.c"    random.c xlock.h mode.h
$! AMD and VMS_PLAY for SOUND uncomment VMS_PLAY in xlock.h
$   if axp
$   then
$     call make amd.obj       "cc amd.c"       amd.c amd.h
$     call make vms_play.obj  "cc vms_play.c"  vms_play.c amd.h
$   endif
$ endif
$!
$! Get libraries
$ if xpm then write optf "''xpmf'/lib"
$ if sys_maj .lt. 7
$ then
$   if xvms then write optf "''xvmsf'/lib"
$ endif
$! if .not. axp then write optf "sys$library:vaxcrtl/lib"
$ write optf "sys$library:vaxcrtl/lib"
$ if axp then write optf "sys$library:ucx$ipc_shr/share"
$ if axp then write optf "sys$share:decw$xextlibshr/share"
$ if axp then write optf "sys$share:decw$xtlibshrr5/share"
$ if .not. axp then write optf "sys$library:ucx$ipc/lib"
$ write optf "sys$share:decw$dxmlibshr/share"
$ write optf "sys$share:decw$xlibshr/share"
$ close optf
$!
$! LINK
$ write sys$output "Linking XLock"
$ link/map xlock/opt
$ set noverify
$ exit
$!
$Clobber:      ! Delete executables, Purge directory and clean up object files
$!                and listings
$ delete/noconfirm/log xlock.exe;*
$ delete/noconfirm/log xlock.h;*
$ delete/noconfirm/log vroot.h;*
$ delete/noconfirm/log ras.h;*
$ delete/noconfirm/log xlock.c;*
$ delete/noconfirm/log passwd.c;*
$ delete/noconfirm/log resource.c;*
$ delete/noconfirm/log utils.c;*
$ delete/noconfirm/log logout.c;*
$ delete/noconfirm/log ras.c;*
$ delete/noconfirm/log xbm.c;*
$ delete/noconfirm/log color.c;*
$ delete/noconfirm/log random.c;*
$ delete/noconfirm/log amd.h;*
$ delete/noconfirm/log amd.c;*
$ delete/noconfirm/log vms_play.c;*
$!
$Clean:        ! Purge directory, clean up object files and listings
$ close/nolog optf
$ purge
$ delete/noconfirm/log *.lis;*
$ delete/noconfirm/log *.obj;*
$ delete/noconfirm/log *.opt;*
$ delete/noconfirm/log *.map;*
$ delete/noconfirm/log ghost.xbm;*
$!
$ exit
$!
! SUBROUTINE TO CHECK DEPENDENCIES
$ make: subroutine
$   v='f$verify(0)
$!   p1       What we are trying to make
$!   p2       Command to make it
$!   p3 - p8  What it depends on
$
$   if (f$extract(0,3,p2) .eqs. "cc ") then write optf "''p1'"
$   if (f$extract(0,3,p2) .eqs. "CC ") then write optf "''p1'"
$
$   if f$search(p1) .eqs. "" then goto MakeIt
$   time=f$cvtime(f$file(p1,"RDT"))
$   arg=3
$Loop:
$   argument=p'arg
$   if argument .eqs. "" then goto Exit
$   el=0
$Loop2:
$   file=f$element(el," ",argument)
$   if file .eqs. " " then goto Endl
$   afile=""
$Loop3:
$   ofile=afile
$   afile=f$search(file)
$   if afile .eqs. "" .or. afile .eqs. ofile then goto NextEl
$   if f$cvtime(f$file(afile,"RDT")) .ges. time then goto MakeIt
$   goto Loop3
$NextEL:
$   el=el+1
$   goto Loop2
$EndL:
$   arg=arg+1
$   if arg .le. 8 then goto Loop
$   goto Exit
$
$MakeIt:
$   set verify
$   'p2
$   vv='f$verify(0)
$Exit:
$   if v then set verify
$ endsubroutine
