/* Copyright May 1996, Frederic Cordier.  No guarantees or warantees are
 * provided or implied in any way whatsoever.  Use this program at your own
 * risk.  Permission to use, modify, and redistribute this program is hereby
 * given, provided that this copyright is kept intact.
 * FvwmForm 2 is completely different from the first version.
 * First version by Thomas Zuwei Feng
 */

#include "../../configure.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>
#include <X11/cursorfont.h>
#define XK_MISCELLANY
#include <X11/keysymdef.h>
#if !defined(__bsdi__) && !defined(__FreeBSD__)
#include <malloc.h>
#endif
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#if defined ___AIX || defined _AIX || defined ___AIXV3
#include <sys/select.h>
#endif
#include "objects.h"

/* Variables utilise par l'analyseur syntaxique */
extern ScriptProp *scriptprop;
extern int nbobj;			/* Nombre d'objets */
extern int numligne;			/* Numero de ligne */
extern TabObj *tabobj;			/* Tableau d'objets, limite=30 */
extern char **TabVVar;			/* Tableau des variables du sript */
extern int TabIdObj[31];
extern Bloc **TabIObj;
extern CaseObj *TabCObj;


/* Constante de couleurs utilise dans le tableau TabColor */
#define black 0
#define white 1
#define back 2
#define fore 3
#define shad 4
#define li 5


/* Declaration des types utilisees */
typedef struct
{
  Display *display ;
  int screen ;
  Window root ;
  Window win ;
  Colormap colormap ;
  GC gc ;
  int depth ;
  int fd_x;
  unsigned long WhitePix ;
  unsigned long BlackPix ;
  XColor TabColor[6];
  XSizeHints size;
  char *backcolor;
  char *forecolor;
  char *shadcolor;
  char *licolor;
  char *font;
  char *icon;
  XFontStruct *xfont;
  char *title;
} X11base ;


/* Variables globales */
char *ScriptName;		/* Nom du fichier contenat le script decrivant le GUI */
int fd_in;                 	/* fd for Fvwm->Module packets */
int fd_out;                	/* fd for Module->Fvwm packets */
int fd[2]; 			/* pipe pair */
int fd_err;
Window ref;

/* Tableau des commandes */
void (*TabCom[20]) (int NbArg,long *TabArg);

/* Tableau des fonctions */
/* Les fonctions connaisent le nb d'arg qu'elles ont besoin */
char *(*TabFunc[3]) (int BegId,int *EndId, long *TabArg);

/* Fonction de comparaison entre deux variables */
int (*TabComp[7]) (char *arg1,char *arg2);

X11base *x11base;		/* Pour le serveur X */
int grab_server = 0;
struct XObj *tabxobj[30];

void DrawRRect(int x,int y,int width,int height)
{
 XSegment segm[2];
 int i;
 int j; 

 XSetForeground(x11base->display,x11base->gc,x11base->TabColor[back].pixel);
 XFillRectangle(x11base->display,x11base->win,x11base->gc,0,0,
		x11base->size.width,x11base->size.height);

 for (i=0;i<2;i++)
 {
  j=-1-i;
  segm[0].x1=x+i;
  segm[0].y1=y+i;
  segm[0].x2=x+i;
  segm[0].y2=height+j;
  segm[1].x1=x+i;
  segm[1].y1=y+i;
  segm[1].x2=width+j;
  segm[1].y2=y+i;
  XSetForeground(x11base->display,x11base->gc,x11base->TabColor[li].pixel);
  XDrawSegments(x11base->display,x11base->win,x11base->gc,segm,2);
 
  segm[0].x1=width+j;
  segm[0].y1=y+i;
  segm[0].x2=width+j;
  segm[0].y2=height+j;
  segm[1].x1=x+i;
  segm[1].y1=height+j;
  segm[1].x2=width+j;
  segm[1].y2=height+j;
  XSetForeground(x11base->display,x11base->gc,x11base->TabColor[shad].pixel);
  XDrawSegments(x11base->display,x11base->win,x11base->gc,segm,2);
 }
 XSetForeground(x11base->display,x11base->gc,x11base->TabColor[black].pixel);
 XDrawRectangle(x11base->display,x11base->win,x11base->gc,
			x-1,y-1,width+1-x,height+1-y);
 XSetForeground(x11base->display,x11base->gc,x11base->TabColor[back].pixel);

}

void Debug()
{
 int i,j;
 
 for (j=1;j<=nbobj;j++)
  for (i=0;i<=TabCObj[TabIdObj[j]].NbCase;i++)
  {
   /* Execution du bloc d'instruction */
   fprintf(stderr,"Id de l'objet %d\n",TabIdObj[j]);
   fprintf(stderr,"Nb Instruction %d\n",TabIObj[TabIdObj[j]][i].NbInstr);
   fprintf(stderr,"Adresse du bloc %d\n",TabIObj[TabIdObj[j]][i].TabInstr);
  }

}

/* Lecture du fichier contenant le scipt */
void ReadConfig (char *ScriptName)
{
  extern FILE *yyin,*yyout;
  int i;

  yyin=fopen(ScriptName,"r");
  if (yyin == NULL) 
  {
   fprintf(stderr,"Can't open the script %s",ScriptName);
   exit(1);
  }
  /* On ne redefini pas yyout qui est la sortie standard */

  /* Application de l'analyseur syntaxique et lexical */
  yyparse();
  /* Fermeture du script */

  close(yyin);
}

/* Procedure d'initialisation du serveur X et des variables globales*/
void Xinit()
{


 /* Connextion au serveur X */
 x11base->display=XOpenDisplay(NULL);
 if (x11base->display==NULL) 
 {
  fprintf(stderr,"Enable to open display.\n");
  exit(1);
 }

 
 x11base->screen=DefaultScreen(x11base->display);
 x11base->WhitePix=WhitePixel(x11base->display,x11base->screen);
 x11base->BlackPix=BlackPixel(x11base->display,x11base->screen);
 x11base->depth=XDefaultDepth(x11base->display,x11base->screen);
 x11base->colormap = DefaultColormap(x11base->display,x11base->screen);
 x11base->root = RootWindow(x11base->display,x11base->screen);
 x11base->fd_x = XConnectionNumber(x11base->display);

}

/* Ouvre une fenetre pour l'affichage du GUI */
void OpenWindow ()
{
 XTextProperty Name;
 XWMHints *IndicWM;
 XSizeHints *IndicNorm;
 int FaitColor={DoRed|DoGreen|DoBlue};
 XColor TempColor;
 unsigned long mask;
 XSetWindowAttributes Attr;

 /* Allocation des couleurs */
 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	x11base->forecolor,&x11base->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	x11base->backcolor,&x11base->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	x11base->shadcolor,&x11base->TabColor[shad],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	x11base->licolor,&x11base->TabColor[li],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	"black",&x11base->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(x11base->display,x11base->colormap,
	"white",&x11base->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 /* Definition des caracteristiques de la fentre */
 mask=0;
 mask|=CWBackPixel;
 Attr.background_pixel=x11base->TabColor[back].pixel;
 
 x11base->win=XCreateWindow(x11base->display,
			DefaultRootWindow(x11base->display),
			x11base->size.x,
			x11base->size.y,
			x11base->size.width,
			x11base->size.height,0,
			CopyFromParent,
			InputOutput,
			CopyFromParent,
			mask,&Attr);

 XSetWindowColormap(x11base->display,x11base->win,x11base->colormap);
 x11base->gc=XCreateGC(x11base->display,x11base->win,0,NULL);

 /* Chargement des polices */
 if ((x11base->xfont=XLoadQueryFont(x11base->display,x11base->font))==NULL)
  {
   fprintf(stderr,"Can't load font %s\n",x11base->font);
  }
 else
  XSetFont(x11base->display,x11base->gc,x11base->xfont->fid);


 /* Choix des evts recus par la fenetre */
 XSelectInput(x11base->display,x11base->win,KeyPressMask|ButtonPressMask|
	ExposureMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask);

 /* Specification des parametres utilises par le gestionnaire de fenetre */
 if (XStringListToTextProperty(&x11base->title,1,&Name)==0)
  fprintf(stderr,"Can't use icon name\n");
 IndicNorm=XAllocSizeHints();
 if (x11base->size.x!=-1)
 {
  IndicNorm->x=x11base->size.x;
  IndicNorm->y=x11base->size.y;
  IndicNorm->flags=PSize|PMinSize|PMaxSize|PResizeInc|PBaseSize|PPosition;
 }
 else
  IndicNorm->flags=PSize|PMinSize|PMaxSize|PResizeInc|PBaseSize;
 IndicNorm->width=x11base->size.width;
 IndicNorm->height=x11base->size.height;
 IndicNorm->min_width=x11base->size.width;
 IndicNorm->min_height=x11base->size.height;
 IndicNorm->max_width=x11base->size.width;
 IndicNorm->max_height=x11base->size.height;
 IndicWM=XAllocWMHints();
 IndicWM->input=True;
 IndicWM->initial_state=NormalState;
 IndicWM->flags=InputHint|StateHint;
 XSetWMProperties(x11base->display,x11base->win,&Name,
       &Name,NULL,0,IndicNorm,IndicWM,NULL);
}

/***********************************************/
/* Execution d'une sequence d'instruction      */
/***********************************************/
void ExecBloc(Bloc *bloc)
{
 int i;

 for (i=0;i<=bloc->NbInstr;i++)
 {
  TabCom[bloc->TabInstr[i].Type](bloc->TabInstr[i].NbArg,bloc->TabInstr[i].TabArg);
 }
}


/* Construction de l'interface graphique */
void BuildGUI()
{
 int i;

 x11base=(X11base*) calloc(1,sizeof(X11base));


 if (scriptprop->font==NULL)
  x11base->font=strdup("fixed");
 else
  x11base->font=scriptprop->font;

 if (scriptprop->forecolor==NULL)
  x11base->forecolor=strdup("black");
 else
  x11base->forecolor=scriptprop->forecolor;

 if (scriptprop->backcolor==NULL)
  x11base->backcolor=strdup("white");
 else
  x11base->backcolor=scriptprop->backcolor;

 if (scriptprop->shadcolor==NULL)
  x11base->shadcolor=strdup("black");
 else
  x11base->shadcolor=scriptprop->shadcolor;

 if (scriptprop->licolor==NULL)
  x11base->licolor=strdup("black");
 else
  x11base->licolor=scriptprop->licolor;

 x11base->icon=scriptprop->icon;

 x11base->size.x=scriptprop->x;
 x11base->size.y=scriptprop->y;
 x11base->size.width=scriptprop->width;
 x11base->size.height=scriptprop->height;
 x11base->title=scriptprop->titlewin;

 /* Initialisation du serveur X et de la fenetre */

 Xinit();
 OpenWindow();


 /* Parcour de tous les objets graphiques */
 nbobj++;
 for (i=0;i<nbobj;i++)
 {
  tabxobj[i]=(struct XObj*)calloc(1,sizeof(struct XObj));
  tabxobj[i]->id=(*tabobj)[i].id;
  tabxobj[i]->x=(*tabobj)[i].x;
  tabxobj[i]->y=(*tabobj)[i].y;
  tabxobj[i]->width=(*tabobj)[i].width;
  tabxobj[i]->height=(*tabobj)[i].height;
  tabxobj[i]->value=(*tabobj)[i].value;
  tabxobj[i]->icon=(*tabobj)[i].icon;
  tabxobj[i]->title=(*tabobj)[i].title;
  tabxobj[i]->state=(*tabobj)[i].state;

  if ((*tabobj)[i].font==NULL)
    tabxobj[i]->font=(char*)strdup(x11base->font);
  else
    tabxobj[i]->font=(*tabobj)[i].font;

  if ((*tabobj)[i].forecolor==NULL)
    tabxobj[i]->forecolor=(char*)strdup(x11base->forecolor);
  else
    tabxobj[i]->forecolor=(*tabobj)[i].forecolor;

  if ((*tabobj)[i].backcolor==NULL)
    tabxobj[i]->backcolor=(char*)strdup(x11base->backcolor);
  else
    tabxobj[i]->backcolor=(*tabobj)[i].backcolor;

  if ((*tabobj)[i].shadcolor==NULL)
    tabxobj[i]->shadcolor=(char*)strdup(x11base->shadcolor);
   else
    tabxobj[i]->shadcolor=(*tabobj)[i].shadcolor;

  if ((*tabobj)[i].licolor==NULL)
    tabxobj[i]->licolor=strdup(x11base->licolor);
  else
    tabxobj[i]->licolor=(*tabobj)[i].licolor;

  ChooseFunction(tabxobj[i],(*tabobj)[i].type);
  tabxobj[i]->gc=x11base->gc;
  tabxobj[i]->display=x11base->display;
  tabxobj[i]->ParentWin=&(x11base->win);
  tabxobj[i]->Screen=x11base->screen;
  tabxobj[i]->colormap=&(x11base->colormap);

  tabxobj[i]->InitObj(tabxobj[i]);
 }

 /*Si un bloc d'initialisation du script existe, on l'execute ici */
 if (scriptprop->initbloc!=NULL)
 {
  ExecBloc(scriptprop->initbloc);
  free(scriptprop->initbloc->TabInstr);
  free(scriptprop->initbloc);
 }

 free(tabobj);
 free(scriptprop);
 XMapRaised(x11base->display,x11base->win);
 for (i=0;i<nbobj;i++)
  if (tabxobj[i]->state!=Hiden)
   XMapWindow(x11base->display,tabxobj[i]->ObjWin);
}


/***********************************************/
/* Fonction de traitement des msg entre objets */
/***********************************************/
void SendMsg(struct XObj *xobj,int TypeMsg)
{
 int i; 

 for (i=0;i<=TabCObj[TabIdObj[xobj->id]].NbCase;i++)
  if (TabCObj[TabIdObj[xobj->id]].LstCase[i]==TypeMsg)
  {
   /* Execution du bloc d'instruction */
   ExecBloc(&TabIObj[TabIdObj[xobj->id]][i]);
  }
}

/*************************************************************/
/* Ensemble de fonction de comparaison de deux entiers       */
/*************************************************************/
int Inf(char *arg1,char *arg2)
{
 int an1,an2;
 an1=atoi(arg1);
 an2=atoi(arg2);
 return (arg1<arg2);
}

int InfEq(char *arg1,char *arg2)
{
 int an1,an2;
 an1=atoi(arg1);
 an2=atoi(arg2);
 return (arg1<=arg2);
}

int Equal(char *arg1,char *arg2)
{
 return (strcmp(arg1,arg2)==0);
}

int SupEq(char *arg1,char *arg2)
{
 int an1,an2;
 an1=atoi(arg1);
 an2=atoi(arg2);
 return (arg1>=arg2);
}

int Sup(char *arg1,char *arg2)
{
 int an1,an2;
 an1=atoi(arg1);
 an2=atoi(arg2);
 return (arg1>arg2);
}

int Diff(char *arg1,char *arg2)
{
 return (strcmp(arg1,arg2)!=0);
}

/*****************************************************/
/* Fonction qui retourne la valeur d'un argument     */
/*****************************************************/
char *CalcArg (long *TabArg,int *Ix)
{
 char *TmpStr;

 if (TabArg[*Ix]>100000)	/* Cas du codage d'un nombre */
 {
  TmpStr=(char*)calloc(1,sizeof(char)*10);
  sprintf(TmpStr,"%d",TabArg[*Ix]-200000);
 }
 else if (TabArg[*Ix]< -100000)	/* Cas d'un id de fonction */
 {
  TmpStr=TabFunc[TabArg[*Ix]+150000](*Ix+1,Ix,TabArg);
 }
 else				/* Cas d'une variable */
 {
  TmpStr=strdup(TabVVar[TabArg[*Ix]]);
 }
 return (TmpStr);
}

/*************************************************************/
/* Ensemble des fonctions pour recuperer les prop d'un objet */
/*************************************************************/
/* Fonction qui retourne la valeur d'un objet */
char *FuncGetValue(int BegId,int *EndId, long *TabArg)
{
 char *tmp;
 long Id;

 tmp=(char*)calloc(1,sizeof(char)*10);
 /* Traitement de l'argument */
 if (TabArg[BegId]>100000)		/* Cas du codage d'un nombre */
 {
  Id=TabArg[BegId]-200000;
 }
 else if (TabArg[BegId]< -100000)	/* Cas d'un id de fonction */
 {
  Id=atoi(TabFunc[TabArg[BegId]+150000](BegId+1,&BegId,TabArg));
 }
 else					/* Cas d'une variable */
 {
  Id=atoi(TabVVar[TabArg[BegId]]);
 }

 sprintf(tmp,"%d",tabxobj[TabIdObj[Id]]->value);
 *EndId=BegId;		/* Indice de commencement des params suivants */
 return tmp;
}

/* Fonction qui retourne le titre d'un objet */
char *FuncGetTitle(int BegId,int *EndId, long *TabArg)
{
 char *tmp;
 long Id;

 /* Traitement de l'argument */
 if (TabArg[BegId]>100000)		/* Cas du codage d'un nombre */
 {
  Id=TabArg[BegId]-200000;
 }
 else if (TabArg[BegId]<-100000)	/* Cas d'un id de fonction */
 {
  Id=atoi(TabFunc[TabArg[BegId]+150000](BegId+1,&BegId,TabArg));
 }
 else					/* Cas d'une variable */
 {
  Id=atoi(TabVVar[TabArg[BegId]]);
 }

 tmp=(char*)strdup(tabxobj[TabIdObj[Id]]->title);

 *EndId=BegId;		/* Indice de commencement des params suivants */
 return tmp;
}

/***********************************************/
/* Ensemble des commandes possible pour un obj */
/***********************************************/

void ComExec (int NbArg,long *TabArg)
{
 int leng;
 char *execstr;
 char *tempstr;
 char *temp2str;
 int i;
 int num;

 execstr=(char*)calloc(1,256);
 tempstr=(char*)calloc(1,256);

 for (i=0;i<NbArg;i++)
 { 
  if (TabArg[i]>100000)	/* Cas du codage d'un nombre */
  {
   sprintf(tempstr,"%d",TabArg[i]-200000);
   execstr=strcat(execstr,tempstr);
  }
  else if (TabArg[i]< -100000)	/* Cas d'un id de fonction */
  {
   temp2str=TabFunc[TabArg[i]+150000](i+1,&i,TabArg);
   execstr=strcat(execstr,temp2str);
   free(temp2str);
  }
  else				/* Cas d'une variable */
  {
    execstr=strcat(execstr,TabVVar[TabArg[i]]);
  }
 }

 
 write(fd_out, &ref, sizeof(Window));
 leng = strlen(execstr);
 write(fd_out, &leng, sizeof(int));
 write(fd_out, execstr, leng);
 leng = 1;
 write(fd_out, &leng, sizeof(int));

 free(execstr);
 free(tempstr);
}

void ComHideObj (int NbArg,long *TabArg)
{
 char *arg[1];
 int IdItem; 
 int i=0;

 arg[0]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->state=Hiden;
 /* On cache la fentre pour la faire disparaitre */
 XUnmapWindow(x11base->display,tabxobj[IdItem]->ObjWin);
 free(arg[0]);
}

void ComShowObj (int NbArg,long *TabArg)
{
 char *arg[1];
 int IdItem; 
 int i=0;

 arg[0]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->state=Actif;
 /* On cache la fentre pour la faire disparaitre */
 XMapWindow(x11base->display,tabxobj[IdItem]->ObjWin);
 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
}

void ComChangeValue (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 
 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 
 tabxobj[TabIdObj[atoi(arg[0])]]->value=atoi(arg[1]);
 /* On redessine l'objet pour le mettre a jour */
 tabxobj[TabIdObj[atoi(arg[0])]]->DrawObj(tabxobj[TabIdObj[atoi(arg[0])]]);
 free(arg[0]);
 free(arg[1]);
}

void ComChangePos (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[3];
 int an[3]; 
 int IdItem;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 i++;
 arg[2]=CalcArg(TabArg,&i);

 IdItem= TabIdObj[atoi(arg[0])];
 for (i=1;i<3;i++)
  an[i]=atoi(arg[i]);
 tabxobj[IdItem]->x=an[1];
 tabxobj[IdItem]->y=an[2];
 XMoveWindow(x11base->display,tabxobj[IdItem]->ObjWin,an[1],an[2]);

 free(arg[0]);
 free(arg[1]);
 free(arg[2]);

}

void ComChangeFont (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 int IdItem;
 XColor TempColor;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->font=strdup(arg[1]);
 if ((tabxobj[IdItem]->xfont=XLoadQueryFont(tabxobj[IdItem]->display,tabxobj[IdItem]->font))==NULL)
  {
   fprintf(stderr,"Can't load font %s\n",tabxobj[IdItem]->font);
  }
 else
 {
  XSetFont(tabxobj[IdItem]->display,tabxobj[IdItem]->gc,tabxobj[IdItem]->xfont->fid);
  XFreeFont(tabxobj[IdItem]->display,tabxobj[IdItem]->xfont);
 }
 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
 free(arg[1]);
}

void ComChangeSize (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[3];
 int an[3]; 
 int IdItem;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 i++;
 arg[2]=CalcArg(TabArg,&i);

 IdItem= TabIdObj[atoi(arg[0])];
 for (i=1;i<3;i++)
  an[i]=atoi(arg[i]);
 tabxobj[IdItem]->width=an[1];
 tabxobj[IdItem]->height=an[2];
 XResizeWindow(x11base->display,tabxobj[IdItem]->ObjWin,an[1],an[2]);
 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
 free(arg[1]);
 free(arg[2]);
}

void ComChangeTitle (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 int IdItem;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->title=strdup(arg[1]);
 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
 free(arg[1]);
}

void ComChangeIcon (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 int IdItem;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->icon=strdup(arg[1]);
 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
 free(arg[1]);
}

void ComChangeForeColor (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 int IdItem;
 XColor TempColor;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];

 tabxobj[IdItem]->forecolor=strdup(arg[1]);
 if (!XAllocNamedColor(tabxobj[IdItem]->display,*(tabxobj[IdItem])->colormap,
	tabxobj[IdItem]->forecolor,&(tabxobj[IdItem])->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");

 tabxobj[IdItem]->DrawObj(tabxobj[IdItem]);
 free(arg[0]);
 free(arg[1]);
}

void ComSetVar (int NbArg,long *TabArg)
{
 int i;
 
 /* Premier argument: la variable; deuxieme argument: sa valeur */
 /* Copie des valeurs */
 if (TabArg[1] < -200000)		/* Cas d'une fonction */
 {
  free(TabVVar[TabArg[0]]);
  TabVVar[TabArg[0]]=TabFunc[TabArg[1]+150000](2,&i,TabArg);
 }
 else if (TabArg[1] > 100000)	/* Cas d'une valeur numerique */
 {
  TabVVar[TabArg[0]]=(char*)realloc(TabVVar[TabArg[0]],5*sizeof(char));
  sprintf(TabVVar[TabArg[0]],"%d",TabArg[1]-200000);
 }
 else					/* Cas d'une variable */
 {
  TabVVar[TabArg[0]]=(char*)realloc(TabVVar[TabArg[0]],strlen(TabVVar[TabArg[1]])*sizeof(char));
  TabVVar[TabArg[0]]=strcpy(TabVVar[TabArg[0]],TabVVar[TabArg[1]]);
 }
}

void ComSendSign (int NbArg,long *TabArg)
{
 int i=0;
 char *arg[2];
 int IdItem;
 int TypeMsg;

 arg[0]=CalcArg(TabArg,&i);
 i++;
 arg[1]=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg[0])];
 TypeMsg=atoi(arg[1]);
 SendMsg(tabxobj[IdItem],TypeMsg);
 free(arg[0]);
 free(arg[1]);
}

void WarpPointer(int NbArg,long *TabArg)
{
 int i=0;
 char *arg;
 int IdItem;
 int x,y;

 arg=CalcArg(TabArg,&i);
 IdItem= TabIdObj[atoi(arg)];
 /* Deplacement du pointeur sur l'objet */
 XWarpPointer(x11base->display,None,tabxobj[IdItem]->ObjWin,0,0,0,0,
	tabxobj[IdItem]->width/2,tabxobj[IdItem]->height+10);
}

void ComQuit (int NbArg,long *TabArg)
{
 int i;

 /* On quitte proprement le serveur X */
 for (i=0;i<nbobj;i++)
  tabxobj[i]->DestroyObj(tabxobj[i]);
 XFreeFont(x11base->display,x11base->xfont);
 XFreeGC(x11base->display,x11base->gc);
 XFreeColormap(x11base->display,x11base->colormap);
 XDestroyWindow(x11base->display,x11base->win);
 XCloseDisplay(x11base->display);
 exit(0);
}

void ComIfThen (int NbArg,long *TabArg)
{
 Bloc *bloc1;
 Bloc *bloc2;
 char *arg[2];
 int i;
 int CurrArg=0;
 int IdFuncComp;

 /* Verification de la condition */
 for (i=0;i<NbArg-2;i++)
 {
  if (TabArg[i]>100000)	/* Cas du codage d'un nombre */
  {
   arg[CurrArg]=(char*)calloc(1,sizeof(char)*10);
   sprintf(arg[CurrArg],"%d",TabArg[i]-200000);
   CurrArg++;
  }
  else if (TabArg[i]<-200000)/* Cas d'un id de fonction de comparaison */
  {
   IdFuncComp=TabArg[i]+250000;
  }
  else if (TabArg[i]<-100000)	/* Cas d'un id de fonction */
  {
   arg[CurrArg]=TabFunc[TabArg[i]+150000](i+1,&i,TabArg);
   CurrArg++;
  }
  else				/* Cas d'une variable */
  {
    arg[CurrArg]=strdup(TabVVar[TabArg[i]]);
    CurrArg++;
  }
 }

 /* Comparaison des arguments */
 if (TabComp[IdFuncComp](arg[0],arg[1]))
  ExecBloc((Bloc*)TabArg[NbArg-2]);
 else if (TabArg[NbArg-1]!=0)
  ExecBloc((Bloc*)TabArg[NbArg-1]);

 free(arg[0]);
 free(arg[1]);
}

/* Instruction boucle */
void ComLoop (int NbArg,long *TabArg)
{
 Bloc *bloc;
 int IdVar;
 char *arg[2];
 int limit[2];
 int i;
 int CurrArg=0;

 /* le premier argument est une variable */
 IdVar=TabArg[0];
 /*On ajuste la taille de la var pour contenir un nombre */
 TabVVar[TabArg[0]]=(char*)realloc(TabVVar[TabArg[0]],sizeof(char)*10);
 /* Calcul des 2 autres arguments */
 for (i=1;i<NbArg-1;i++)
 {
  if (TabArg[i]>100000)	/* Cas du codage d'un nombre */
  {
   arg[CurrArg]=(char*)calloc(1,sizeof(char)*10);
   sprintf(arg[CurrArg],"%d",TabArg[i]-200000);
  }
  else if (TabArg[i]<-100000)	/* Cas d'un id de fonction */
  {
   arg[CurrArg]=TabFunc[TabArg[i]+150000](i+1,&i,TabArg);
  }
  else				/* Cas d'une variable */
    arg[CurrArg]=strdup(TabVVar[TabArg[i]]);
  CurrArg++;
 }
 limit[0]=atoi(arg[0]);
 limit[1]=atoi(arg[1]);
 if (limit[0]<limit[1])
  for (i=limit[0];i<=limit[1];i++)
  {
   /* On met a jour la variable */
   sprintf(TabVVar[TabArg[0]],"%d",i);
   ExecBloc((Bloc*)TabArg[NbArg-1]);
  }
 else
  for (i=limit[0];i<=limit[1];i++)
  {
   sprintf(TabVVar[TabArg[0]],"%d",i);
   ExecBloc((Bloc*)TabArg[NbArg-1]);
  }

 free(arg[0]);
 free(arg[1]);
}

/* Instruction While */
void ComWhile (int NbArg,long *TabArg)
{
 Bloc *bloc;
 char *arg[2];
 int CurrArg=0;
 int i;
 int Loop=1;
 int IdFuncComp;

 while (Loop)
 {
  /* Valuation des variables */
  for (i=0;i<NbArg-1;i++)
  {
   if (TabArg[i]>100000)	/* Cas du codage d'un nombre */
   {
    arg[CurrArg]=(char*)calloc(1,sizeof(char)*10);
    sprintf(arg[CurrArg],"%d",TabArg[i]-200000);
    CurrArg++;
   }
   else if (TabArg[i]<-200000)/* Cas d'un id de fonction de comparaison */
   {
    IdFuncComp=TabArg[i]+250000;
   }
   else if (TabArg[i]<-100000)	/* Cas d'un id de fonction */
   {
    arg[CurrArg]=TabFunc[TabArg[i]+150000](i+1,&i,TabArg);
    CurrArg++;
   }
   else				/* Cas d'une variable */
   {
    arg[CurrArg]=strdup(TabVVar[TabArg[i]]);
    CurrArg++;
   }
  }
  Loop=TabComp[IdFuncComp](arg[0],arg[1]);
  if (Loop) ExecBloc((Bloc*)TabArg[NbArg-1]);
  free(arg[0]);
  free(arg[1]);
  CurrArg=0;
 }
}

/****************************************************/
/* Fonction d'initialisation de TabCom et TabFunc   */
/****************************************************/
void InitCom()
{
 /* commande */
 TabCom[1]=ComExec;
 TabCom[2]=ComHideObj;
 TabCom[3]=ComShowObj;
 TabCom[4]=ComChangeValue;
 TabCom[5]=ComChangePos;
 TabCom[6]=ComChangeSize;
 TabCom[7]=ComChangeIcon;
 TabCom[8]=ComChangeTitle;
 TabCom[9]=ComChangeFont;
 TabCom[10]=ComChangeForeColor;
 TabCom[11]=ComSetVar;
 TabCom[12]=ComSendSign;
 TabCom[13]=ComQuit;
 TabCom[14]=ComIfThen;
 TabCom[15]=ComLoop;
 TabCom[16]=ComWhile;
 TabCom[17]=WarpPointer;

 /* Fonction */
 TabFunc[1]=FuncGetValue;
 TabFunc[2]=FuncGetTitle;
 
 /* Fonction de comparaison */
 TabComp[1]=Inf;
 TabComp[2]=InfEq;
 TabComp[3]=Equal;
 TabComp[4]=SupEq;
 TabComp[5]=Sup;
 TabComp[6]=Diff;

}

/* read something from Fvwm */
void ReadFvwm ()
{
  static char buffer[32];
  int n;

  n = read(fd_in, buffer, 32);
  if (n == 0) {
    if (grab_server)
      XUngrabServer(x11base->display);
    exit(0);
  }
}

/* read an X event */
void ReadXServer ()
{
  static XEvent event;
  int i;
  KeySym keysym;
  char esa[12];

  while (XEventsQueued(x11base->display, QueuedAfterReading))
  {
    XNextEvent(x11base->display, &event);
    switch (event.type)
    {
      case Expose:
	   if (event.xexpose.count==0)
           {
	    for (i=0;i<nbobj;i++)
	     tabxobj[i]->DrawObj(tabxobj[i]);
	    DrawRRect(12,12,x11base->size.width-12,x11base->size.height-12);
	   }
	  break;
      case KeyPress:
	   /* Touche presse dans un objet */
	   if (event.xkey.subwindow!=0)
	   {
	    /* Envoi de l'evt  l'objet */
	    for (i=0;i<nbobj;i++)
	     if (tabxobj[i]->ObjWin==event.xkey.subwindow)
	      tabxobj[i]->EvtKey(tabxobj[i],&event.xkey);
	   }
	  break;
      case ButtonPress:
          /* Clique dans quel fenetre? */
	  if (event.xbutton.subwindow!=0)
	  {
	   i=0;
	   while ((tabxobj[i]->ObjWin!=event.xbutton.subwindow)&&(i<nbobj-1))
	    i++;
	   tabxobj[i]->EvtMouse(tabxobj[i]);
	  }
          break;
      case ButtonRelease:
	  break;
      case EnterNotify:
	  break;
      case LeaveNotify:
	  break;
      case MappingNotify:
	   XRefreshKeyboardMapping((XMappingEvent*)&event);
	  break;
    }
  }
}

/* main event loop */
void MainLoop ()
{
  fd_set fds;

  while (1) {
    FD_ZERO(&fds);
    FD_SET(fd_in, &fds);
    FD_SET(x11base->fd_x, &fds);

    XFlush(x11base->display);
    if (select(32, &fds, NULL, NULL, NULL) > 0) {
      if (FD_ISSET(fd_in, &fds))
	ReadFvwm();
      if (FD_ISSET(x11base->fd_x, &fds))
	ReadXServer();
    }
  }
}
    

/* main procedure */
main (int argc, char **argv)
{
  int i;

  /* we get rid of the path from program name */
  ScriptName = argv[0];

  if (argc < 6)
  {
    fprintf(stderr,"%s must be started by Fvwm.\n", ScriptName);
    exit(1);
  }
 else
  if(argc==7)
  {
   ScriptName = argv[6];
   fd_out = atoi(argv[1]);
   fd_in = atoi(argv[2]);
   ref = strtol(argv[4], NULL, 16);
   if (ref == 0) ref = None;
   fd[0]=fd_out;
   fd[1]=fd_in;
  }
  else 
  {
    fprintf(stderr,"%s requires only the path of the script.\n", ScriptName);
    exit(1);
  }
 
 ReadConfig(ScriptName);	/* Lecture et analyse du script */

 InitCom();

 BuildGUI();		/* Construction des boutons et de la fenetre */

 MainLoop();

}

void DeadPipe(int nonsense)
{
  exit(0);
}

/* Gestion des erreurs de syntaxes */
int yyerror(char *errmsg)
{
 fprintf(stderr,"Line %d: %s\n",numligne,errmsg);
 return 0;
}


