
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "thrust.h"

int
matchsliders(void)
{
  int i,j;
  int match,dist;

/*
  for(i=0; i<nrsliders; i++) {
    printf("Slider %d:\n", i);
    printf("\tx=%4d\ty=%4d\tdir=%d\tmatch=%d\ttype=%2d\n",
	   sliders[i].x1,
	   sliders[i].y1,
	   sliders[i].dir,
	   sliders[i].match,
	   sliders[i].type);
  }
*/
  for(i=0; i<nrsliders; i++) {
    if(!sliders[i].match && sliders[i].dir) {
      match=nrsliders;
      dist=lenx;
      for(j=0; j<nrsliders; j++) {
	if(!sliders[j].match && !sliders[j].dir
	   && ((sliders[i].type-1)/3==(sliders[j].type-1)/3)) {
	  switch(sliders[i].dir) {
	  case 1:
	    if(sliders[j].type!=12) {
	      if((sliders[i].y1 == sliders[j].y1)
		 && (sliders[j].x1>sliders[i].x1)
		 && (sliders[j].x1-sliders[i].x1 < dist)) {
		dist=sliders[j].x1-sliders[i].x1;
		match=j;
	      }
	    }
	    else
	      if((sliders[i].x1 == sliders[j].x1)
		 && (sliders[j].y1>sliders[i].y1)
		 && (sliders[j].y1-sliders[i].y1 < dist)) {
		dist=sliders[j].y1-sliders[i].y1;
		match=j;
	      }	      
	    break;
	  case 2:
	    if(sliders[j].type!=12) {
	      if((sliders[i].y1 == sliders[j].y1)
		 && (sliders[i].x1>sliders[j].x1)
		 && (sliders[i].x1-sliders[j].x1 < dist)) {
		dist=sliders[i].x1-sliders[j].x1;
		match=j;
	      }
	    }
	    else
	      if((sliders[i].x1 == sliders[j].x1)
		 && (sliders[i].y1>sliders[j].y1)
		 && (sliders[i].y1-sliders[j].y1 < dist)) {
		dist=sliders[i].y1-sliders[j].y1;
		match=j;
	      }
	    break;
	  }
	}
      }
      if(match==nrsliders) {
	printf("Found slider with no blocker.\n");
	return(0);
      }
      sliders[i].match=1;
      sliders[match].match=1;
      sliders[i].x2=sliders[match].x1;
      sliders[i].y2=sliders[match].y1;
      j=closestbutton((sliders[i].x1+sliders[i].x2)>>1,
		      (sliders[i].y1+sliders[i].y2)>>1);
      if(j<0) {
	printf("Found no botton to connect the slider with.\n");
	return(0);
      }
      j=majorbutton(j);
      sliders[i].next=((buttondata *)things[j].data)->sliders;
      ((buttondata *)things[j].data)->sliders=&sliders[i];
    }
  }
/*
  {
    slider *s;
    int i;
    int j=0;
    printf("Sliders:\n");
    for(i=0; i<nrthings; i++) {
      if(things[i].type==7 || things[i].type==8) {
	printf("Button:%d\n", ++j);
	s=((buttondata *)things[i].data)->sliders;
	while(s) {
	  printf("\tx1=%4d\ty1=%4d\tx2=%4d\ty2=%4d\tdir=%d\t"
		 "match=%d\ttype=%2d\n",
		 s->x1,
		 s->y1,
		 s->x2,
		 s->y2,
		 s->dir,
		 s->match,
		 s->type);
	  s=s->next;
	}
      }
    }
  }
*/    
  return(1);
}

int
ismajorbutton(int tag)
{
  int i;

  for(i=0; i<nrthings; i++)
    if((things[i].type==7 || things[i].type==8)
      && (((buttondata *)things[i].data)->tag==tag))
	return(i);
  return(-1);
}

void
releasebana(void)
{
  int i;

  for(i=0; i<nrthings; i++)
    if(things[i].data)
      free(things[i].data);
  nrthings=0;
  nrsliders=0;
  nrbarriers=0;
  nrrestartpoints=0;
}

int
readbana(char **ptr)
     /* Lser in banan i variablen 'bana'.
     // Filen startar med tta vrden, t.ex
     // 123
     // 69
     // 8
     // 10
     // 16
     // R
     // G
     // B
     // Dessa fem tal innebr fljande:
     // Banan r 123 tecken bred (lenx) och 69 tecken
     // hg (leny). Den brjar med 8 rader med stjrnor och
     // drefter fljer 10 tomrader.
     // Banan slutar med 16 rader med ifyllda block.
     // Efter dessa tal kommer banans definition som
     // placeras mellan tomraderna och de ifyllda blocken. */
{
  int stat=1;
  word t1,t2,x,y,z;
  word sx,sy,sz;
  byte *temp;
  buttondata *bdata;

  releasebana();

  spacestation=0;
  lenx=atoi(ptr[0]);
  if(lenx%BBILDX!=0)
    stat=0;
  lenx3=lenx<<3;
  leny=atoi(ptr[1]);
  sx=atoi(ptr[2]);
  for(sy=0; sy<3; sy++)
    if(sx<2*BBILDY) {
      sx+=BBILDY-(leny%BBILDY);
      leny+=BBILDY-(leny%BBILDY);
    }
  leny3=leny<<3;
  if(lenx*(long)leny>(long)maxlenx*maxleny)
    stat=0;
  sy=atoi(ptr[3]);
  sz=atoi(ptr[4]);
  x=y=lenx*(sx-2*BBILDY);
  colorr=atoi(ptr[5]);
  colorg=atoi(ptr[6]);
  colorb=atoi(ptr[7]);
  if(stat) {
    memset(bana,32,lenx*(sx+sy));
    x>>=6;
    for(z=0; z<BBILDY; z++) {
      t1=random()%(BBILDY*lenx);
      t2=random()%16;
      *(bana+t1)=t2;
      *(bana+t1+BBILDY*lenx)=t2;
    }
    for(; x; x--)
      *(bana+2*BBILDY*lenx+(random()%y))=random()%16;
    for(y=sx+sy; y<leny-sz && stat; y++) {
      temp=ptr[y-sx-sy+8];
      for(x=0; x<lenx && stat; x++) {
	switch(temp[x]) {
	case '#':
	  if(nrbarriers<maxbarriers) {
	    barriers[nrbarriers].x=x;
	    barriers[nrbarriers++].y=y;
	  }
	  else
	    stat=0;
	  break;
	case '*':
	  if(nrrestartpoints<maxrestartpoints) {
	    restartpoints[nrrestartpoints].x=x;
	    restartpoints[nrrestartpoints++].y=y;
	  }
	  else
	    stat=0;
	  break;
	case 64:       /* Slide \block to the right */
	case 65:       /* Slide \block to the left */
	case 66:       /* Horizontal \blocker */
	case 67:       /* Slide /block to the right */
	case 68:       /* Slide /block to the left */
	case 69:       /* Horizontal /blocker */
	case 70:       /* Slide |block to the right */
	case 71:       /* Slide |block to the left */
	case 72:       /* Horizontal |blocker */
	case 73:       /* Slide -block downwards */
	case 74:       /* Slide -block upwards */
	case 75:       /* Vertical -blocker */
	  if(nrsliders<maxsliders)
	    newslider(x,y,temp[x]-63);
	  else
	    stat=0;
	  break;
	case 76:       /* Button on left wall */
	  if(nrthings<maxthings) {
	    bdata=malloc(sizeof(buttondata));
	    if(!bdata) {
	      printf("Out of memory.\n");
	      stat=0;
	    }
	    else {
	      bdata->sliders=NULL;
	      bdata->tag=temp[x-1];
	      bdata->major=ismajorbutton(bdata->tag);
	      newthing((x<<3)+9,(y<<3)+8,x,y,7,bdata);
	    }
	  }
	  else
	    stat=0;
	  break;
	case 78:       /* Button on right wall */
	  if(nrthings<maxthings) {
	    bdata=malloc(sizeof(buttondata));
	    if(!bdata) {
	      printf("Out of memory.\n");
	      stat=0;
	    }
	    else {
	      bdata->sliders=NULL;
	      bdata->tag=temp[x-1];
	      bdata->major=ismajorbutton(bdata->tag);
	      newthing((x<<3)-1,(y<<3)+8,x,y,8,bdata);
	    }
	  }
	  else
	    stat=0;
	  break;
	case 80:       /*  |\x Bunker */
	  if(nrthings<maxthings)
	    newthing((x<<3)+14,(y<<3)+8,x,y,3,NULL);
	  else
	    stat=0;
	  break;
	case 85:       /*  x/| Bunker */
	  if(nrthings<maxthings)
	    newthing((x<<3)+10,(y<<3)+8,x,y,4,NULL);
	  else
	    stat=0;
	  break;
	case 91:       /*  |/x Bunker */
	  if(nrthings<maxthings)
	    newthing((x<<3)-2,(y<<3)+8,x-2,y,5,NULL);
	  else
	    stat=0;
	  break;
	case 92:	/*  x\| Bunker */
	  if(nrthings<maxthings)
	    newthing((x<<3)+10,(y<<3)+7,x,y,6,NULL);
	  else
	    stat=0;
	  break;
	case 96:	/* Fuel */
	  if(nrthings<maxthings)
	    newthing((x<<3)+8,(y<<3)+8,x,y,1,NULL);
	  else
	    stat=0;
	  break;
	case 100:	/* Spacestation */
	  if(nrthings<maxthings && !spacestation) {
	    spacestation=1;
	    ssblip=1;
	    ssx=x+2;
	    ssy=y;
	    newthing((x<<3)+12,(y<<3)+9,x,y,2,NULL);
	  }
	  else
	    stat=0;
	  break;
	case 109:
	  loadbx=x;
	  loadby=y;
	  break;
	}
	if(!stat)
	  printf("Unable to create a thing.\n");
      }
      memcpy(bana+(long)y*lenx,temp,lenx);
    }
    memset(bana+(long)y*lenx,112,lenx*sz);
  }

  if(stat) {
    for(x=0; x<nrthings; x++) {
      if(things[x].type==7)
	*(bana+(long)things[x].py*lenx+things[x].px-1)=112;
      if(things[x].type==8)
	*(bana+(long)things[x].py*lenx+things[x].px-1)=32;
    }
    for(x=0; x<nrsliders; x++)
      *(bana+(long)sliders[x].y1*lenx+sliders[x].x1)=112;
    if(!matchsliders()) {
      printf("Unable to match all sliders.\n");
      stat=0;
    }
    if(nrrestartpoints && !nrbarriers) {
      printf("No restartpoint for the barriers.\n");
      stat=0;
    }
    for(x=0; x<nrbarriers; x++) {
      barriers[x].restart=&restartpoints[0];
      for(y=1; y<nrrestartpoints; y++)
	if((abs(barriers[x].x-restartpoints[y].x)
	    + abs(barriers[x].y-restartpoints[y].y))
	   < (abs(barriers[x].x-barriers[x].restart->x)
	      + abs(barriers[x].y-barriers[x].restart->y)))
	  barriers[x].restart=&restartpoints[y];
    }
  }

  return(stat);
}
