/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: search.h,v 1.1 94/04/26 20:07:25 nau Exp $
 */

/* prototypes for action routines
 */

#ifndef	__SEARCH_INCLUDED__
#define	__SEARCH_INCLUDED__

#include "global.h"

/* ---------------------------------------------------------------------------
 * some useful macros
 */
/* ---------------------------------------------------------------------------
 * some define to check for 'type' in rectangle
 */
#define	VIA_OR_PIN_IN_RECTANGLE(v,x1,y1,x2,y2) \
	((v)->X >= (x1) && (v)->X <= (x2) && (v)->Y >= (y1) && (v)->Y <= (y2))
#define	LINE_IN_RECTANGLE(l,x1,y1,x2,y2) \
	((l)->X1 >= (x1) && (l)->X1 <= (x2) && \
	(l)->Y1 >= (y1) && (l)->Y1 <= (y2) && \
	(l)->X2 >= (x1) && (l)->X2 <= (x2) && \
	(l)->Y2 >= (y1) && (l)->Y2 <= (y2))
#define	RECT_IN_RECTANGLE(r,x1,y1,x2,y2) \
	((r)->X >= (x1) && (r)->X <= (x2) && \
	(r)->Y >= (y1) && (r)->Y <= (y2) && \
	(r)->X +(r)->Width <= (x2) && (r)->Y +(r)->Height <= (y2))
#define	TEXT_IN_RECTANGLE(t,x1,y1,x2,y2) \
	((t)->X >= (x1) && (t)->X <= (x2) && (t)->Y >= (y1) && (t)->Y <= (y2))

PinTypePtr		SearchVia(Position, Position);
Boolean			SearchPin(ElementTypePtr *, PinTypePtr *, Position, Position);
Boolean			SearchLine(LayerTypePtr *, LineTypePtr *, Position, Position);
Boolean			SearchRect(LayerTypePtr *, RectTypePtr *, Position, Position);
Boolean			SearchText(LayerTypePtr *, TextTypePtr *, Position, Position);
ElementTypePtr	SearchElement(Position, Position);

#endif
