/* md_unix.h
 $Header: /al/acs/src/RCS/md_unix.h,v 9.28 95/11/04 15:32:35 al Exp $
 * Special stuff for all unix systems
 */
#ifndef MD_UNIX_H
#define MD_UNIX_H
/*--------------------------------------------------------------------------*/
/* constants related to memory size, word size, etc */
#define SEGSIZ		9000000
#define	BUFLEN		256
#define BIGBUFLEN	2048
#define MAXWIDTH	512
#define PROBECOUNT	500
#define MAXEVENTCOUNT	2000
#define MAXFAULTS	100
#define SAVEITERATIONS	2
#define SAVEBACKTIME	4
#define DCNEST		4
#define RECURSE		8
#define LABELEN		8
#define MAXHANDLE	((int)((CHAR_BIT*sizeof(int))-1))
#define	OVERFLOW_TRAP	1e20

/* file names, etc. */
#define BEGINDIR	""
#define DIRSEP		"/"
#define	ENDDIR		"/"
#define PATHSEP		':'
#define SYSTEMSTARTFILE	"acs.rc"
#define SYSTEMSTARTPATH	getenv("PATH")
#define USERSTARTFILE	".acsrc"
#define	USERSTARTPATH	getenv("HOME")
#define EDITFILE   	"/tmp/EXXXXXX"
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define HELPFILE    	"acs.hlp"
#define HELPPATH	getenv("PATH")

/* standard collection of includes */
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <memory.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include <complex.h>
#include <new.h>

/* sometimes limits.h includes float.h */
#if !defined(DBL_MAX)
  #include <float.h>
#endif

/* a work around for the coming standard on complex */
typedef complex COMPLEX;

/* non-standard collection of includes */
#if defined(NEXT)
  #include <libc.h>
  #include <unistd.h>
#else		/* assume for anything else */
  #include <unistd.h>
  #include <sys/file.h>
  #include <sys/time.h>
  #include <sys/resource.h>
#endif

/* stuff not properly defined in the supplied header files. */
#if defined(NEXT)
   extern "C" char *getcwd(char *,size_t);
#elif defined(OSF)
   extern "C" char *mktemp(char*);
#elif defined(HPPA)
   #include <sys/syscall.h>
   #define getrusage(a, b)  syscall(SYS_GETRUSAGE, a, b)
#elif defined(SGI_CC)
   inline double pow(double x, int e){return pow(x,(double)e);}
#elif defined(SUN_CC)
   extern "C" int  getrusage(int,struct rusage*);
   extern "C" char *mktemp(char*);
   #define SIGNALARGS int,...
   inline void free(void* x){free((char*)x);}
   inline void* realloc(void* x, size_t n){return realloc((char*)x, n);}
#elif defined(SUN_GCC)
   extern "C" int  getrusage(int,struct rusage*);
   extern "C" char *mktemp(char*);
#endif

#if defined(HAS_EXP_BUG)
   inline double Exp(double x){return (x>-200.) ? exp(x) : 0.;}
#else
   inline double Exp(double x){return exp(x);}
#endif

#if !defined(SIGNALARGS)
  #define SIGNALARGS ...
#endif

#if defined(MAX)
  #undef MAX
#endif
#if defined(MIN)
  #undef MIN
#endif

/* need to see what the "standard" says about this */
/* want to use bool type, but ....  */
#if defined(TRUE)
  #undef TRUE
#endif
#define TRUE (1)
#if defined(FALSE)
  #undef FALSE
#endif
#define FALSE (0)
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
