/* e_aux.cc
 *$Header: /al/acs/src/RCS/e_aux.cc,v 9.25 95/10/29 01:44:52 al Exp $
 * helper functions, etc., that sort of belong to circuit elements
 * This file is a fudge, working around the fact that templates
 * don't seem to work correctly on my old compiler.
 */
#include "e_aux.h"
#include "m_matrix.h"
/*--------------------------------------------------------------------------*/
template <class T, class M>
T pi(node_t n1, node_t n2, M& mat, const T& parallel)
{
  T* zapit = new T[mat.size()+2];

  for (int ii = 0;  ii < mat.size()+2;  ++ii){
    zapit[ii] = 0.;
  }
  if (n1.m != 0)
    zapit[n1.m] =  1.;
  if (n2.m != 0)
    zapit[n2.m] = -1.;

  mat.fbsub(zapit);
  T raw_z = zapit[n1.m] - zapit[n2.m];
  delete [] zapit;
  return (parallel != 0.) 
    ? 1. / ((1./raw_z)-parallel)
    : raw_z;
}
/*--------------------------------------------------------------------------*/
double port_impedance(node_t a, node_t b, BSMATRIXdouble &c, const double &d)
{return pi(a,b,c,d);}

COMPLEX port_impedance(node_t a, node_t b, BSMATRIXCOMPLEX &c, const COMPLEX &d)
{return pi(a,b,c,d);}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
