/*
 * The Text is the non-visible counterpart to the View.  It maintains
 * the internal data structure of the whole file, but has no knowledge
 * about how to display things.  The Text is also responsible for
 * maintaining Undo information.
 *
 * There may be one or more Views of a particular piece of text.
 */
struct Text {
	Rune	*text;		/* where we store stuff */
	ulong	alloced,length;
	Range	gap;			/* buffer gap */
	Data		*data;		/* 0 for wilytag or columntag */
	Bool		isbody;
	View		*v;			/* list of views of this text */
	Bool		needsbackup;	/* this text can become dirty */

	/* temporary buffer for search operations */
	Rune	getcbuf[NGETC];	
	int		ngetc;		
	int		getci;		
	ulong	getcp;		

	Undo	*did,*undone, *mark;
	enum {NoUndo, StartUndo, MoreUndo} undoing;
};
#define TEXT_ISTAG(t) (	!(t)->isbody	)
#define TEXT_ISWINTAG(t) ((t)->v && (t)->v->win && TEXT_ISTAG(t))

/* Get next rune, going forwards */
#define	Tgetc(t)  ((--(t)->ngetc<0)? Tgetcload(t, (t)->getcp) : (t)->getcbuf[(t)->getcp++, (t)->getci++])

/* Get next rune, going backwards */
#define	Tbgetc(t) (((t)->getci<=0)? Tbgetcload(t, (t)->getcp) : (t)->getcbuf[--(t)->getcp, --(t)->getci])
