/*
 * This thing currently breaks if started with :
 *	test1 -xrm "*pane2.tearOffModel: tear_off_enabled"
 * You could leave out the pane2 part in the line above, effect is the same.
 * Breakages include :
 *	- fails to pop up the menu (X Error)
 *	- warning message when starting, about more than one menuShell child
 *	  (which if you look at the code in RowColumn.c:635 looks like the
 *	  widget is a child of the RC, not of the shell)
 *	  Inspection of the widgets with a debugger shows that the tearoffcontrol
 *	  widget is a child of the menu shell, and not of the RC.
 *	  This has a very ugly smell !!
 *	- (probably related) editres shows interesting results on this thing.
 *
 * Danny 14/3/1996
 */
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MenuShell.h>

void pb_activate_callback(Widget w, XtPointer clientData, XtPointer callData)
{
    printf ("* Widget = %s - Activated\n", XtName(w));
}

void pb_arm_callback(Widget w, XtPointer clientData, XtPointer callData)
{
    printf ("* Widget = %s - Armed\n", XtName(w));
}

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget toplevel, rc;
    Widget cascade1, dbCascade;
    Widget pane1, pane2;
    Widget button, w, ms;

/* Install converter to make the command line indicated above work */
    XmRepTypeInstallTearOffModelConverter();

/* Toplevel and Menu Bar */
    toplevel = XtVaAppInitialize(&theApp, "test1", NULL, 0, &argc, argv, NULL, NULL);
    rc = XmCreateMenuBar(toplevel, "menubar", NULL, 0);

/* First Menu */
    pane1 = XmCreatePulldownMenu(rc, "pane1", NULL, 0);

    cascade1 = XtVaCreateManagedWidget("cascade1", xmCascadeButtonWidgetClass, rc,
		XmNsubMenuId,	pane1,
	NULL);

    w = XtVaCreateManagedWidget("button1", xmPushButtonWidgetClass, pane1,
	NULL);
    XtAddCallback(w, XmNactivateCallback, pb_activate_callback, NULL);
    XtAddCallback(w, XmNarmCallback, pb_arm_callback, NULL);

    w = XtVaCreateManagedWidget("button2", xmPushButtonWidgetClass, pane1,
	NULL);
    XtAddCallback(w, XmNactivateCallback, pb_activate_callback, NULL);
    XtAddCallback(w, XmNarmCallback, pb_arm_callback, NULL);

    w = XtVaCreateManagedWidget("button3", xmPushButtonWidgetClass, pane1,
	NULL);
    XtAddCallback(w, XmNactivateCallback, pb_activate_callback, NULL);
    XtAddCallback(w, XmNarmCallback, pb_arm_callback, NULL);

/* Second Menu */
    dbCascade = XtVaCreateManagedWidget("dbCascade", xmCascadeButtonWidgetClass, rc,
	NULL);

    ms = XtCreatePopupShell("ms", xmMenuShellWidgetClass, rc,
		NULL, 0);

    pane2 = XtVaCreateWidget("pane2", xmRowColumnWidgetClass, ms,
		XmNrowColumnType,	XmMENU_PULLDOWN,
		XmNx,			0,
		XmNy,			0,
		XmNwidth,		91,
		XmNheight,		25,
	NULL);

    w = XtVaCreateManagedWidget("dummy", xmPushButtonWidgetClass, pane2,
	NULL);

    XtVaSetValues(dbCascade,
		XmNsubMenuId, pane2,
	NULL);

    XtManageChild(rc);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(theApp);    
}
