/**
 *
 * $Id: Vendor.c,v 1.35 1996/05/02 02:30:00 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: Vendor.c,v 1.35 1996/05/02 02:30:00 miers Exp $";

/*
 * Defining this stores the extension object ID in an X context.
 * Simply putting it in a widget element would probably be faster.
 */
#define	EXT_TRU_CONTEXT


#include <LTconfig.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>
#include <X11/Vendor.h>
#include <X11/VendorP.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/AtomMgr.h>
#include <Xm/BulletinBP.h>
#include <Xm/MenuShellP.h>
#include <Xm/VendorSEP.h>
#include <Xm/VendorSP.h>
#include <Xm/DisplayP.h>
#include <Xm/ScreenP.h>
#include <Xm/BaseClassP.h>
#include <Xm/ProtocolsP.h>
#include <stdio.h>
#include <stdlib.h>

#include <Xm/VendorS.h>

extern void _LesstifEditResCheckMessages(Widget w, XtPointer data, XEvent *event, Boolean *cont);

/***************************************************************************
 *
 * Vendor shell class record
 *
 ***************************************************************************/

static CompositeClassExtensionRec vendorCompositeExt = {
    /* next_extension */  NULL,
			  /* record_type    */  NULLQUARK,
			  /* version        */  XtCompositeExtensionVersion,
			  /* record_size    */  sizeof(CompositeClassExtensionRec),
			  /* accepts_objects */ True,
#if XtSpecificationRelease >= 6
			  /* allows_change_managed_set */ False
#endif
};

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget req, Widget new, ArgList args, Cardinal *num_args);
static void get_values_hook(Widget widget, ArgList args, Cardinal *num_args);
static void realize(Widget w, XtValueMask *value_mask, XSetWindowAttributes *attributes);
static void change_managed();
static void resize(Widget w);
static void initialize_posthook(Widget req, Widget new, ArgList args, Cardinal *num_args);
static void WmProtocolHandler(Widget w, XtPointer client, XtPointer call);

static XtResource vendor_resources[] = {
    {
	XmNx, XmCPosition, XmRShellHorizPos,
	sizeof(Position), XtOffsetOf(VendorShellRec, core.x),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNy, XmCPosition, XmRShellVertPos,
	sizeof(Position), XtOffsetOf(VendorShellRec, core.y),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNwidth, XmCDimension, XmRShellHorizDim,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.width),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNheight, XmCDimension, XmRShellVertDim,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.height),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNborderWidth, XmCBorderWidth, XmRShellHorizDim,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.border_width),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNbaseWidth, XmCBaseWidth, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.base_width),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNbaseHeight, XmCBaseHeight, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.base_height),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNminWidth, XmCMinWidth, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_width),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNminHeight, XmCMinHeight, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_height),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNmaxWidth, XmCMaxWidth, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_width),
        XmRImmediate, (XtPointer)XmUNSPECIFIED
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNmaxHeight, XmCMaxHeight, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_height),
        XmRImmediate, (XtPointer)XmUNSPECIFIED
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNwidthInc, XmCWidthInc, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.width_inc),
        XmRImmediate, (XtPointer)1
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNheightInc, XmCHeightInc, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.height_inc),
        XmRImmediate, (XtPointer)1
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNminAspectX, XmCMinAspectX, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_aspect.x),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNminAspectY, XmCMinAspectY, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_aspect.y),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNmaxAspectX, XmCMaxAspectX, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_aspect.x),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNmaxAspectY, XmCMaxAspectY, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_aspect.y),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XmNiconPixmap, XmCIconPixmap, XmRPixmap,
	sizeof(Pixmap), XtOffsetOf(VendorShellRec, wm.wm_hints.icon_pixmap),
        XmRPixmap, (XtPointer)NULL
    },
    {
	XmNiconX, XmCIconX, XmRHorizontalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.wm_hints.icon_x),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRHorizontalInt, (XtPointer)wacky */
    },
    {
	XmNiconY, XmCIconY, XmRVerticalInt,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.wm_hints.icon_y),
        XmRImmediate, (XtPointer)0
	/* Motif has XmRVerticalInt, (XtPointer)wacky */
    },
    {
	XtNinput, XtCInput, XmRBool,
	sizeof(Bool), XtOffsetOf(WMShellRec, wm.wm_hints.input),
	XtRImmediate, (XtPointer)True
    },
    {
	XmNwindowGroup, XmCWindowGroup, XmRWindow,
	sizeof(Window), XtOffsetOf(WMShellRec, wm.wm_hints.window_group),
	XmRImmediate, (XtPointer)00000003
	/* Motif has XmRImmediate, (XtPointer)00000003; what's this mean? */
    }
};

static XmBaseClassExtRec _XmVendorSCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL,
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

VendorShellClassRec vendorShellClassRec = {
    /* Core Class Part */
    {
	/* superclass            */ (WidgetClass)&wmShellClassRec,
	/* class_name	         */ "VendorShell",
	/* size                  */ sizeof(VendorShellRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* Class init'ed ?       */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,		
	/* realize               */ realize,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ vendor_resources,
	/* resource_count        */ XtNumber(vendor_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ TRUE,
	/* compress_enterleave   */ FALSE,
	/* visible_interest      */ FALSE,
	/* destroy               */ NULL,
	/* resize                */ resize,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,			
	/* set_values_almost     */ XtInheritSetValuesAlmost,  
	/* get_values_hook       */ get_values_hook,
	/* accept_focus          */ NULL,
	/* intrinsics version    */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmVendorSCoreClassExtRec,
    },
    /* Composite Class Part */
    {
	/* geometry_manager */ XtInheritGeometryManager,
        /* change_managed   */ change_managed,
        /* insert_child     */ XtInheritInsertChild,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ (XtPointer) &vendorCompositeExt,
    },
    /* Shell Class Part */
    {
        /* extension */ NULL
    },
    /* WMShell Class Part */
    {
        /* extension */ NULL
    },
    /* Vendor Shell Class Part */
    {
        /* extension */ NULL
    }
};

WidgetClass vendorShellWidgetClass = (WidgetClass) (&vendorShellClassRec);

static Display *default_display = NULL;

/*
 * the following is for the extension record for LessTif Vendor Shells
 */
static void ext_initialize(Widget req, Widget new, ArgList args, Cardinal *num_args);
static void ext_class_initialize();
static void ext_destroy();
static Boolean ext_set_values(Widget cw, Widget rw, Widget nw, ArgList args, Cardinal *nargs);

#define Offset(field) XtOffsetOf(XmVendorShellExtRec, vendor.field)
static XtResource ext_resources[] = {
    {
	XmNextensionType, XmCExtensionType, XmRExtensionType,
	sizeof(unsigned char), XtOffsetOf(XmVendorShellExtRec, ext.extensionType),
	XtRImmediate, (XtPointer)XmSHELL_EXTENSION
    },
    {
	XmNdefaultFontList, XmCDefaultFontList, XmRFontList,
	sizeof(XmFontList), Offset(default_font_list),
	XmRImmediate, (XtPointer)NULL
    }, 
    {
	XmNbuttonFontList, XmCButtonFontList, XmRFontList,
	sizeof(XmFontList), Offset(button_font_list),
	XmRImmediate, (XtPointer)NULL
    }, 
    {
	XmNlabelFontList, XmCLabelFontList, XmRFontList,
	sizeof(XmFontList), Offset(label_font_list),
	XmRImmediate, (XtPointer)NULL
    }, 
    {
	XmNtextFontList, XmCTextFontList, XmRFontList,
	sizeof(XmFontList), Offset(text_font_list),
	XmRImmediate, NULL
    },
    {
	XmNaudibleWarning, XmCAudibleWarning, XmRAudibleWarning,
	sizeof(unsigned char), Offset(audible_warning),
	XmRImmediate, (XtPointer)XmBELL
    },
    {
	XmNshellUnitType, XmCShellUnitType, XmRUnitType,
	sizeof(unsigned char), Offset(unit_type),
	XmRImmediate, (XtPointer)XmPIXELS /* CHECK THIS */
    },
    {
	XmNdeleteResponse, XmCDeleteResponse, XmRDeleteResponse,
	sizeof(unsigned char), Offset(delete_response),
	XmRImmediate, (XtPointer)XmDESTROY
    },
    {
	XmNkeyboardFocusPolicy, XmCKeyboardFocusPolicy, XmRKeyboardFocusPolicy,
	sizeof(unsigned char), Offset(focus_policy),
	XmRImmediate, (XtPointer)XmEXPLICIT
    },
    {
	XmNmwmDecorations, XmCMwmDecorations, XmRInt,
	sizeof(int), Offset(mwm_hints.decorations),
	XmRImmediate, (XtPointer)-1
    },
    {
	XmNmwmFunctions, XmCMwmFunctions, XmRInt,
	sizeof(int), Offset(mwm_hints.functions),
	XmRImmediate, (XtPointer)-1
    },
    {
	XmNmwmInputMode, XmCMwmInputMode, XmRInt,
	sizeof(int), Offset(mwm_hints.input_mode),
	XmRImmediate, (XtPointer)-1
    },
    {
	XmNmwmMenu, XmCMwmMenu, XmRString,
	sizeof(String), Offset(mwm_menu),
	XmRImmediate, NULL
    },
    {
	XmNfocusMovedCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(focus_moved_callback),
	XmRImmediate, NULL
    },
    {
	XmNrealizeCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(realize_callback),
	XmRImmediate, NULL
    },
    {
	XmNinputMethod, XmCInputMethod, XmRString,
	sizeof(String), Offset(input_method_string),
	XtRImmediate, (XtPointer)NULL /* FIXME */
    },
    {
	XmNpreeditType, XmCPreeditType, XmRString,
	sizeof(String), Offset(preedit_type_string),
	XtRImmediate, (XtPointer) "OffTheSpot,OverTheSpot,Root"
    },
    {
	XmNlightThreshold, XmCLightThreshold, XmRInt,
	sizeof(int), Offset(light_threshold),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNdarkThreshold, XmCDarkThreshold, XmRInt,
	sizeof(int), Offset(dark_threshold),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNforegroundThreshold, XmCForegroundThreshold, XmRInt,
	sizeof(int), Offset(foreground_threshold),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNdebugSources, XmCDebugSources, XmRString,
	sizeof(String), Offset(debug_sources),
	XtRImmediate, (XtPointer)NULL
    }
};

static XmSyntheticResource ext_syn_resources[] = {
    {
	XmNx,
	sizeof(Position), XtOffsetOf(VendorShellRec, core.x),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNy,
	sizeof(Position), XtOffsetOf(VendorShellRec, core.x),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNwidth,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.width),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNheight,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.height),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNborderWidth,
	sizeof(Dimension), XtOffsetOf(VendorShellRec, core.border_width),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNminWidth,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_width),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNminHeight,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.min_height),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNmaxWidth,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_width),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNmaxHeight,
	sizeof(int), XtOffsetOf(VendorShellRec, wm.size_hints.max_height),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNiconX,
	sizeof(Position), XtOffsetOf(VendorShellRec, wm.wm_hints.icon_x),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNiconY,
	sizeof(Position), XtOffsetOf(VendorShellRec, wm.wm_hints.icon_y),
	NULL /* FIXME */, NULL /* FIXME */
    },
#if 0
    {
	XmNmwmFunctions,
	sizeof(), XtOffsetOf(),
	NULL /* FIXME */, NULL /* FIXME */
    },
#endif
};

XmVendorShellExtClassRec xmVendorShellExtClassRec = {
    /* Object Class Part */
    {
 	/* superclass         */    (WidgetClass)&xmShellExtClassRec,
	/* class_name         */    "XmVendorShellExt",
	/* size               */    sizeof(XmVendorShellExtRec),
	/* class_initialize   */    ext_class_initialize,
	/* class_part_initialize*/  NULL,
	/* Class init'ed ?    */    FALSE,
	/* initialize         */    ext_initialize,
	/* initialize_hook    */    NULL,
	/* pad                */    NULL,
	/* pad                */    NULL,
	/* pad                */    0,
	/* resources          */    ext_resources,
	/* resource_count     */    XtNumber(ext_resources),
	/* xrm_class          */    NULLQUARK,
	/* pad                */    FALSE,
	/* pad                */    FALSE,
	/* pad                */    FALSE,
	/* pad                */    FALSE,
	/* destroy            */    ext_destroy,
	/* pad                */    NULL,
	/* pad                */    NULL,
	/* set_values         */    ext_set_values,
	/* set_values_hook    */    NULL,
	/* pad                */    NULL,
	/* get_values_hook    */    NULL,
	/* pad                */    NULL,
	/* version            */    XtVersion,
	/* callback_offsets   */    NULL,
	/* pad                */    NULL,
	/* pad                */    NULL,
	/* pad                */    NULL,
	/* extension          */    NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ ext_syn_resources,
        /* num_syn_resources  */ XtNumber(ext_syn_resources),
        /* extension          */ NULL
    },
    /* Desktop Class part */
    {
        /* child_class           */ NULL,
        /* insert_child          */ NULL,
        /* delete_child          */ NULL,
        /* extension             */ NULL
    },
    /* ShellExt Class part */
    {
	/* extension          */    NULL
    },
    /* VendorClass Part */
    {
	/* extension          */    NULL
    }
};

WidgetClass xmVendorShellExtObjectClass = (WidgetClass) &xmVendorShellExtClassRec;

static void 
class_initialize()
{
    /* we only do this here so that people can override the default reptypes,
       based on information from Harold Albrect */
    _XmInitializeExtensions();
    _XmVendorSCoreClassExtRec.record_type = XmQmotif;

    XmSetColorCalculation(NULL);
    _XmRegisterConverters();
    _XmSetupImageCache();
}

static void 
class_part_initialize(WidgetClass widget_class)
{
    CompositeClassExtension ext, *extptr;
    VendorShellWidgetClass vsclass = (VendorShellWidgetClass) widget_class;

    XdbDebug(__FILE__, NULL, "Vendor Shell's class_part_initialize()\n");
    extptr = (CompositeClassExtension*)_XmGetClassExtensionPtr((XmGenericClassExt*)&(vsclass->composite_class.extension),
							       NULLQUARK);

    if (extptr == NULL || *extptr == NULL)
    {
	ext = (CompositeClassExtension) XtNew(CompositeClassExtensionRec);
	if (ext != NULL)
	{
	    ext->next_extension = vsclass->composite_class.extension;
	    ext->record_type = NULLQUARK;
	    ext->version = XtCompositeExtensionVersion;
	    ext->record_size = sizeof(CompositeClassExtensionRec);
	    ext->accepts_objects = True;
#if XtSpecificationRelease >= 6
	    ext->allows_change_managed_set = False;
#endif
	    vsclass->composite_class.extension = (XtPointer) ext;
	}
    }

    _XmBaseClassPartInitialize(widget_class);
    _XmFastSubclassInit(widget_class, XmVENDOR_SHELL_BIT);
}

static void 
initialize_posthook(Widget req, 
	   Widget new, 
	   ArgList args, 
	   Cardinal *num_args)
{
    XmDisplay	d;
    XmScreen    s;

    /*
     * I had to move this here to avoid recursion problems with XmDisplay
     */
    if (!XmIsDisplay(new)) {
	d = (XmDisplay)XmGetXmDisplay(XtDisplay(new));

	s = (XmScreen)XmGetXmScreen(XtScreen(new));
 
	d->display.shellCount++;
    }
}

static void 
initialize(Widget req, 
	   Widget new, 
	   ArgList args, 
	   Cardinal *num_args)
{
    XmWidgetExtData data;
    Arg arg[1], *mrg;

    XdbDebug(__FILE__, new,
	     "##########VendorShell %s initialize\n", XtName(new));

    if (!default_display)
	default_display = XtDisplay(new);

    if (!XmIsDisplay(new)) {

	/* add the handler for editres messages */
	XtAddEventHandler(new, (EventMask)0, True, 
                          (XtEventHandler)_LesstifEditResCheckMessages, NULL);

	XdbDebug(__FILE__, new, "Setting up virtual key bindings\n");

	XtSetKeyTranslator(XtDisplay(new), (XtKeyProc)XmTranslateKey);

	data = (XmWidgetExtData)XtCalloc(1, sizeof(XmWidgetExtDataRec));

	XtSetArg(arg[0], XmNlogicalParent, new);
	mrg = XtMergeArgLists(args, *num_args, arg, 1);
	data->widget = XtCreateWidget("shellext", xmVendorShellExtObjectClass,
				      new, mrg, *num_args + 1);
	XtFree((char *)mrg);

#ifdef	EXT_TRU_CONTEXT
	_XmPushWidgetExtData(new, data, XmSHELL_EXTENSION);
	XdbDebug2(__FILE__, new, data ? data->widget : NULL, "Pushing Extension record\n");
#else
#endif
    }
}

static void 
realize(Widget w,
	XtValueMask *value_mask,
	XSetWindowAttributes *attributes)
{
    XmVendorShellExtObject ve = NULL;
    Atom wm_delete_window;
    XmWidgetExtData data;

#define superclass (&wmShellClassRec)
    (*superclass->core_class.realize)(w, value_mask, attributes);
#undef superclass

    XdbDebug(__FILE__, w, "Realize\n");

#ifdef	EXT_TRU_CONTEXT
    data = _XmGetWidgetExtData(w, XmSHELL_EXTENSION);
    if (!data)
	ve = NULL;
    else
	ve = (XmVendorShellExtObject)data->widget;
#else
#endif

    wm_delete_window = XInternAtom(XtDisplay(w), "WM_DELETE_WINDOW", False);

    XmAddWMProtocols(w, &wm_delete_window, 1);
    XmAddWMProtocolCallback(w, wm_delete_window, WmProtocolHandler, NULL);

    if (ve && ve->vendor.mwm_hints.flags) {
	XChangeProperty(XtDisplay(w),
			XtWindow(w),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			32,
			PropModeReplace,
			(unsigned char*)&(ve->vendor.mwm_hints.flags),
			1);

	XChangeProperty(XtDisplay(w),
			XtWindow(w),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			32,
			PropModeAppend,
			(unsigned char*)&(ve->vendor.mwm_hints.functions),
			1);

	XChangeProperty(XtDisplay(w),
			XtWindow(w),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			32,
			PropModeAppend,
			(unsigned char*)&(ve->vendor.mwm_hints.decorations),
			1);

	XChangeProperty(XtDisplay(w),
			XtWindow(w),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			32,
			PropModeAppend,
			(unsigned char*)&(ve->vendor.mwm_hints.input_mode),
			1);

	XChangeProperty(XtDisplay(w),
			XtWindow(w),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			XmInternAtom(XtDisplay(w), "_MOTIF_WM_HINTS", False),
			32,
			PropModeAppend,
			(unsigned char*)&(ve->vendor.mwm_hints.status),
			1);	
    }
}

static void
WmProtocolHandler(Widget w, XtPointer client, XtPointer call)
{
    XmVendorShellExtObject ve;
    XmWidgetExtData data;
    
    XdbDebug(__FILE__, w, "WmProtocolHandler\n");

#ifdef	EXT_TRU_CONTEXT
    data = _XmGetWidgetExtData(w, XmSHELL_EXTENSION);
    if (!data)
	ve = NULL;
    else
	ve = (XmVendorShellExtObject)data->widget;
#else
#endif

    switch (ve->vendor.delete_response) {
	case XmDESTROY:
	    XtDestroyWidget(w);
	    if (XtIsApplicationShell(w)) {
		XdbDebug(__FILE__, w, "Exiting due to WM_DELETE_WINDOW\n");
		XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
		exit(0);
	    }
	    break;
	case XmUNMAP:
	    XtUnmapWidget(w);
	    break;
	case XmDO_NOTHING:
	    return ;
	    break;
    }
}

static void resize(Widget w)
{
    /* Chain up for now -- needed due to the resize mechanism */
    wmShellClassRec.core_class.resize(w);
} /* resize */

static void 
change_managed(Widget wid)
{
    ShellWidget w = (ShellWidget) wid;
    Widget* childP;
    int i;

#define superclass (&wmShellClassRec)
    (*superclass->composite_class.change_managed)(wid);
#undef superclass
    for (i = w->composite.num_children, childP = w->composite.children;
	 i; i--, childP++) {
	if (XtIsManaged(*childP)) {
	    XtSetKeyboardFocus(wid, *childP); /* replace this with the lesstif focus
						 handling stuff when it's in.. FIX ME */
	    break;
	}
    }
}

/*
 * FIXME -- this should move to _XmExtGetValuesHook
 */
static void
get_values_hook(Widget widget, 
		ArgList args,
		Cardinal *num_args)
{
    XmVendorShellExtObject ve;
    XmWidgetExtData data;

#ifdef	EXT_TRU_CONTEXT
    data = _XmGetWidgetExtData(widget, XmSHELL_EXTENSION);
    if (!data)
	ve = NULL;
    else {
	ve = (XmVendorShellExtObject)data->widget;
#else
#endif

	XtGetValues((XtPointer)ve, args, *num_args);
    }
}

static void 
ext_initialize(Widget req, 
	       Widget new, 
	       ArgList args, 
	       Cardinal *num_args)
{
    XmVendorShellExtObject ve = (XmVendorShellExtObject)new;

    XdbDebug(__FILE__, new, "VendorShellExt %s initialize\n", XtName(new));

    /* initialize the button font list */
    if (ve->vendor.button_font_list == NULL)
	if (ve->vendor.default_font_list)
	    ve->vendor.button_font_list = ve->vendor.default_font_list;
	else 
	    ve->vendor.button_font_list = _XmGetDefaultFontList(ExtObj_LogicalParent(new),
								XmBUTTON_FONTLIST);

    /* initialize the label font list */
    if (ve->vendor.label_font_list == NULL)
	if (ve->vendor.default_font_list)
	    ve->vendor.label_font_list = ve->vendor.default_font_list;
	else 
	    ve->vendor.label_font_list = _XmGetDefaultFontList(ExtObj_LogicalParent(new),
								   XmLABEL_FONTLIST);

    /* initialize the text font list */
    if (ve->vendor.text_font_list == NULL)
	if (ve->vendor.default_font_list)
	    ve->vendor.text_font_list = ve->vendor.default_font_list;
	else 
	    ve->vendor.text_font_list = _XmGetDefaultFontList(ExtObj_LogicalParent(new),
								  XmTEXT_FONTLIST);

    ve->vendor.mwm_hints.flags = 0;

    if (ve->vendor.mwm_hints.functions != -1)
	ve->vendor.mwm_hints.flags |= MWM_HINTS_FUNCTIONS;
    if (ve->vendor.mwm_hints.decorations != -1)
	ve->vendor.mwm_hints.flags |= MWM_HINTS_DECORATIONS;
    if (ve->vendor.mwm_hints.input_mode != -1)
	ve->vendor.mwm_hints.flags |= MWM_HINTS_INPUT_MODE;

    /* initialize the protocols so they can be XtRealloc'ed later */
    ve->vendor.protocols = NULL;
    ve->vendor.im_info = NULL;
}

static void 
ext_class_initialize()
{
    XdbDebug(__FILE__, NULL, "Vendor Shell's ext_class_initialize()\n");
}

static void 
ext_destroy()
{
    XdbDebug(__FILE__, NULL, "Vendor Shell's ext_destroy()\n");
}

static Boolean 
ext_set_values(Widget cw, Widget rw, Widget nw, ArgList args, Cardinal *nargs)
{
    XdbDebug(__FILE__, nw, "VendorShellExt %s SetValues\n", XtName(nw));

    return False;
}

Cardinal
_XmFilterResources(XtResource *resources,
		   Cardinal numResources,
		   WidgetClass filterClass,
		   XtResource **filteredResourcesRtn)
{
    *filteredResourcesRtn = NULL;
    return 0;
}

void
_XmAddGrab(Widget wid,
	   Boolean exclusive,
	   Boolean spring_loaded)
{
}

void
_XmRemoveGrab(Widget wid)
{
}

XtGeometryResult
_XmRootGeometryManager(Widget w,
		       XtWidgetGeometry *request,
		       XtWidgetGeometry *reply)
{
    return XtGeometryNo;
}

void
_XmVendorExtRealize(Widget w,
		    XtPointer closure,
		    XtPointer call_data)
{
}

Display *
_XmGetDefaultDisplay(void)
{
    return default_display;
}

unsigned char
_XmGetAudibleWarning(Widget w)
{
    return 0;
}

char *
_XmGetIconPixmapName(void)
{
    return NULL;
}

void
_XmClearIconPixmapName(void)
{
}

/* To be used elsewhere ... */
Widget
_LtFindVendorExt(Widget w)
{
    Widget p;
    XmWidgetExtData data;

    if (w == (Widget)0)
	return NULL;

    for (p=w;
	 !XtIsSubclass(p, vendorShellWidgetClass) && XtParent(p);
	 p = XtParent(p))
	;

#ifdef	EXT_TRU_CONTEXT
    data = _XmGetWidgetExtData(p, XmSHELL_EXTENSION);
    if (data)
	return data->widget;
    else
	return NULL;
#else
#endif
}
