/**
 * 
 * $Id: MenuShell.c,v 1.32 1996/05/02 02:29:55 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: MenuShell.c,v 1.32 1996/05/02 02:29:55 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/MenuShellP.h>
#include <Xm/TransltnsP.h>
#include <Xm/RowColumnP.h>
#include <Xm/CascadeBP.h>
#include <stdio.h>

/* Forward Declarations */
static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void realize(Widget w, XtValueMask *value_mask, XSetWindowAttributes *attributes);
static void expose(Widget w, XEvent *event, Region region);
static void resize(Widget w);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static XtGeometryResult GeometryManager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply);
static void ChangeManaged(Widget w);
static void insert_child(Widget w);

#define Offset(field) XtOffsetOf(XmMenuShellRec, menu_shell.field)

/* Resources for the MenuShell class */
static XtResource resources[] = {
    {
	XmNdefaultFontList, XmCDefaultFontList, XmRFontList,
	sizeof(XmFontList), Offset(default_font_list),
	XmRString, (XtPointer)NULL
    },
    {
	XmNlabelFontList, XmCLabelFontList, XmRFontList,
	sizeof(XmFontList), Offset(label_font_list),
	XmRFontList, (XtPointer)NULL
    },
    {
	XmNbuttonFontList, XmCButtonFontList, XmRFontList,
	sizeof(XmFontList), Offset(button_font_list),
	XmRFontList, (XtPointer)NULL
    }
};

static void MenuShellPopdownDone(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuShellPopdownOne(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmMenuShell_translations[] = 
   "<BtnDown>:            ClearTraversal()\n\
    <BtnUp>:              MenuShellPopdownDone()";

static XtActionsRec actions[] = {
    {"ClearTraversal", _XmClearTraversal},
    {"MenuShellPopdownOne", MenuShellPopdownOne},
    {"MenuShellPopdownDone", MenuShellPopdownDone},
};

static XmBaseClassExtRec _XmMenuSCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

XmMenuShellClassRec xmMenuShellClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &overrideShellClassRec,
        /* class_name            */ "XmMenuShell",
	/* widget_size           */ sizeof(XmMenuShellRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ realize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ _XmMenuShell_translations,
	/* query_geometry        */ NULL,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmMenuSCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */	GeometryManager,
        /* change_managed   */	ChangeManaged,
        /* insert_child     */ insert_child,
        /* delete_child     */ NULL,
        /* extension        */ NULL,	
    },
    /* Shell class part */
    {
	/* extension        */ NULL,
    },
    /* Override class part */
    {
	/* extension        */ NULL,
    },
    /* XmMenuShell class part */
    {
	/* extension        */ NULL,
    },
};

WidgetClass xmMenuShellWidgetClass = (WidgetClass)&xmMenuShellClassRec;

static void
class_initialize()
{
    _XmMenuSCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmMENU_SHELL_BIT);
}

static void
initialize_posthook(Widget request,
		    Widget new,
		    ArgList args,
		    Cardinal *num_args)
{
#if 1
    /*
     * MLM: this can't be right, but it works for Mosaic-2.7b4
     * Maybe we should pay attention to this if XmNallowShellResize
     * is False?  FIXME
     */
    if (XtWidth(request) != 0 && XtHeight(request) != 0)
	XtRealizeWidget(new);
#endif
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmMenuShellWidget mw = (XmMenuShellWidget)new;

    if (mw->menu_shell.button_font_list == NULL)
	if (mw->menu_shell.default_font_list != NULL)
	    mw->menu_shell.button_font_list = mw->menu_shell.default_font_list;
	else
	    mw->menu_shell.button_font_list = _XmGetDefaultFontList(new,
								    XmBUTTON_FONTLIST);

    if (mw->menu_shell.label_font_list == NULL)
	if (mw->menu_shell.default_font_list != NULL)
	    mw->menu_shell.label_font_list = mw->menu_shell.default_font_list;
	else
	    mw->menu_shell.label_font_list = _XmGetDefaultFontList(new,
								   XmLABEL_FONTLIST);
    XtBorderWidth(new) = 0;
}

static void
destroy(Widget w)
{
}

static void
resize(Widget w)
{
    /* do nothing, since menu shells don't resize themselves */
    XdbDebug(__FILE__, w, "Resize\n");
}

static void 
realize(Widget w, 
	XtValueMask *value_mask, 
	XSetWindowAttributes *attributes)
{
    *value_mask = CWBackPixmap | CWBorderPixel | CWBitGravity | CWOverrideRedirect | CWEventMask | CWSaveUnder | CWColormap;

    attributes->background_pixmap = None;
    attributes->save_under = True;
    attributes->bit_gravity = NorthWestGravity;
    attributes->override_redirect = True;
    attributes->event_mask = ButtonPressMask | ButtonReleaseMask | StructureNotifyMask;

    if (XtWidth(w) == 0)
	XtWidth(w) = 1;
    if (XtHeight(w) == 0)
	XtHeight(w) = 1;

#define superclass (&overrideShellClassRec)    
    (*superclass->core_class.realize)(w, value_mask, attributes);
#undef superclass
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
	XdbDebug(__FILE__, w, "Expose\n");
}

static Boolean 
set_values(Widget current,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "SetValues\n");

    return True;
}

static XtGeometryResult 
GeometryManager(Widget w,
		 XtWidgetGeometry *request,
		 XtWidgetGeometry *reply)
{
    XdbDebug(__FILE__, w, "GeometryManager\n");

    reply = request;
    return XtGeometryYes;
}

static void
ChangeManaged(Widget w)
{
    XtWidgetGeometry	geo;

    if (((XmMenuShellRec *)w)->shell.allow_shell_resize) {
	/* MenuShell's take their height/width/border_width from the child */
	XtQueryGeometry(MGR_Children(w)[0], NULL, &geo);

	/* FIX ME: should look at the flags */
	_XmResizeObject(w, geo.width, geo.height, geo.border_width);
    }

    XdbDebug(__FILE__, w, "ChangeManaged width %d height %d\n",
	XtWidth(w), XtHeight(w));
}

static void
insert_child(Widget w)
{
    XmMenuShellWidget	ms = (XmMenuShellWidget)XtParent(w);

    if (ms->composite.num_children == 1) {
	_XmWarning((Widget)ms, "XmMenuShell can only accept one child\n");
    } else if (!XmIsRowColumn(w)) {
	_XmWarning(w, "XmMenuShell can only accept one XmRowColumn child\n");
    } else {
#define superclass (&overrideShellClassRec)    
	(*superclass->composite_class.insert_child)(w);
#undef superclass
    }
    /* MLM: This seems reasonable, but probably isn't. Makes Mosaic2.7b4
     * look right, tho' -- FIXME */
    XtX(w) = XtY(w) = 0;
}

static void
MenuShellPopdownDone(Widget w,
		     XEvent *event,
		     String *params,
		     Cardinal *num_params)
{
    Widget parent;

    XdbDebug(__FILE__, w, "MenuShellPopdownDone()\n");

    /* The documentation says this action procedure unposts the whole menu tree.
       This should really include sub menus, so that all the cascade buttons
       are correctly disarmed. */

    /* Popdown this level and all sub levels */
    XtCallActionProc(w, "MenuShellPopdownOne", event, NULL, 0);

    /* Popdown parent (and it's ancestors */
    parent = XtParent(w);

    if (parent && XmIsRowColumn(parent))
    {
	/* If parent is a child of a menu shell, then pop that down too */
	if (XtParent(parent) && XmIsMenuShell(XtParent(parent)))
        {
	    XdbDebug(__FILE__, w, "    Doing MenuShellPopdownDone(%s)\n",
		     XtName(XtParent(parent)));
	    XtCallActionProc(XtParent(parent), "MenuShellPopdownDone",
				      event, NULL, 0);
	}
	else
        {
	    /* The parent is the top of our shell tree, make sure its
	       record reflects the fact that its previously posted popup
	       (i.e, 'w') is no longer valid */
	    RC_PopupPosted(parent) = NULL;
	}
    }
}

static void
MenuShellPopdownOne(Widget w,
		    XEvent *event,
		    String *params,
		    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuShellPopdownOne()\n");
    
    /* Locate the menu pane for this shell */
    if (((XmMenuShellWidget)w)->composite.num_children == 1)
    {
	Widget rc = ((XmMenuShellWidget)w)->composite.children[0];
	
	/* Ignore child if its not a rowcolumn widget */
	if (rc && XmIsRowColumn(rc))
        {
	    XdbDebug(__FILE__, w, "  Child menu pane is %s\n", XtName(rc));
	    
	    /* Popdown any sub menu's first */
	    if (RC_PopupPosted(rc) && XmIsMenuShell(RC_PopupPosted(rc)))
    	    {
		/* Menu has an active sub menu, recurse */
		XdbDebug(__FILE__, w, "  Doing MenuShellPopdownOne(%s)\n",
			 XtName(RC_PopupPosted(rc)));
		XtCallActionProc(RC_PopupPosted(rc), "MenuShellPopdownOne",
				 event, NULL, 0);
	    }
	    
	    /* unhighlight the cascade button that popped us up. */
	    if (RC_CascadeBtn(rc))
  	    {
		XdbDebug(__FILE__, w, "Unhighlighting cascade button %s\n",
			 XtName(RC_CascadeBtn(rc)));
		XmCascadeButtonHighlight(RC_CascadeBtn(rc), False);
		
		/* Disarm the button */
		CB_SetArmed(RC_CascadeBtn(rc), False);
	    }
	    
	    /* Now deactivate this menu pane */
	    RC_PopupPosted(rc) = NULL;
	    RC_CascadeBtn(rc)  = NULL;
	} /* If child widget is an rc widget */
    } /* If there is a child widget */
    
    /* now, we return the focus to the widget that had it before
       the menu stuff happened.... */
    
    /* Popdown this shell */
    XtPopdown(w);
}

void
_XmEnterRowColumn(Widget widget,
		  XtPointer closure,
		  XEvent *event,
		  Boolean *cont)
{
}

void
_XmClearTraversal(Widget wid,
		  XEvent *event,
		  String *params,
		  Cardinal *num_params)
{
	XdbDebug(__FILE__, wid, "_XmClearTraversal(not implemented)\n");
}

void
_XmSetLastManagedMenuTime(Widget wid, Time newTime )
{
}


Widget
XmCreateMenuShell( Widget parent, char *name, ArgList arglist, Cardinal argcount )
{
    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    return XtCreatePopupShell(name, xmMenuShellWidgetClass, parent,
			      arglist, argcount);
}

