/*Copyright (c) 1993-1997 Xerox Corporation.  All Rights Reserved.

  Permission to use, copy, modify  and  distribute  without  charge
  this  software,  documentation, images, etc. is granted, provided
  that this copyright and the author's name is retained.

  A fee may be charged for this program ONLY to recover  costs  for
  distribution  (i.e.  media costs).  No profit can be made on this
  program.

  The author assumes no responsibility for  disasters  (natural  or
  otherwise) as a consequence of use of this software.

  Adam Stein (adam@iset.scan.mc.xerox.com)
*/

#include <stdio.h>
#include <X11/Xlib.h>
#include "xtoolplaces.h"

extern char *program;

/*This function will read in the list of X applications.

  Inputs:  file         - file to read
	   indx		- index into list
	   list		- list of X applications
  Outputs: none
  Locals:  fp           - file pointer to read from
           line         - line of text read in
  Globals: program      - name of currently executing program
           stderr       - standard error
           NULL         - 0
*/
readfile(file, list, indx)
int *indx;
char *file, *list[50];
{
        char line[200];
        FILE *fp;

        /*Open the file for reading*/
        if((fp = fopen(file,"r")) == NULL) {
          fprintf(stderr,"%s: can't open {%s}\n",program,file);
          exit(1);
        }

        *indx = 0;

        /*Read lines from file until there is no more*/
        while(fgets(line,200,fp) != NULL)
          switch(line[0]) {
            case '#':                   /*Comment character - ignore line*/
            case '\n':                  /*Blank line - ignore line*/
                        break;
            default:
                        line[strlen(line)-1] = '\0';  /*Take out NL char*/
                        if((list[(*indx)++] = strdup(line)) == NULL) {
                          perror(program);
                          exit(1);
                        }

                        break;
          }
}

/*This function will determine if an application's window is the specified
  applications list.  A 1 is returned if on the list, 0 if not.

  Inputs:  list	  - list of X applications to check against
	   numval - number of values in list
	   window - ID of the window that we are going to check
  Outputs: result - 1 if application is on the list, 0 if not
  Locals:  loop   - loop through name list
           name   - name of window
           result - flag indicating if window is on list or not
  Globals: none
*/
on_list(window, list, numval)
char *list[50];
int numval;
Window window;
{
        int loop,result;
        char *name;
        char *getname();

        result = 0;

	/*Get name of X window*/
        if(name = getname(window)) {
          for(loop = 0;!result && (loop < numval);++loop)
            if(!strcmp(name,list[loop])) result = 1;

          XFree(name);
        }

        return(result);
}

