/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInMFRotation.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFRotation;

public class EventInMFRotation extends EventIn
{
  public void setValue (float[][] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null)
      throw new IllegalArgumentException ();

    float[] data = new float[value.length * 4];

    int index = 0;
    for (int i = 0; i < value.length; i++)
    {
      if (value[i].length != 4)
        throw new IllegalArgumentException ();
      data[index] = value[i][0];
      data[index+1] = value[i][1];
      data[index+2] = value[i][2];
      data[index+3] = value[i][3];
      index += 4;
    }

    ((MFRotation) eventin_).setValue (data);

    sendEvent ();

    scene_.redraw ();
  }

  public void set1Value (int index, float[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (index < 0 || index >= ((MFRotation) eventin_).getValueCount () || value == null || value.length != 4)
      throw new IllegalArgumentException ();

    float[] data = ((MFRotation) eventin_).getValueData ();
    index *= 4;
    data[index] = value[0];
    data[index+1] = value[1];
    data[index+2] = value[2];
    data[index+3] = value[3];

    sendEvent ();

    scene_.redraw ();
  }
}
