/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInMFNode.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFNode;
import vrml.external.Node;

import java.util.Vector;

public class EventInMFNode extends EventIn
{
  public void setValue (Node[] node) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (node == null)
      throw new IllegalArgumentException ();

    iicm.vrml.pw.Node[] pwnodes = new iicm.vrml.pw.Node[node.length];
    for (int i = 0; i < node.length; i++)
      pwnodes[i] = node[i].getpwNode ();

    ((MFNode) eventin_).setValue (pwnodes);

    sendEvent ();

    scene_.redraw ();
  }

  public void set1Value (int index, Node node) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (index < 0 || index >= ((MFNode) eventin_).getValueCount () || node == null)
      throw new IllegalArgumentException ();

    Vector pwnodes = ((MFNode) eventin_).getNodes ();
    pwnodes.setElementAt (node.getpwNode (), index);
    
    sendEvent ();

    scene_.redraw ();
  }
}
