/*
 * DialogSettings.java
 *
 * created: apesen, 19970214
 *
 * changed: kwagen, 19970602
 * changed: mpichler, 19970806
 *
 * $Id: DialogSettings.java,v 1.3 1997/09/19 15:45:08 mpichler Exp $
 */

package iicm.vrml.vrwave;

import iicm.widgets.*;
import java.awt.*;


/**
 * DialogSettings - settings dialog
 *
 * @author Andreas Pesendorfer, Karl Heinz Wagenbrunn
 * @version 1.0, latest change: 2 June 1997
 */

class DialogSettings extends Frame
{
  static final int GAP = 10;
  static final int AI_AVColDis = 0;
  static final int AI_AVNSF    = 1;
  static final int AI_AVFTZS   = 2;
  static final int AI_AVFTRS   = 3;
  static final int AI_AVQUCOM  = 4;
  static final int AI_AVSVBSP  = 5;
  private Button ok_, reset_, apply_, close_;

  AdjValueBlock adjvalB;
  AdjustableValue[] adv = new AdjustableValue[6];
  Scene scene_;

  public DialogSettings (Scene s) 
  {
    super (Translator.getLabel (Translator.L_SETTINGS));

    scene_ = s;

    Panel framepanel = new Panel ();

    framepanel.setLayout (new BorderLayout(GAP, GAP));

    Panel workpanel = new Panel ();
    adjvalB = new AdjValueBlock ();

    // adv[AI_AVColDis] = adjvalB.add(0.10, 20.0, 1.5, 2,Translator.L_Set_AVColDis);
    // adv[AI_AVNSF   ] = adjvalB.add(0.10, 10.0, 1.0, 2,Translator.L_Set_AVNSF);
    // adv[AI_AVFTZS  ] = adjvalB.add(0.01, 0.6, 0.03, 2,Translator.L_Set_AVFTZS);
    // adv[AI_AVFTRS  ] = adjvalB.add(0.02, 0.9, 0.03, 2,Translator.L_Set_AVFTRS);
    adv[AI_AVQUCOM ] = adjvalB.add (4.0, 36.0, s.getQuadslices (), 0, Translator.getLabel (Translator.L_QUADSLICES));
    // adv[AI_AVSVBSP ] = adjvalB.add(0.0, 30.0, 10.0, 0,Translator.L_Set_AVSVBSP);

    Panel ButtonLine = new Panel ();
    ButtonLine.setLayout (new FlowLayout(FlowLayout.CENTER, GAP, GAP));
    ButtonLine.setFont (Fontify.fntButton);

    ButtonLine.add (ok_ = new Button (Translator.getLabel (Translator.B_OK)));
    ButtonLine.add (reset_ = new Button (Translator.getLabel (Translator.B_RESET)));
    ButtonLine.add (apply_ = new Button (Translator.getLabel (Translator.B_APPLY)));
    // a cancel button that restores the previous values would be more useful than close
    ButtonLine.add (close_ = new Button (Translator.getLabel (Translator.B_CLOSE)));
    // ButtonLine.add(new Button(help_ = Translator.L_Set_BHelp));
    Panel adjvalpanel = new Panel ();
    adjvalpanel.add (adjvalB);
    framepanel.add ("Center", adjvalpanel);
    framepanel.add ("South", ButtonLine);

    add ("Center",framepanel);
    pack();
  } 

  public boolean action (Event e, Object arg)
  {
    if (e.target == ok_ || e.target == apply_)
    {
      scene_.setQuadslices (new Double (adv[AI_AVQUCOM ].getValue ()).intValue ());
      if (e.target == ok_)
        dispose ();
    }
    if (e.target == reset_)
    {
      // adv[AI_AVColDis].setText(1.5);
      // adv[AI_AVNSF   ].setText(1.0);
      // adv[AI_AVFTZS  ].setText(0.03);
      // adv[AI_AVFTRS  ].setText(0.03);
      adv[AI_AVQUCOM ].setText (16.0);  scene_.setQuadslices (16);
      // adv[AI_AVSVBSP ].setText(10.0);
    }
    if (e.target == close_)
    {
      dispose ();
      return false;
    }
//     if (e.target == help_)
//     {
//       scene_.showHelp ("settings.html");
//     }
    return true;
  } // action

} // DialogSettings
