/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable {
    private transient Calendar cal;
    private transient long fastTime;
    private transient boolean modified;
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this.cal = null;
        this.fastTime = l;
        this.modified = false;
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        this.cal = new GregorianCalendar(n + 1900, n2, n3, n4, n5, n6);
        this.cal.complete();
        this.modified = false;
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(1, n + 1900);
        gregorianCalendar.set(2, n2);
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    /*
     * Unable to fully structure code
     */
    public static long parse(String var0) {
        block39: {
            var1_1 = -1;
            var2_2 = -1;
            var3_3 = -1;
            var4_4 = -1;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = 0;
            var9_9 = -1;
            var10_10 = -1;
            var11_11 = 0;
            if (var0 == null) break block39;
            var12_12 = var0.length();
            block0: while (var8_8 < var12_12) {
                block40: {
                    var7_7 = var0.charAt(var8_8);
                    ++var8_8;
                    if (var7_7 <= 32 || var7_7 == 44) continue;
                    if (var7_7 == 40) {
                        var13_13 = 1;
                        while (var8_8 < var12_12) {
                            var7_7 = var0.charAt(var8_8);
                            ++var8_8;
                            if (var7_7 == 40) {
                                ++var13_13;
                                continue;
                            }
                            if (var7_7 == 41 && --var13_13 <= 0) continue block0;
                        }
                        continue;
                    }
                    if (var7_7 < 48 || var7_7 > 57) break block40;
                    var9_9 = var7_7 - 48;
                    if (true) ** GOTO lbl35
                    do {
                        var9_9 = var9_9 * 10 + var7_7 - 48;
                        ++var8_8;
lbl35:
                        // 2 sources

                        if (var8_8 >= var12_12) break;
                        v0 = var0.charAt(var8_8);
                        var7_7 = v0;
                    } while (v0 >= '0' && var7_7 <= 57);
                    if (var11_11 == 43 || var11_11 == 45 && var1_1 >= 0) {
                        var9_9 = var9_9 < 24 ? (var9_9 *= 60) : var9_9 % 100 + var9_9 / 100 * 60;
                        if (var11_11 == 43) {
                            var9_9 = -var9_9;
                        }
                        if (var10_10 != 0 && var10_10 != -1) break block39;
                        var10_10 = var9_9;
                    } else if (var9_9 >= 70) {
                        if (var1_1 >= 0 || var7_7 > 32 && var7_7 != 44 && var7_7 != 47 && var8_8 < var12_12) break block39;
                        var1_1 = var9_9 < 1900 ? var9_9 : var9_9 - 1900;
                    } else if (var7_7 == 58) {
                        if (var4_4 < 0) {
                            var4_4 = (byte)var9_9;
                        } else {
                            if (var5_5 >= 0) break block39;
                            var5_5 = (byte)var9_9;
                        }
                    } else if (var7_7 == 47) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var9_9 - 1);
                        } else {
                            if (var3_3 >= 0) break block39;
                            var3_3 = (byte)var9_9;
                        }
                    } else {
                        if (var8_8 < var12_12 && var7_7 != 44 && var7_7 > 32 && var7_7 != 45) break block39;
                        if (var4_4 >= 0 && var5_5 < 0) {
                            var5_5 = (byte)var9_9;
                        } else if (var5_5 >= 0 && var6_6 < 0) {
                            var6_6 = (byte)var9_9;
                        } else {
                            if (var3_3 >= 0) break block39;
                            var3_3 = (byte)var9_9;
                        }
                    }
                    var11_11 = 0;
                    continue;
                }
                if (var7_7 == 47 || var7_7 == 58 || var7_7 == 43 || var7_7 == 45) {
                    var11_11 = var7_7;
                    continue;
                }
                var13_13 = var8_8 - 1;
                while (var8_8 < var12_12) {
                    var7_7 = var0.charAt(var8_8);
                    if (!(var7_7 >= 65 && var7_7 <= 90 || var7_7 >= 97 && var7_7 <= 122)) break;
                    ++var8_8;
                }
                if (var8_8 <= var13_13 + 1) break block39;
                var14_14 = Date.wtb.length;
                while (--var14_14 >= 0) {
                    if (!Date.wtb[var14_14].regionMatches(true, 0, var0, var13_13, var8_8 - var13_13)) continue;
                    var15_15 = Date.ttb[var14_14];
                    if (var15_15 == 0) break;
                    if (var15_15 == 1) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 >= 12) break;
                            var4_4 += 12;
                            break;
                        }
                        break block39;
                    }
                    if (var15_15 == 14) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 != 12) break;
                            var4_4 = 0;
                            break;
                        }
                        break block39;
                    }
                    if (var15_15 <= 13) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var15_15 - 2);
                            break;
                        }
                        break block39;
                    }
                    var10_10 = var15_15 - 10000;
                    break;
                }
                if (var14_14 >= 0) {
                    var11_11 = 0;
                    continue;
                }
                break block39;
            }
            if (var1_1 >= 0 && var2_2 >= 0 && var3_3 >= 0) {
                if (var6_6 < 0) {
                    var6_6 = 0;
                }
                if (var5_5 < 0) {
                    var5_5 = 0;
                }
                if (var4_4 < 0) {
                    var4_4 = 0;
                }
                if (var10_10 == -1) {
                    return new Date(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6).getTime();
                }
                return Date.UTC(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6) + (long)(var10_10 * 60000);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getYear() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(1) - 1900;
    }

    public void setYear(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(1, n + 1900);
        this.modified = true;
    }

    public int getMonth() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(2);
    }

    public void setMonth(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(2, n);
        this.modified = true;
    }

    public int getDate() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(5);
    }

    public void setDate(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(5, n);
        this.modified = true;
    }

    public int getDay() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(7) - 1;
    }

    public int getHours() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(11);
    }

    public void setHours(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(11, n);
        this.modified = true;
    }

    public int getMinutes() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(12);
    }

    public void setMinutes(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(12, n);
        this.modified = true;
    }

    public int getSeconds() {
        this.checkCal();
        this.checkModified();
        return this.cal.get(13);
    }

    public void setSeconds(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(13, n);
        this.modified = true;
    }

    public long getTime() {
        if (this.cal == null) {
            return this.fastTime;
        }
        this.checkModified();
        return this.cal.getTimeInMillis();
    }

    public void setTime(long l) {
        if (this.cal == null) {
            this.fastTime = l;
            this.modified = false;
            return;
        }
        this.cal.setTimeInMillis(l);
        this.cal.computeFields();
        this.modified = false;
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(this);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(this);
    }

    public String toGMTString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(this);
    }

    public int getTimezoneOffset() {
        this.checkCal();
        this.checkModified();
        TimeZone timeZone = this.cal.getTimeZone();
        int n = timeZone.getOffset(this.cal.get(0), this.cal.get(1), this.cal.get(2), this.cal.get(5), this.cal.get(7), this.cal.get(11) * this.cal.get(12) * this.cal.get(13) * 1000);
        return -(n / 1000 / 60);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTime());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        long l = objectInputStream.readLong();
        this.cal = new GregorianCalendar(TimeZone.getDefault());
        this.cal.setTimeInMillis(l);
        this.cal.computeFields();
        this.modified = false;
    }

    private void checkCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar(TimeZone.getDefault());
            this.cal.setTimeInMillis(this.fastTime);
            this.cal.computeFields();
            this.modified = false;
        }
    }

    private void checkModified() {
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
    }
}

