/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Utils;
import sun.rmi.transport.proxy.AsyncConnector;
import sun.rmi.transport.proxy.HttpAwareServerSocket;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = RMIMasterSocketFactory.getLogLevel();
    private static long connectTimeout = Utils.getLong("sun.rmi.transport.proxy.connectTimeout", 15000L);
    Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    private static int getLogLevel() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        return LogStream.parseLevel(Utils.getProperty("sun.rmi.transport.proxy.logLevel"));
    }

    public RMIMasterSocketFactory() {
        boolean bl = false;
        try {
            SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
            String string = System.getProperty("http.proxyHost");
            if (string == null) {
                string = System.getProperty("proxyHost");
            }
            SecurityManager.revertPrivilege();
            if (!Boolean.getBoolean("java.rmi.server.disableHttp") && string != null && string.length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket createSocket(String string, int n) throws IOException {
        IOException iOException;
        AsyncConnector asyncConnector;
        Socket socket;
        Socket socket2;
        RMISocketFactory rMISocketFactory;
        block50: {
            int n2;
            Throwable throwable2;
            block48: {
                if (logLevel >= 10) {
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: host: " + string + ", port: " + n);
                }
                System.getSecurityManager().checkConnect(string, n);
                rMISocketFactory = (RMISocketFactory)this.successTable.get(string);
                if (rMISocketFactory != null) {
                    if (logLevel < 10) return rMISocketFactory.createSocket(string, n);
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: previously successful factory found: " + rMISocketFactory);
                    return rMISocketFactory.createSocket(string, n);
                }
                socket2 = null;
                socket = null;
                asyncConnector = new AsyncConnector(this, this.initialFactory, string, n);
                iOException = null;
                try {
                    try {
                        Object object;
                        AsyncConnector asyncConnector2 = asyncConnector;
                        synchronized (asyncConnector2) {
                            object = RMIThread.newThread(asyncConnector, "AsyncConnector", true);
                            ((Thread)object).start();
                            try {
                                asyncConnector.wait(connectTimeout);
                            }
                            catch (InterruptedException interruptedException) {}
                            socket2 = this.checkConnector(asyncConnector);
                        }
                        if (socket2 == null) {
                            throw new NoRouteToHostException("connect timed out: " + string);
                        }
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection successful");
                        }
                        Socket socket3 = socket2;
                        Object var10_24 = null;
                        if (iOException == null) return socket3;
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                        }
                        int n3 = 0;
                        while (n3 < this.altFactoryList.size()) {
                            block46: {
                                Object object22;
                                rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n3);
                                try {
                                    if (logLevel >= 10) {
                                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                                    }
                                    object22 = rMISocketFactory.createSocket(string, n);
                                    object = ((Socket)object22).getInputStream();
                                    ((InputStream)object).read();
                                    ((Socket)object22).close();
                                }
                                catch (IOException object22) {
                                    if (logLevel >= 10) {
                                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object22);
                                    }
                                    break block46;
                                }
                                if (logLevel >= 10) {
                                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                                }
                                try {
                                    socket = rMISocketFactory.createSocket(string, n);
                                    return socket3;
                                }
                                catch (IOException iOException2) {
                                    return socket3;
                                }
                            }
                            ++n3;
                        }
                        return socket3;
                    }
                    catch (UnknownHostException unknownHostException) {
                        iOException = unknownHostException;
                    }
                    catch (NoRouteToHostException noRouteToHostException) {
                        iOException = noRouteToHostException;
                    }
                }
                catch (Throwable throwable2) {
                    Object var10_26 = null;
                    if (iOException == null) throw throwable2;
                    if (logLevel >= 10) {
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                    }
                    n2 = 0;
                    break block48;
                }
                Object var10_25 = null;
                if (iOException == null) break block50;
                if (logLevel >= 10) {
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                }
                int n4 = 0;
                while (n4 < this.altFactoryList.size()) {
                    block49: {
                        Object object3;
                        block52: {
                            rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n4);
                            try {}
                            catch (IOException object3) {
                                if (logLevel < 10) break block49;
                                LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object3);
                                break block49;
                            }
                            if (logLevel < 10) break block52;
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                        }
                        object3 = rMISocketFactory.createSocket(string, n);
                        InputStream inputStream = ((Socket)object3).getInputStream();
                        inputStream.read();
                        ((Socket)object3).close();
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                        }
                        try {}
                        catch (IOException iOException3) {}
                        socket = rMISocketFactory.createSocket(string, n);
                        break block50;
                    }
                    ++n4;
                }
                break block50;
            }
            while (true) {
                block51: {
                    Object object4;
                    block53: {
                        if (n2 >= this.altFactoryList.size()) {
                            throw throwable2;
                        }
                        rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n2);
                        try {}
                        catch (IOException object4) {
                            if (logLevel >= 10) {
                                LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object4);
                            }
                            break block51;
                        }
                        if (logLevel < 10) break block53;
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                    }
                    object4 = rMISocketFactory.createSocket(string, n);
                    InputStream inputStream = ((Socket)object4).getInputStream();
                    inputStream.read();
                    ((Socket)object4).close();
                    if (logLevel >= 10) {
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                    }
                    try {}
                    catch (IOException iOException4) {
                        throw throwable2;
                    }
                    socket = rMISocketFactory.createSocket(string, n);
                    throw throwable2;
                }
                ++n2;
            }
        }
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            try {
                AsyncConnector asyncConnector3 = asyncConnector;
                synchronized (asyncConnector3) {
                    socket2 = this.checkConnector(asyncConnector);
                }
                if (socket2 != null) {
                    if (socket == null) return socket2;
                    socket.close();
                    return socket2;
                }
                asyncConnector.notUsed();
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                iOException = noRouteToHostException;
            }
            if (socket == null) throw iOException;
            this.rememberFactory(string, rMISocketFactory);
            return socket;
        }
    }

    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
            return;
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        IOException iOException = asyncConnector.getException();
        if (iOException != null) {
            iOException.fillInStackTrace();
            throw iOException;
        }
        return asyncConnector.getSocket();
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new HttpAwareServerSocket(n);
    }
}

