/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResponse
implements JDAPProtocolOp {
    protected String m_object_name;
    protected BERElement m_element;
    protected LDAPAttribute[] m_attributes;

    public JDAPSearchResponse(BERElement bERElement) throws IOException {
        this.m_element = bERElement;
        BERTag bERTag = (BERTag)bERElement;
        BERSequence bERSequence = (BERSequence)bERTag.getValue();
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        byte[] byArray = null;
        byArray = bEROctetString.getValue();
        if (byArray == null) {
            this.m_object_name = null;
        } else {
            try {
                this.m_object_name = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        BERSequence bERSequence2 = (BERSequence)bERSequence.elementAt(1);
        if (bERSequence2.size() > 0) {
            this.m_attributes = new LDAPAttribute[bERSequence2.size()];
            int n = 0;
            while (n < bERSequence2.size()) {
                this.m_attributes[n] = new LDAPAttribute(bERSequence2.elementAt(n));
                ++n;
            }
        }
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String getObjectName() {
        return this.m_object_name;
    }

    public LDAPAttribute[] getAttributes() {
        return this.m_attributes;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        String string = "";
        if (this.m_attributes != null) {
            int n = 0;
            while (n < this.m_attributes.length) {
                if (n != 0) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + this.m_attributes[n].toString();
                ++n;
            }
        }
        return "SearchResponse {entry='" + this.m_object_name + "', attributes='" + string + "'}";
    }
}

