/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPAddRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    protected String m_dn;
    protected LDAPAttribute[] m_attrs;

    public JDAPAddRequest(String string, LDAPAttribute[] lDAPAttributeArray) {
        this.m_dn = string;
        this.m_attrs = lDAPAttributeArray;
    }

    public int getType() {
        return 8;
    }

    public void setBaseDN(String string) {
        this.m_dn = string;
    }

    public String getBaseDN() {
        return this.m_dn;
    }

    public BERElement getBERElement() {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BEROctetString(this.m_dn));
        BERSequence bERSequence2 = new BERSequence();
        int n = 0;
        while (n < this.m_attrs.length) {
            bERSequence2.addElement(this.m_attrs[n].getBERElement());
            ++n;
        }
        bERSequence.addElement(bERSequence2);
        BERTag bERTag = new BERTag(104, bERSequence, true);
        return bERTag;
    }

    public String getParamString() {
        String string = "";
        int n = 0;
        while (n < this.m_attrs.length) {
            if (n != 0) {
                string = String.valueOf(string) + " ";
            }
            string = String.valueOf(string) + this.m_attrs[n].toString();
            ++n;
        }
        return "{entry='" + this.m_dn + "', attrs='" + string + "'}";
    }

    public String toString() {
        return "AddRequest " + this.getParamString();
    }
}

