/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSyntaxSchemaElement;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 2482595821879862595L;
    public static final String EQUALITY = "EQUALITY";
    public static final String ORDERING = "ORDERING";
    public static final String SUBSTR = "SUBSTR";
    public static final String SINGLE = "SINGLE-VALUE";
    public static final String COLLECTIVE = "COLLECTIVE";
    public static final String NO_USER_MODIFICATION = "NO-USER-MODIFICATION";
    public static final String USAGE = "USAGE";
    static String[] NOVALS = new String[]{"SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION"};
    static final String[] MATCHING_RULES;
    static final String[] IGNOREVALS;
    protected LDAPSyntaxSchemaElement syntaxElement = new LDAPSyntaxSchemaElement();

    protected LDAPAttributeSchema() {
    }

    public LDAPAttributeSchema(String string, String string2, String string3, int n, boolean bl) {
        this(string, string2, string3, "1.3.6.1.4.1.1466.115.121.1.15", bl);
        this.syntaxElement.syntax = n;
        String string4 = LDAPSyntaxSchemaElement.internalSyntaxToString(n);
        if (string4 != null) {
            this.syntaxElement.syntaxString = string4;
        }
        this.setQualifier("SYNTAX", this.getSyntaxString());
    }

    public LDAPAttributeSchema(String string, String string2, String string3, String string4, boolean bl) {
        this(string, string2, string3, string4, bl, null, null);
    }

    public LDAPAttributeSchema(String string, String string2, String string3, String string4, boolean bl, String string5, String[] stringArray) {
        super(string, string2, string3, stringArray);
        this.attrName = "attributetypes";
        this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(string4);
        this.syntaxElement.syntaxString = string4;
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
        if (bl) {
            this.setQualifier(SINGLE, "");
        }
        if (string5 != null && string5.length() > 0) {
            this.setQualifier("SUP", string5);
        }
    }

    public LDAPAttributeSchema(String string) {
        this.attrName = "attributetypes";
        this.parseValue(string);
        String string2 = (String)this.properties.get("SYNTAX");
        if (string2 != null) {
            this.syntaxElement.syntaxString = string2;
            this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(string2);
        }
    }

    public boolean isSingleValued() {
        if (this.properties != null) {
            return this.properties.containsKey(SINGLE);
        }
        return false;
    }

    public String getSuperior() {
        String[] stringArray = this.getQualifier("SUP");
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public int getSyntax() {
        return this.syntaxElement.syntax;
    }

    public String getSyntaxString() {
        return this.syntaxElement.syntaxString;
    }

    String getValue(boolean bl) {
        String string = this.getValuePrefix();
        String string2 = this.getValue("SUP", false);
        if (string2.length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((string2 = this.getOptionalValues(MATCHING_RULES)).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((string2 = this.getValue("SYNTAX", bl)).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if (this.isSingleValued()) {
            string = String.valueOf(string) + SINGLE + ' ';
        }
        if ((string2 = this.getOptionalValues(NOVALS)).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((string2 = this.getOptionalValues(new String[]{USAGE})).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        string = String.valueOf(string) + this.syntaxElement.syntaxToString();
        string = String.valueOf(string) + "; Description: " + this.description + "; ";
        string = this.isSingleValued() ? String.valueOf(string) + "single-valued" : String.valueOf(string) + "multi-valued";
        string = String.valueOf(string) + this.getQualifierString(IGNOREVALS);
        string = String.valueOf(string) + this.getAliasString();
        return string;
    }

    static {
        int n = 0;
        while (n < NOVALS.length) {
            LDAPSchemaElement.novalsTable.put(NOVALS[n], NOVALS[n]);
            ++n;
        }
        MATCHING_RULES = new String[]{EQUALITY, ORDERING, SUBSTR};
        IGNOREVALS = new String[]{SINGLE, "OBSOLETE", "SUP", SINGLE, COLLECTIVE, NO_USER_MODIFICATION, "SYNTAX"};
    }
}

