/*
** RCS_ID = $Id: cntrycode.h,v 1.4 1996/06/25 13:05:57 stefan Exp $
**
** country codes for http-analyze
**
** Copyright 1996 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
** $Log: cntrycode.h,v $
** Revision 1.4  1996/06/25  13:05:57  stefan
** Now has separate counters for unresolved and unknown hostnames.
**
** Revision 1.3  1996/06/13  11:29:27  stefan
** Added RCS id.
**
** Revision 1.2  1996/05/25  01:45:27  stefan
** Added macros for conversion of shortval back into ISO two letter codes.
** Const-qualified appropriate parameters.
**
** Revision 1.1  1996/01/17  00:00:00  stefan
** Initial revision
**
**
*/

/*
 * ISO country codes.
 * Note: the first 11 elements are reserved for non-country domains.
 */
#define CC_OTHER	0
#define CC_UNRES	1
#define CC_NET		2
#define CC_USCOM	3
#define CC_USEDU	4
#define CC_USGOV	5
#define CC_INT		6
#define CC_USMIL	7
#define CC_USORG	8
#define CC_USARPA	9
#define CC_USNATO	10
#define CC_START	11

/* macros for conversion of two-letter codes */
#define CC_PAIR(cu,cl)	((u_short)((cu<<8)|(cl&0xFF)))
#define CC_LCHAR(cc)	((u_char)(cc>>8))
#define CC_RCHAR(cc)	((u_char)(cc&0xFF))

extern u_int addCountry(NLIST * const, NLIST ** const, size_t const);
extern void clearCountry(void);
COUNTRY *nextCountry(int const);

