/*
 * @(#)$Id: twtty.c,v 1.3 1994/04/21 12:18:29 shin Exp $
 *
 * - (1) Recording process, with ptty as communication channel
 * - (2) On-line code conversion for Taiwanese coding systems
 */

static char *rcsid =
	"@(#)$Id: twtty.c,v 1.3 1994/04/21 12:18:29 shin Exp $";

#include	<stdio.h>
#include	<sys/file.h>
#include	<sys/ioctl.h>
#include	<sys/wait.h>
#include	<signal.h>
#ifdef	SUN5
#include	<sys/types.h>		/* open() */
#include	<sys/stat.h>
#include	<fcntl.h>
#endif

#ifndef		FALSE
#define		FALSE	(0)
#define		TRUE	(!FALSE)
#endif

#define	L_PATH	256
#define	L_BUFF	1024

static char	LOGFSH[L_PATH];		/* log for working shell */
static char	LOGFPS[L_PATH];		/* rp -> shell */
static char	LOGFP1[L_PATH];		/* rp -> stdout */

int		LogStdin;
int		LogStdout;
int		LogShell;

void		tty_quit();

twtty(i_code, o_code, argc, argv, envp)
int	i_code;
int	o_code;
int	argc;
char	**argv;
char	**envp;
{
	int	master_fd, slave_fd, childpid, fd;
	int	statusp;	/* process status returned by wait() */
	FILE	*logfs;
	int	logfp1, logfps;
	char	buff[L_BUFF];

/* reserved for output logs */

	if ( !isatty(0) || !isatty(1) )
		err_quit("stdin and stdout must be a terminal");

	set_log_flags();

	if ( LogStdout ) {
		sprintf(LOGFP1,"%s.%d", "/tmp/belog.p1", getpid());
		if ( (logfp1 = open(LOGFP1, (O_CREAT|O_WRONLY), 0644)) < 0 )
			err_quit("cannot open log file for betty -> stdout");
	}

	if ( LogStdin ) {
		sprintf(LOGFPS,"%s.%d", "/tmp/belog.p0", getpid());
		if ( (logfps = open(LOGFPS, (O_CREAT|O_WRONLY), 0644)) < 0 )
			err_quit("cannot open log file for betty -> shell");
	}

	master_fd = pty_master();
	if ( master_fd < 0)
		err_sys("can't open master pty");

	if ( LogStdin ) {
		sprintf(buff, "master_fd: %d\n", master_fd);
		write(logfps, buff, strlen(buff));
	}

	if (tty_getmode(0) <0)
		err_sys("can't get tty mode of stdin");

#ifndef	SUN5
	(void) signal(SIGCHLD, tty_quit);
#endif

	if ( (childpid = fork()) < 0 ) {
		err_sys("can't fork");
	}
	else if (childpid == 0) {	/* child */

		if ( LogShell ) {
			sprintf(LOGFSH,"%s.%d", "/tmp/belog.sh", getppid());
			if ( (logfs = fopen(LOGFSH,"w")) == NULL )
				err_quit("can not open log file for shell");
			fprintf(logfs, "parentpid: %d\n", getppid());
		}

#ifndef	SVR4
		/* disassociate from control terminal */
		if ((fd=open("/dev/tty", O_RDWR)) >=0) {
			if (ioctl(fd, TIOCNOTTY, (char *) 0) < 0)
				err_sys("ioctl TIOCNOTTY error");
			close(fd);
		}
#else /* SVR4 */
		setpgrp();
#endif /* !SVR4 */

		slave_fd = pty_slave(master_fd);
		if (slave_fd < 0)
			err_sys("can't open pty slave");
#ifdef POSIX
		/*
		 * need to attach to CTTY explicitly
		 * in POSIX-compliant systems
		 */
		setsid();
		ioctl(slave_fd, TIOCSCTTY, 0);
		/*
		setpgid(0,0);
		*/
#endif

		close(master_fd);

		if (tty_setmode(slave_fd) < 0)
			err_sys("can't set tty mode of pty slave");

		printf("Let's go ...\r\n");
		exec_shell(slave_fd, logfs, argc, argv, envp);
		exit(1);	/* ?? */
	}

	if ( LogStdin ) {
		sprintf(buff, "childpid: %d\n", childpid);
		write(logfps, buff, strlen(buff));
		sprintf(buff, "pass_all begin\n");
		write(logfps, buff, strlen(buff));
	}

	if (tty_raw(0) < 0)
		err_sys("tty_raw error");

	pass_all(i_code, o_code, master_fd, childpid, logfp1, logfps);

	if (tty_reset(0) <0)
		err_sys("tty_reset error");

#ifdef	SVR4
	wait(&statusp);
#else	/* !SVR4 */
	wait3(&statusp,(WNOHANG|WUNTRACED),NULL);
#endif	/* SVR4 */

	if ( LogStdin ) {
		sprintf(buff, "wait(): %08x\n", statusp);
		write(logfps, buff, strlen(buff));
	}
	printf("\nBeTTY ... done\n");

	exit(0);
} /* main */

void tty_quit()
{
	if (tty_reset(0) <0)
		err_sys("tty_reset error");
	exit(0);
}

set_log_flags()
{
	char	*envr;
	char	*getenv();

	LogStdin  = FALSE;
	LogStdout = FALSE;
	LogShell  = FALSE;

	if ( (envr=getenv("LOGSTDIN")) != NULL && !strcmp(envr,"TRUE") )
		LogStdin = TRUE;
	if ( (envr=getenv("LOGSTDOUT")) != NULL && !strcmp(envr,"TRUE") )
		LogStdout = TRUE;
	if ( (envr=getenv("LOGSHELL")) != NULL && !strcmp(envr,"TRUE") )
		LogShell = TRUE;
}

/*
 * History:
 *
 * $Log: twtty.c,v $
 * Revision 1.3  1994/04/21  12:18:29  shin
 * 1. include tty_quit() to catch SIGCHLD signal so that terminal mode
 * 	is restored to its normal state upon exit.
 * 2. increase buff[] size to 1024
 * 3. no more compiled as main()
 * 4. remove some statements that had already been commented out
 * 5. log files now moved to /tmp instead of .
 * 6. rplog.ps.pid now changed to /tmp/rplog.p0.pid
 * 7. pass 'argc' to exec_shell as an extra parameter
 * 8. exit(0) -> exit(1) if exec_shell fail
 * 9. try wait3() instead of wait()
 *
 * Revision 1.2  1994/03/19  19:35:26  shin
 * 1. log files are controlled with their own #defines: LOGF_SH,
 * 	LOGF_P1, LOGF_PS
 * 2. add a wait() statement in parent process.
 *
 * Revision 1.1  1994/03/16  17:24:00  shin
 * Initial revision
 */
