case $CONFIG in
    '') . ./config.sh ;;
esac
echo "Extracting Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 3.0 1992/03/01 02:13:32 davison Trn $
#
# This software is Copyright 1991 by Stan Barber. 
#
# Permission is hereby granted to copy, reproduce, redistribute or otherwise
# use this software as long as: there is no monetary profit gained
# specifically from the use or reproduction of this software, it is not
# sold, rented, traded or otherwise marketed, and this copyright notice is
# included prominently in any copy made. 
#
# The author make no claims as to the fitness or correctness of this software
# for any use whatsoever, and it is provided as is. Any use of this software
# is at the user's own risk. 
# 
# optional defines you can add to the CFLAGS
#    -DNO_INN_SUPPORT             avoids the MODE READER attempt
#    -DNO_LISTGROUP               avoids attempting to use LISTGROUP
#    -DREPLYTO_POSTER_CHECKING    makes -p also check Reply-To (slow)

CC = $cc
rnbin = $installbin
rnlib = $installprivlib
mansrc = $installmansrc
manext = $manext
CFLAGS = $optimize $ccflags
LDFLAGS = $ldflags
#NNTPNNTPFLAGS = $nntpflags
ndirc = $ndirc
ndiro = $ndiro
strftimec = $strftimec
strftimeo = $strftimeo
filexp = $filexp

libs = $libndir $termlib $jobslib -lm $libs
!GROK!THIS!
$cat >>Makefile <<'!NO!SUBS!'
public = strn newsetup newsgroups Pnews Rnmail
private = norm.saver mbox.saver makedir Pnews.header Speller artcheck $(nntp)
util = makedepend newsnews
strnmanpages = strn.1
manpages = trn.1 Pnews.1 Rnmail.1 newsetup.1 newsgroups.1 $(strnmanpages)

#NNTPnntp=getactive
#NNTPnntpsrc=nntpinit.c nntpclient.c nntp.c
#NNTPnntpobj=nntpinit.o nntpclient.o nntp.o

h1 = addng.h art.h artio.h artsrch.h autosub.h backpage.h bits.h cache.h 
h2 = common.h decode.h final.h hash.h head.h help.h init.h
h3 = intrp.h kfile.h last.h ng.h ngdata.h ngsrch.h ngstuff.h only.h rcln.h
h4 = rcstuff.h respond.h rthread.h rt-mt.h rt-select.h search.h sw.h
h5 = term.h trn.h util.h filtpipe.h
h6a = scan.h scmd.h sdisp.h smisc.h sorder.h spage.h
h6b = scanart.h samain.h samisc.h sadisp.h sacmd.h sadesc.h sathread.h
h6c = sgroup.h sgcmd.h sgdata.h sgfile.h sgmisc.h
h6d = shelp.h shcmd.h shdata.h shfile.h shmisc.h
h6e = svirt.h svcmd.h svdata.h svmisc.h svfile.h svonline.h
h6f = sconfig.h
h6g = url.h
h6all = $(h6a) $(h6b) $(h6c) $(h6d) $(h6e) $(h6f) $(h6g)
h7 = score.h scorefile.h scoresave.h score-easy.h

h = $(h1) $(h2) $(h3) $(h4) $(h5) $(h6all) $(h7)

c1 = addng.c art.c artio.c artsrch.c autosub.c backpage.c bits.c cache.c
c2 = decode.c edit_dist.c final.c hash.c head.c help.c init.c intrp.c
c3 = kfile.c last.c $(ndirc) ng.c ngdata.c nghash.c ngsrch.c ngstuff.c
c4 = only.c rcln.c rcstuff.c respond.c rthread.c rt-mt.c rt-ov.c
c5 = rt-process.c rt-page.c rt-select.c rt-util.c rt-wumpus.c search.c
c6 = $(strftimec) sw.c term.c trn.c util.c unship.c uudecode.c
c7 = $(nntpsrc) filtpipe.c
c8a = scan.c scmd.c sdisp.c smisc.c sorder.c spage.c
c8b = scanart.c samain.c samisc.c sadisp.c sacmd.c sadesc.c sathread.c
c8c = sgroup.c sgcmd.c sgdata.c sgfile.c sgmisc.c
c8d = shelp.c shcmd.c shdata.c shfile.c shmisc.c
c8e = svirt.c svcmd.c svdata.c svmisc.c svfile.c svonline.c
c8f = sconfig.c
c8g = url.c
c8all = $(c8a) $(c8b) $(c8c) $(c8d) $(c8e) $(c8f) $(c8g)
c9 = score.c scorefile.c scoresave.c score-easy.c

c = $(c1) $(c2) $(c3) $(c4) $(c5) $(c6) $(c7) $(c8all) $(c9)

obj1 = addng.o art.o artio.o artsrch.o autosub.o backpage.o bits.o cache.o
obj2 = decode.o edit_dist.o final.o hash.o head.o help.o init.o intrp.o
obj3 = kfile.o last.o $(ndiro) ng.o ngdata.o nghash.o ngsrch.o ngstuff.o
obj4 = only.o rcln.o rcstuff.o respond.o rthread.o rt-mt.o rt-ov.o
obj5 = rt-process.o rt-page.o rt-select.o rt-util.o rt-wumpus.o search.o
obj6 = $(strftimeo) sw.o term.o trn.o util.o unship.o uudecode.o parsedate.o
obj7 = $(nntpobj) filtpipe.o
obj8a = scan.o scmd.o sdisp.o smisc.o sorder.o spage.o
obj8b = scanart.o samain.o samisc.o sadisp.o sacmd.o sadesc.o sathread.o
obj8c = sgroup.o sgcmd.o sgdata.o sgfile.o sgmisc.o
obj8d = shelp.o shcmd.o shdata.o shfile.o shmisc.o
obj8e = svirt.o svcmd.o svdata.o svmisc.o svfile.o svonline.o
obj8f = sconfig.o
obj8g = url.o
obj8all = $(obj8a) $(obj8b) $(obj8c) $(obj8d) $(obj8e) $(obj8f) $(obj8g)
obj9 = score.o scorefile.o scoresave.o score-easy.o

obj = $(obj1) $(obj2) $(obj3) $(obj4) $(obj5) $(obj6) $(obj7) $(obj8all) $(obj9)

lintflags = -phbvxac

addedbymake = $(public) $(private) $(util) $(nntp) Makefile.old config.h\
	cppstdin all

# grrr
SHELL = /bin/sh

.c.o:
	$(CC) -c $(CFLAGS) $*.c

all: $(public) $(private) $(util) Makefile
	touch all

strn: $(obj)
	$(CC) $(LDFLAGS) $(obj) $(libs) -o strn
#NNTP
#NNTPnntpinit.o:
#NNTP	$(CC) -c $(CFLAGS) $(NNTPFLAGS) $*.c
#NNTP
#NNTPgetactive: getactive.o nntpinit.o nntpclient.o
#NNTP	$(CC) $(LDFLAGS) getactive.o nntpinit.o nntpclient.o -o getactive $(libs)

artcheck: artcheck.o
	$(CC) $(LDFLAGS) artcheck.o -o artcheck $(libs)

parsedate.o: parsedate.y
	@echo 'Expect 6 shift/reduce conflicts'
	yacc parsedate.y
	mv -f y.tab.c parsedate.c
	$(CC) -c $(CFLAGS) parsedate.c
	rm -f parsedate.c
#STRFTIME
#STRFTIME$(strftimeo): $(strftimec)
#STRFTIME	$(CC) -c $(CFLAGS) $(strftimec)

unipatch: unipatch.o
	$(CC) $(LDFLAGS) unipatch.o -o unipatch

# if a .h file depends on another .h file...
$(h):
	-touch $@

install.full: $(public) $(private) $(manpages) default_topic
# won't work with csh
	export PATH || exit 1
	- (cd `./filexp $(rnbin)`; mv strn strn.old)
	- if test `pwd` != `./filexp $(rnbin)`; then cp $(public) `./filexp $(rnbin)`; fi
	- if test $(filexp) = Rnfilexp; then cp ./filexp `./filexp $(rnbin)/Rnfilexp`; fi
	- ./makedir `./filexp $(rnlib)`
	- if test `pwd` != `./filexp $(rnlib)`; then cp INIT filexp $(private) `./filexp $(rnlib)`; fi
#NNTP	- if test `pwd` != `./filexp $(rnlib)`; then strip `./filexp $(rnlib)`/getactive ; fi
	- if test -f `./filexp $(rnlib)/newsnews.strn`; then mv `./filexp $(rnlib)/newsnews.strn` `./filexp $(rnlib)/strnnews.old`; fi
	- if test ! -f `./filexp $(rnlib)/newsnews.strn`; then cp newsnews `./filexp $(rnlib)/newsnews.strn`; fi
	- if test -f `./filexp $(rnlib)/default_topic`; then mv `./filexp $(rnlib)/default_topic` `./filexp $(rnlib)/default.old`; fi
	- if test ! -f `./filexp $(rnlib)/default_topic`; then cp default_topic `./filexp $(rnlib)`; fi
	- if test -f `./filexp $(rnlib)/hier_groups`; then mv `./filexp $(rnlib)/hier_groups` `./filexp $(rnlib)/hier.old`; fi
	- if test ! -f `./filexp $(rnlib)/hier_groups`; then cp hier_groups `./filexp $(rnlib)`; fi
	- if test "X$(mansrc)" != "X" -a "X`pwd`" != X`./filexp $(mansrc)`; then \
for page in $(manpages); do \
dest=$(mansrc)/`basename $$page .1`.$(manext); \
rm -f $$dest; cp $$page $$dest; chmod 444 $$dest; \
done; \
fi
	@echo '(Remember to make install.help if the help files have changed.)'

install.strn: strn newsnews.strn default_topic
# won't work with csh
	export PATH || exit 1
	- (cd `./filexp $(rnbin)`; mv strn strn.old)
	- if test `pwd` != `./filexp $(rnbin)`; then cp strn `./filexp $(rnbin)`; fi
	- if test -f `./filexp $(rnlib)/newsnews.strn`; then mv `./filexp $(rnlib)/newsnews.strn` `./filexp $(rnlib)/strnnews.old`; fi
	- if test ! -f `./filexp $(rnlib)/newsnews.strn`; then cp newsnews `./filexp $(rnlib)/newsnews.strn`; fi
	- if test -f `./filexp $(rnlib)/default_topic`; then mv `./filexp $(rnlib)/default_topic` `./filexp $(rnlib)/default.old`; fi
	- if test ! -f `./filexp $(rnlib)/default_topic`; then cp default_topic `./filexp $(rnlib)`; fi
	- if test -f `./filexp $(rnlib)/hier_groups`; then mv `./filexp $(rnlib)/hier_groups` `./filexp $(rnlib)/hier.old`; fi
	- if test ! -f `./filexp $(rnlib)/hier_groups`; then cp hier_groups `./filexp $(rnlib)`; fi
	- if test "X$(mansrc)" != "X" -a "X`pwd`" != X`./filexp $(mansrc)`; then \
for page in $(strnmanpages); do \
dest=$(mansrc)/`basename $$page .1`.$(manext); \
rm -f $$dest; cp $$page $$dest; chmod 444 $$dest; \
done; \
fi
	@echo '(Remember to make install.help if the help files have changed.)'

install.help:
	@echo 'Installing strn help files.'
	@echo 'The old help files will be placed in help.old'
	export PATH || exit 1
	- (cd `./filexp $(rnlib)`; rm -rf help.old; mv help help.old)
	- if test `pwd` != `./filexp $(rnlib)`; then cp -r help `./filexp $(rnlib)`; fi

install:
	@echo 'Use "make install.full" to install everything except the help files.'
	@echo 'Use "make install.strn" to install only the new strn files.'
	@echo '(install.strn assumes that trn 3.4.1 is pre-installed, and that'
	@echo ' the private library directory is shared between trn and strn.

	@echo ' It does not install the help files.)'
	@echo 'Use "make install.help" to install the strn help files.'

clean:
	@echo 'Use "make realclean" to also remove the Makefile.'
	@echo 'Use "make spotless" to even remove config.sh.'
	rm -rf UU
	rm -f *.o core $(addedbymake)

realclean:
	@echo 'You can use "Configure -S ; make depend ; make" to reverse this.'
	rm -rf UU
	rm -f *.o core $(addedbymake) Makefile

spotless:
	rm -rf UU .config
	rm -f *.o core $(addedbymake) Makefile filexp config.sh

# The following lint has practically everything turned on.  Unfortunately,
# you have to wade through a lot of mumbo jumbo that can't be suppressed.
# If the source file has a /*NOSTRICT*/ somewhere, ignore the lint message
# for that spot.

lint: lint_trn

lint_trn:
	lint $(lintflags) $(defs) $(c) > trn.fuzz

sabertrn: $(c)
	#load $(c) $(libs)

depend: config.h Makefile makedepend
	./makedepend

# AUTOMATICALLY GENERATED MAKE DEPENDENCIES--PUT NOTHING BELOW THIS LINE
!NO!SUBS!
$cat dependencies >>Makefile
case "$d_nntp" in
define)	sed < Makefile -e '/^#NNTP/s/^#NNTP//' > Makefile.new ;;
*)	sed < Makefile -e '/^#NNTP/d' > Makefile.new ;;
esac
case "$strftimec" in
''|' ')	sed < Makefile.new -e '/^#STRFTIME/d' > Makefile ;;
*)	sed < Makefile.new -e '/^#STRFTIME/s/^#STRFTIME//' > Makefile ;;
esac
rm Makefile.new
$eunicefix Makefile
