#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "strerr.h"
#include "stralloc.h"
#include "str.h"
#include "byte.h"
#include "sig.h"
#include "fd.h"
#include "ip.h"
#include "ipalloc.h"
#include "case.h"
#include "sgetopt.h"
#include "exit.h"
#include "scan.h"
#include "fmt.h"
#include "env.h"
#include "dns.h"
#include "remoteinfo.h"

#define FATAL "tcpclient: fatal: "
#define CONNECT "tcpclient: unable to connect to "

int verbosity = 1;

void die2(s,t) char *s; char *t;
{
  if (verbosity) strerr_warn3(FATAL,s,t,0);
  _exit(111);
}
void diesys(s) char *s;
{
  if (verbosity) strerr_warn2(FATAL,s,&strerr_sys);
  _exit(111);
}
void nomem()
{
  if (verbosity) strerr_warn2(FATAL,"out of memory",0);
  _exit(111);
}
void usage()
{
  strerr_die1x(100,"tcpclient: usage: tcpclient \
[ -hHrRdDqQv ] \
[ -i localip ] \
[ -p localport ] \
[ -T timeoutconn ] \
[ -l localname ] \
[ -t timeoutinfo ] \
host port program");
}

char temp[IPFMT + FMT_ULONG];

int flagdelay = 1;
int flagremoteinfo = 1;
int flagremotehost = 1;
char *forcelocal = 0;
unsigned long timeout = 26;
unsigned long timeout2 = 60;

stralloc tmp = {0};
ipalloc ia = {0};

struct sockaddr_in salocal;
struct ip_address iplocal;
unsigned long portlocal;
struct sockaddr_in saremote;
struct ip_address ipremote;
unsigned long portremote;
char strport[FMT_ULONG];

void main(argc,argv)
int argc;
char **argv;
{
  int s;
  int dummy;
  int opt;
  char *hostname;
  char *portname;
  struct servent *se;
  int j;
 
  byte_zero(&salocal,sizeof(salocal));
  salocal.sin_family = AF_INET;
  salocal.sin_addr.s_addr = INADDR_ANY;
  salocal.sin_port = 0;

  while ((opt = getopt(argc,argv,"dDvqQhHrRi:p:t:T:l:")) != opteof)
    switch(opt) {
      case 'd': flagdelay = 1; break;
      case 'D': flagdelay = 0; break;
      case 'v': verbosity = 2; break;
      case 'q': verbosity = 0; break;
      case 'Q': verbosity = 1; break;
      case 'l': forcelocal = optarg; break;
      case 'H': flagremotehost = 0; break;
      case 'h': flagremotehost = 1; break;
      case 'R': flagremoteinfo = 0; break;
      case 'r': flagremoteinfo = 1; break;
      case 't': scan_ulong(optarg,&timeout); break;
      case 'T': scan_ulong(optarg,&timeout2); break;
      case 'i':
	if (ip_scan(optarg,&iplocal)) byte_copy(&salocal.sin_addr,4,&iplocal);
	break;
      case 'p':
	scan_ulong(optarg,&portlocal);
        salocal.sin_port = htons((unsigned short) portlocal);
	break;
      default: usage();
    }
  argc -= optind;
  argv += optind;
 
  hostname = *argv++;
  if (!hostname) usage();
  portname = *argv++;
  if (!portname) usage();
  if (!*argv) usage();
 
  close(6);
  close(7);
  sig_pipeignore();
  
  dns_init(1);
 
  byte_zero(&saremote,sizeof(saremote));
  saremote.sin_family = AF_INET;

  if (!portname[scan_ulong(portname,&portremote)])
    ;
  else {
    se = getservbyname(portname,"tcp");
    if (!se) die2("unable to figure out port number for ",portname);
    portremote = ntohs(se->s_port);
    /* i continue to be amazed at the stupidity of the s_port interface */
  }
  strport[fmt_ulong(strport,portremote)] = 0;
 
  if (str_equal(hostname,"")) hostname = "127.0.0.1";
  if (str_equal(hostname,"0")) hostname = "127.0.0.1";
 
  if (!hostname[ip_scan(hostname,&ipremote)]) {
    s = socket(AF_INET,SOCK_STREAM,0);
    if (s == -1)
      diesys("unable to create socket: ");
    if (bind(s,(struct sockaddr *) &salocal,sizeof(salocal)) == -1)
      diesys("unable to bind: ");
    if (timeoutconn(s,&ipremote,portremote,(int) timeout2) == -1) {
      temp[ip_fmt(temp,&ipremote)] = 0;
      if (verbosity) strerr_warn5(CONNECT,temp," port ",strport,": ",&strerr_sys);
      _exit(111);
    }
  }
  else {
    if (!stralloc_copys(&tmp,hostname)) nomem();
    switch(dns_ip(&ia,&tmp)) {
      case DNS_SOFT:
	die2("temporarily unable to figure out IP address for ",hostname);
      case DNS_HARD:
	die2("unable to figure out IP address for ",hostname);
      case DNS_MEM: nomem();
    }
    if (ia.len == 0)
      die2("no IP addresses for ",hostname);
    for (j = 0;j < ia.len;++j) {
      s = socket(AF_INET,SOCK_STREAM,0);
      if (s == -1)
        diesys("unable to create socket: ");
      if (bind(s,(struct sockaddr *) &salocal,sizeof(salocal)) == -1)
        diesys("unable to bind: ");
      byte_copy(&ipremote,4,&ia.ix[j].ip);
      if (timeoutconn(s,&ipremote,portremote,(int) timeout2) == 0) break;
      temp[ip_fmt(temp,&ipremote)] = 0;
      if (verbosity) strerr_warn5(CONNECT,temp," port ",strport,": ",&strerr_sys);
      close(s);
    }
    if (j == ia.len) _exit(111);
  }
 
  if (!flagdelay) {
    int opt = 1;
    setsockopt(s,IPPROTO_TCP,1,&opt,sizeof(opt)); /* 1 == TCP_NODELAY */
    /* if it fails, bummer */
  }
 
  if (!env_init()) nomem();
  if (!env_put("PROTO=TCP")) nomem();
  if (!env_unset("TCPLOCALHOST")) nomem();
  if (!env_unset("TCPREMOTEHOST")) nomem();
  if (!env_unset("TCPREMOTEINFO")) nomem();
 
  dummy = sizeof(salocal);
  if (getsockname(s,(struct sockaddr *) &salocal,&dummy) == -1)
    diesys("unable to get local address: ");
  portlocal = ntohs(salocal.sin_port);
  byte_copy(&iplocal,4,&salocal.sin_addr);
 
  temp[fmt_ulong(temp,portlocal)] = 0;
  if (!env_put2("TCPLOCALPORT",temp)) nomem();
  temp[ip_fmt(temp,&iplocal)] = 0;
  if (!env_put2("TCPLOCALIP",temp)) nomem();
  if (forcelocal) {
    if (!env_put2("TCPLOCALHOST",forcelocal)) nomem();
  }
  else
    switch(dns_ptr(&tmp,&iplocal)) {
      case DNS_MEM: nomem();
      case 0:
        if (!stralloc_0(&tmp)) nomem();
        case_lowers(tmp.s);
        if (!env_put2("TCPLOCALHOST",tmp.s)) nomem();
    }
 
  dummy = sizeof(saremote);
  if (getpeername(s,(struct sockaddr *) &saremote,&dummy) == -1)
    diesys("unable to get remote address: ");
  byte_copy(&ipremote,4,&saremote.sin_addr);
 
  temp[ip_fmt(temp,&ipremote)] = 0;
  if (!env_put2("TCPREMOTEIP",temp)) nomem();
  if (verbosity >= 2) strerr_warn4("tcpclient: connected to ",temp," port ",strport,0);
 
  if (!env_put2("TCPREMOTEPORT",strport)) nomem();
  if (flagremotehost)
    switch(dns_ptr(&tmp,&ipremote)) {
      case DNS_MEM: nomem();
      case 0:
        if (!stralloc_0(&tmp)) nomem();
        case_lowers(tmp.s);
        if (!env_put2("TCPREMOTEHOST",tmp.s)) nomem();
    }
  if (flagremoteinfo) {
    char *rinfo;
    rinfo = remoteinfo_get(&ipremote,portremote,&iplocal,portlocal,(int) timeout);
    if (rinfo)
      if (!env_put2("TCPREMOTEINFO",rinfo)) nomem();
  }
 
  if (fd_move(6,s) == -1) diesys("unable to set up descriptor 6: ");
  if (fd_copy(7,6) == -1) diesys("unable to set up descriptor 7: ");
  sig_pipedefault();
 
  execvp(*argv,argv);
  if (verbosity) strerr_warn4(FATAL,"unable to run ",*argv,": ",&strerr_sys);
  _exit(111);
}
