.TH "TK_EvalStr" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_EvalStr - Evaluate a string whithin the  tcl/tk interpreter
.sp
Author: Bertrand Guiheneuf
.sp
This routine allows to evaluate tcl/tk  instructions with the tcl/tk interpreter launched with scilab. 
.sp
.sp
.SH Usage
TK_EvalStr(str)
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBstr\fP : string character
Contains the string to evaluate within tcl/tk
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
None
.SH Description
When tcl/tk support is enabled in scilab, you can evaluate tcl/tk expression
from scilab interpreter. In fact, scilab launches a slave tcl/tk interpreter.
The scilab instruction \fBTK_EvalStr()\fP can be used to evaluate expression 
without having to write a tcl/tk in a separated file (this is done using 
TK_EvalFile). 
.SH EXAMPLE
.nf
TK_EvalStr('toplevel .foo');
// creates a toplevel TK window. 
TK_EvalStr('label .foo.l -text ""TK married Scilab !!!""');
// create a static label
TK_EvalStr('pack .foo.l');
// pack the label widget. It appears on the screen.
text='button .foo.b -text close -command {destroy .foo}';
TK_EvalStr(text);
TK_EvalStr('pack .foo.b');
.fi 
.ec
.ft P
.sp
.SH See also
ScilabEval, TK_EvalFile, TK_GetVar, TK_Setvar
