.TH cheb2mag 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cheb2mag - response of type 2 Chebyshev filter
.SH CALLING SEQUENCE
.nf
[h2]=cheb2mag(n,omegar,A,sample)
.fi
.SH PARAMETERS
.TP 10
n
: integer ; filter order 
.TP
omegar
: real scalar : cut-off frequency
.TP
A
: attenuation in stop band
.TP
sample
: vector of frequencies where cheb2mag is evaluated
.TP
h2
: vector of Chebyshev II filter values at sample points
.SH DESCRIPTION
Square magnitude response of a type 2 Chebyshev filter.
.LP
\fVomegar\fR = stopband edge, \fVsample\fR = vector of 
frequencies where the square magnitude \fVh2\fR is desired.
.SH EXAMPLE
.nf
//Chebyshev; ripple in the stopband
n=10;omegar=6;A=1/0.2;sample=0.0001:0.05:10;
h2=cheb2mag(n,omegar,A,sample);
plot(sample,log(h2)/log(10),'frequencies','magnitude in dB')
//Plotting of frequency edges
minval=(-maxi(-log(h2)))/log(10);
plot2d([omegar;omegar],[minval;0],[2],"000");
//Computation of the attenuation in dB at the stopband edge
attenuation=-log(A*A)/log(10);
plot2d(sample',attenuation*ones(sample)',[5],"000")
.fi
.SH SEE ALSO
cheb1mag

