.TH hrmt 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
hrmt - gcd of polynomials
.SH CALLING SEQUENCE
.nf
[pg,U]=hrmt(v)
.fi
.SH PARAMETERS
.TP
v
: row of polynomials i.e. \fV1\fRx\fVk\fR polynomial matrix
.TP
pg
: polynomial
.TP
U
: unimodular matrix polynomial
.SH DESCRIPTION
.Vb [pg,U]=hrmt(v)
returns a unimodular matrix \fVU\fR and  \fVpg\fR = gcd of row of 
polynomials \fVv\fR such that \fVv*U = [pg,0]\fR.
.SH EXAMPLE
.nf
x=poly(0,'x');
v=[x*(x+1),x^2*(x+1),(x-2)*(x+1),(3*x^2+2)*(x+1)];
[pg,U]=hrmt(v);U=clean(U)
det(U)
.fi
.SH SEE ALSO
gcd, htrianr

