.TH int3d G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
int3d - definite 3D integral by quadrature and cubature method
.SH CALLING SEQUENCE
.nf
[result,err]=int3d(X,Y,Z,f [,nf[,params]])
.fi
.SH PARAMETERS
.TP 10
X 
: a 4 by \fVNUMTET\fR array containing the abscissae of the vertices
  of the \fVNUMTET\fR tetrahedrons.
.TP 10
Y 
: a 4 by \fVNUMTET\fR array containing the ordinates of the vertices
  of the \fVNUMTET\fR tetrahedrons.
.TP
Z 
: a 4 by \fVNUMTET\fR array containing the third coordinates of the vertices
  of the \fVNUMTET\fR tetrahedrons.
.TP
f
: external (function or list or string) defining the integrand
\fVf(xyz,nf)\fR, where \fVxyz\fR is the vector of a point coordinates
and nf the number functions
.TP
nf
: the number of function to integate (default is 1)
.TP
params
: real vector \fV[minpts, maxpts, epsabs, epsrel]\fR. default
value is \fV[0, 1000, 0.0, 1.d-5]\fR.
.RS
.TP
epsabs
: Desired bound on the absolute error.  
.TP
epsrel
: Desired bound on the relative error.  
.TP
minpts
: Minimum number of function evaluations.
.TP
maxpts 
: Maximum number of function evaluations.  The number of
function evaluations over each subregion is 43
.RE
.TP
result
: the integral value,or vector of the integral values.
.TP
err
: Estimates of absolute errors.

.SH DESCRIPTION

The function calculates an approximation to a given
vector of definite integrals
.nf
I  I  I (F ,F ,...,F )      dx(3)dx(2)dx(1),
          1  2      numfun
.fi
where the region of integration is a collection of
NUMTET tetrahedrons and where 
.nf
F = F (X(1),X(2),X(3)), J = 1,2,...,NUMFUN.
 J   J
.fi

A globally adaptive strategy is applied in order to
compute approximations \fVresult(k)\fR
hopefully satisfying, for each component of I, the
following claim for accuracy:
\fVABS(I(K)-RESULT(K))<=MAX(EPSABS,EPSREL*ABS(I(K)))\fR


\fVint3d\fR repeatedly subdivides the tetrahedrons with greatest
estimated errors and estimates the integrals and the errors over the
new subtetrahedrons until the error request is met or \fVMAXPTS\fR
function evaluations have been used.

A 43 point integration rule with all evaluation points inside the
tetrahedron is applied. The rule has polynomial degree 8.

If the values of the input parameters \fVEPSABS\fR or \fVEPSREL\fR are
selected great enough, an integration rule is applied over each
tetrahedron and the results are added up to give the approximations
\fVRESULT(K)\fR. No further subdivision of the tetrahedrons will then
be applied.

When \fVint3d\fR computes estimates to a vector of
integrals, all components of the vector are given
the same treatment. That is, \fVI(Fj)\fR and \fVI(Fk)\fR for

\fVj\fR not equal to \fVk\fR, are estimated with the same
subdivision of the region of integration.
For integrals with enough similarity, we may save
time by applying \fVint3d\fR to all integrands in one call.
For integrals that varies continuously as functions of
some parameter, the estimates produced by \fVint3d\fR  will
also vary continuously when the same subdivision is
applied to all components. This will generally not be
the case when the different components are given
separate treatment.

On the other hand this feature should be used with
caution when the different components of the integrals
require clearly different subdivisions.

.SH EXAMPLES
.nf
X=[0;1;0;0];
Y=[0;0;1;0];
Z=[0;0;0;1];
deff('v=f(xyz,numfun)','v=exp(xyz''*xyz)')
[RESULT,ERROR]=int3d(X,Y,Z,'int3dex')
// computes the integrand exp(x*x+y*y+z*z) over the 
//tetrahedron (0.,0.,0.),(1.,0.,0.),(0.,1.,0.),(0.,0.,1.)
.fi
.SH SEE ALSO
intc, intl, int3d
.SH REFERENCES
Fortran routine dqtet.f
.LP
Authors: 
.nf
Jarle Berntsen, The Computing Centre,
University of Bergen, Thormohlens gt. 55,
N-5008 Bergen, Norway
Phone..  47-5-544055
Email..  jarle@eik.ii.uib.no

Ronald Cools, Dept. of Computer Science,
Katholieke Universiteit Leuven, Celestijnenlaan 200A,
B-3030 Heverlee, Belgium
Phone..  32-16-201015 (3562)
Email..  ronald@cs.kuleuven.ac.be

Terje O. Espelid, Department of Informatics,
University of Bergen, Thormohlens gt. 55,
N-5008 Bergen, Norway
Phone..  47-5-544180
Email..  terje@eik.ii.uib.no
.fi
