.TH adj_lists 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
adj_lists - computes adjacency lists
.SH CALLING SEQUENCE
.nf
[lp,la,ls] = adj_lists(g)
[lp,la,ls] = adj_lists(directed,n,tail,head)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 9
directed
: integer, 0 (undirected graph) or 1 (directed  graph)
.TP 2
n
: integer, the number of nodes of the graph
.TP 5
tail
: the row vector of the numbers of the tail nodes of the graph (its size is the
number of edges of the graph)
.TP 5
head
: the row vector of the numbers of the head nodes of the graph (its size is the
number of edges of the graph)
.TP 3
lp
: row vector, pointer array of the adjacency lists description of the graph 
(its size is the number of nodes of the graph + 1) 
.TP 3
la
: row vector, arc array of the adjacency lists description of the graph 
(its size is the number of edges of the graph) 
.TP 3
ls
: row vector, node array of the adjacency lists description of the graph 
(its size is the number of edges of the graph) 
.SH DESCRIPTION
\fVadj_lists\fR computes the row vectors of the adjacency lists description of 
the graph \fVg\fR.
It is also possible to give \fVadj_lists\fR the description of the
graph given by the number of nodes 
\fVn\fR and the row vectors \fVtail\fR and \fVhead\fR.
.SH EXAMPLE
.nf
ta=[2 3 3 5 3 4 4 5 8];
he=[1 2 4 2 6 6 7 7 4];
g=make_graph('foo',1,8,ta,he);
g('node_x')=[129 200 283 281 128 366 122 333];
g('node_y')=[61 125 129 189 173 135 236 249];
show_graph(g);
[lp,la,ls]=adj_lists(g)
[lp,la,ls]=adj_lists(1,g('node_number'),ta,he)
.fi
.SH SEE ALSO
chain_struct, graph_2_mat
