.TH quaskro 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
randpencil - random pencil
.SH CALLING SEQUENCE
.nf
F=randpencil(eps,infi,fin,eta)
.fi
.SH PARAMETERS
.TP
eps
: vector of integers
.TP
infi
: vector of integers
.TP
fin
: real vector, or monic polynomial, or vector of monic polynomial
.TP
eta
:
vector of integers
.TP
F
:
real matrix pencil \fVF=s*E-A\fR  (\fVs=poly(0,'s')\fR)
.SH DESCRIPTION
Utility function.
\fVF=randpencil(eps,infi,fin,eta)\fR returns a random pencil \fVF\fR
with given Kronecker structure. The structure is given by:
\fVeps=[eps1,...,epsk]\fR: structure of epsilon blocks (size eps1x(eps1+1),....)
\fVfin=[l1,...,ln]\fR  set of finite eigenvalues (assumed real)  (possibly [])
\fVinfi=[k1,...,kp]\fR size of J-blocks at infinity
\fVki>=1\fR  (infi=[] if no J blocks).
\fVeta=[eta1,...,etap]\fR: structure ofeta blocks (size eta1+1)xeta1,...)
.LP
\fVepsi\fR's should be >=0, \fVetai\fR's should be >=0, \fVinfi\fR's should 
be >=1.
.LP 
If \fVfin\fR is a (monic) polynomial, the finite block admits the roots of 
\fVfin\fR as eigenvalues.
.LP
If \fVfin\fR is a vector of polynomial, they are the finite elementary
divisors of \fVF\fR i.e. the roots of \fVp(i)\fR are finite
eigenvalues of \fVF\fR.
.SH EXAMPLE
.nf
F=randpencil([0,1],[2],[-1,0,1],[3]);
[Q,Z,Qd,Zd,numbeps,numbeta]=kroneck(F);
Qd, Zd
s=poly(0,'s');
F=randpencil([],[1,2],s^3-2,[]); //regular pencil
det(F)
.fi
.SH SEE ALSO
kroneck, pencan, penlaur




