.TH "smultim1d __SUBTITLE__=stochastic multinomial 1d measure synthesis" 2 "July 5th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
smultim1d __SUBTITLE__=stochastic multinomial 1d measure synthesis - 
.sp
Author: Christophe Canus
.sp
This C_LAB routine synthesizes two types of pre-multifractal
stochastic measures related to the multinomial 1d measure (uniform law
and lognormal law) and computes linked multifractal spectrum.
.sp
.sp
.SH Usage
\f(CR[\fPvarargout,\f(CR[\fPoptvarargout\f(CR]\fP\f(CR]\fP=sbinom(b,str,varargin,\f(CR[\fPoptvarargin\f(CR]\fP)
.SH Input parameters


.RS

.TP
o 
\fBb\fP : strictly positive real (integer) scalar 
Contains the base of the multinomial.

.TP
o 
\fBstr\fP : string 
Contains the type of ouput.

.TP
o 
\fBvarargin\fP : variable input argument 
Contains the variable input argument.

.TP
o 
\fBoptvarargin\fP : optional variable input arguments 
Contains optional variable input arguments.
.RE

.SH Output parameters


.RS

.TP
o 
\fBvarargout\fP : variable output argument 
Contains the variable output argument.

.TP
o 
\fBoptvarargout\fP : optional variable output argument 
Contains an optional variable output argument. 
.RE

.SH Description
.SH Parameters 
The stochastic multinomial 1d measure is completly characterized by
its base \fIb\fP. This first parameter must be \f(CR>\fP1.
 
The second parameter \fIstr\fP is a variable string used to determine
the desired type of output. There are four suffix strings ('\fImeas\fP'
for measure, '\fIcdf\fP' for cumulative distribution function
q, '\fIpdf\fP' for probability density function, '\fIspec\fP' for
multifractal spectrum) and a two prefix strings for the type of
stochastic measure ('\fIunif\fP' for uniform and '\fIlogn\fP' for
lognormal) which must added to the first ones to form composed. For
example, '\fIunifmeas\fP' is for the synthesis of a uniform law
multinomial 1d pre-multifractal measure and '\fIlognspec\fP' is for the
computation of the multifractal spectrum of a lognormal multinomial 1d
measure.
When a string containing suffix string '\fImeas\fP' is given as second
input, a pre-multifractal measure \fImu_n\fP (first output argument) is
synthesized on the \fIb\fP-adic intervals \fII_n\fP (second optional
output argument) of the unit interval. In that case, the third input
argument is a strictly positive real (integer) scalar \fIn\fP which
contains the resolution of the pre-multifractal measure. The size of
the output real vectors \fImu_n\fP (and \fII_n\fP if used) is equal to
\fIb\fP\(ha\fIn\fP (so be aware the stack size ;-)). This option is
implemented for the uniform law ('\fIunifmeas\fP') and the lognormal
law ('\fIlognmeas\fP') multinomial 1d measures.
When a string containing prefix '\fIunif\fP' is given as second input,
the synthesis or the computation is made for a uniform law multinomial
1d measure. In that case, the optional fourth input argument is a
strictly positive real scalar \fIepsilon\fP which contains the
pertubation around weight .5.  The weight is an independant random
variable identically distributed between \fIepsilon\fP and
1-\fIepsilon\fP which must be \f(CR>\fP0., \f(CR<\fP1. The default value for
\fIepsilon\fP is 0.
When a string containing prefix '\fIlogn\fP' is given as second input,
the synthesis or the computation is made for a lognormal law multinomial 1d
measure. In that case, the optional fourth input argument is a
strictly positive real scalar \fIsigma\fP which contains the standard
deviation of the lognormal law.
When replacing suffix string '\fImeas\fP' with suffix
string '\fIcdf\fP', respectively suffix string '\fIpdf\fP', the cumulative
distribution function \fIF_n\fP, respectively the probability density
function \fIp_n\fP, related to this pre-multifractal measure is
computed (first output argument).
When a string containing suffix string '\fIspec\fP' is given as second
input, the multifractal spectrum \fIf_alpha\fP (second output argument)
is synthesized on the Hoelder exponents \fIalpha\fP (first output
argument). In that case, the third input argument is a strictly
positive real (integer) scalar \fIN\fP which contains the number of
Hoelder exponents. The size of both output real vectors \fIalpha\fP and
\fIf_alpha\fP is equal to \fIN\fP.  This option is implemented only for
the lognormal law ('\fIlognspec\fP') multinomial 1d measures.
.SH Algorithm details
 
For the uniform and lognormal law multinomial 1d, the synthesis algorithm is
implemented is a recursive way (to be able to pick up a i.i.d. r.v. at
each level of the multiplicative cascade and for all nodes of the
corresponding binary tree w.r.t. the given law). Note that the
lognormal law multinomial 1d measure is not conservative.
.SH Examples
.SH Matlab
.sp
.ft CR
.nf
n=10;
% synthesizes a pre-multifractal uniform Law multinomial 1d measure
[mu_n,I_n]=smultim1d(b,'unifmeas',n);
plot(I_n,mu_n);
s=1.;
% synthesizes the cdf of a pre-multifractal lognormal law multinomial 1d measure
F_n=smultim1d(b,'logncdf',n,s);
plot(I_n,F_n);
e=.19;
% synthesizes the pdf of a pre-multifractal uniform law multinomial 1d measure
p_n=smultim1d(b,'unifpdf',n,e);
plot(I_n,p_n);
N=200;
s=1.;
% computes the multifractal spectrum of the lognormal law multinomial 1d measure
[alpha,f_alpha]=smultim1d(b,'lognspec',N,s);
plot(alpha,f_alpha);
.fi 
.ec
.ft P
.sp
.SH Scilab
.sp
.ft CR
.nf
n=10;
// synthesizes a pre-multifractal uniform Law multinomial 1d measure
[mu_n,I_n]=smultim1d(b,'unifmeas',n);
plot(I_n,mu_n);
s=1.;
// synthesizes the cdf of a pre-multifractal lognormal law multinomial 1d measure
F_n=smultim1d(b,'logncdf',n,s);
plot(I_n,F_n);
e=.19;
// synthesizes the pdf of a pre-multifractal uniform law multinomial 1d measure
p_n=smultim1d(b,'unifpdf',n,e);
plot(I_n,p_n);
N=200;
// computes the multifractal spectrum of the lognormal law multinomial 1d measure
[alpha,f_alpha]=smultim1d(b,'lognspec',N,s);
plot(alpha,f_alpha);
.fi 
.ec
.ft P
.sp
.SH References
\fB"A class of Multinomial Multifractal Measures with negative
(latent) values for the "Dimension" f(alpha)"\fP, Benoit
B. MandelBrot. \fIIn Fractals' Physical Origins and Properties,
Proceeding of the Erice Meeting, 1988. Edited by L. Pietronero, Plenum
Press, New York, 1989 pages 3-29\fP.
\fB"Limit Lognormal Multifractal Measures"\fP, Benoit
B. MandelBrot. \fIIn Frontiers of Physics, Landau Memorial
Conference, Proceeding of the Tel-Aviv Meeting, 1988. Edited by Errol
Asher Gotsman, Yuval Ne'eman and Alexander Voronoi, New York Pergamon,
1990 pages 309-340\fP.
.SH See also
\fBbinom, sbinom, multim1d, multim2d, smultim2d\fP (C_LAB routines).
\fBMFAS_measures, MFAS_dimensions, MFAS_spectra\fP (Matlab and/or Scilab demo scripts).
