.TH "GeneWei" 2 " June 6th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
GeneWei -  Generalized Weierstrass function
.sp
Author: Paulo Goncalves 
.sp
Generates a Generalized Weierstrass function
.sp
.sp
.SH Usage
.sp
.ft CR
.nf
[x,Ht]=GeneWei(N,ht,lambda,tmax,randflag)
.fi 
.ec
.ft P
.sp
.SH Input parameters


.RS

.TP
o 
\fB N \fP : Positive integer 
Sample size of the synthesized signal

.TP
o 
\fB ht \fP : Real vector or character string
\fI ht \fP: real vector of size \f(CR[\fP1,N\f(CR]\fP: each element
prescribes the local Holder regularity of the function. All elements
of \fI ht \fP must be in the interval \f(CR[\fP0,1\f(CR]\fP. 
\fI ht \fP: character string : contains the analytic expression of the
Holder trajectory  (e.g. '0.5*sin(16*t) + 0.5')

.TP
o 
\fB lambda \fP : positive real
Geometric progression of the Weierstrass function. Default value is \fIlambda\fP = 2.

.TP
o 
\fBtmax \fP : positive real
Time support of the Weierstrass function. Default value is \fItmax\fP = 1.

.TP
o 
\fB randflag \fP : flag 0/1
\fI flag \fP = 0 : deterministic Weierstrass function  
\fI flag \fP = 1 : random Weierstrass process 
Default value is \fIrandflag\fP = 0
.RE

.SH Output parameters


.RS

.TP
o 
\fB x \fP : real vector  \f(CR[\fP1,N\f(CR]\fP 
Time samples of the Weierstrass function

.TP
o 
\fB Fj \fP : real vector \f(CR[\fP1,N\f(CR]\fP 
Holder trajectory of the Weierstrass function
.RE

.SH See also:
.SH Example:
\f(CR[\fPx,Ht\f(CR]\fP = GeneWei(1024,'abs(sin(16*t))',2,1,0) ;
