.TH typeof G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
typeof -  object type
.SH CALLING SEQUENCE
.nf
[t]=typeof(object)
.fi
.SH PARAMETERS
.TP 10
object 
: Scilab object
.TP 10
t
: string
.SH DESCRIPTION
\fVt=typeof(object)\fR returns one of the following strings:
.TP 
"constant"       
if object is a real or complex constant matrix
.TP 
"polynomial"  
if object is a polynomial matrix
.TP 
"function"       
if object is a function
.TP 
"string"   
if object is a matrix made of character strings
.TP 
"boolean"     
if object is a boolean matrix
.TP 
"list"        
if object is a list
.TP 
"rational"    
if object is a rational matrix (transfer matrix)
.TP 
"state-space" 
if object is a state-space model (see \fVsyslin\fR)
.TP 
"sparse"      
if object is a (real) sparse matrix.
.TP
"boolean sparse"
if object is a boolean sparse matrix.
.SH EXAMPLE
.nf
typeof(1)
typeof(poly(0,'x'))
typeof(1/poly(0,'x'))
typeof(%t)
w=sprand(100,100,0.001);
typeof(w)
typeof(w==w)
deff('y=f(x)','y=2*x');
typeof(f)
.fi
.SH SEE ALSO
type, strings,  syslin, poly

