.TH repfreq 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
repfreq - frequency response
.SH CALLING SEQUENCE
.nf
[ [frq,] repf]=repfreq(sys,fmin,fmax [,step])
[ [frq,] repf]=repfreq(sys [,frq])
[ frq,repf,splitf]=repfreq(sys,fmin,fmax [,step])
[ frq,repf,splitf]=repfreq(sys [,frq])
.fi
.SH PARAMETERS
.TP
sys
: \fVsyslin\fR list : SIMO linear system 
.TP 15
fmin,fmax  
: two real numbers (lower and upper frequency bounds)
.TP
frq        
: real vector of frequencies (Hz)
.TP
step        
: logarithmic discretization step
.TP
splitf
: vector of indexes of critical frequencies.
.TP
repf       
: vector of the complex frequency response
.SH DESCRIPTION
\fVrepfreq\fR returns the frequency response calculation of a linear
system. If \fVsys(s)\fR is the transfer function of \fVSys\fR, \fVrepf(k)\fR 
equals \fVsys(s)\fR evaluated at \fVs= %i*frq(k)*2*%pi\fR for continuous time systems and 
at \fVexp(2*%i*%pi*dt*frq(k))\fR for discrete time systems (\fVdt\fR is the sampling period).
.LP
\fVdb(k)\fR is the magnitude of \fVrepf(k)\fR expressed in dB i.e.
\fVdb(k)=20*log10(abs(repf(k)))\fR and \fVphi(k)\fR is the phase
of \fVrepf(k)\fR expressed in degrees.
.LP
If \fVfmin,fmax,step\fR are input parameters, the response is calculated
for the vector of frequencies \fVfrq\fR given by:
\fVfrq=[10.^((log10(fmin)):step:(log10(fmax))) fmax];\fR
.LP
If \fVstep\fR is not given, the output parameter \fVfrq\fR is calculated by \fVfrq=calfrq(sys,fmin,fmax)\fR.
.LP 
Vector \fVfrq\fR is splitted into regular parts with the \fVsplit\fR vector.
\fVfrq(splitf(k):splitf(k+1)-1)\fR has no critical frequency. 
\fVsys\fR has a pole in the range \fV[frq(splitf(k)),frq(splitf(k)+1)]\fR and 
no poles outside.
.SH EXAMPLE
.nf
A=diag([-1,-2]);B=[1;1];C=[1,1];
Sys=syslin('c',A,B,C);
frq=0:0.02:5;w=frq*2*%pi; //frq=frequencies in Hz ;w=frequencies in rad/sec;
[frq1,rep] =repfreq(Sys,frq);
[db,phi]=dbphi(rep);
Systf=ss2tf(Sys)    //Transfer function of Sys
x=horner(Systf,w(2)*sqrt(-1))    // x is Systf(s) evaluated at s = i w(2)
rep=20*log(abs(x))/log(10)   //magnitude of x in dB
db(2)    // same as rep
ang=atan(imag(x),real(x));   //in rad.
ang=ang*180/%pi              //in degrees
phi(2)
repf=repfreq(Sys,frq);
repf(2)-x
.fi
.SH SEE ALSO
bode, freq, calfrq, horner, nyquist, dbphi
.SH AUTHOR
S. S.
