.TH arsimul 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
arsimul - armax simulation 
.SH CALLING SEQUENCE
.nf
[z]=arsimul(a,b,d,sig,u,[up,yp,ep])
[z]=arsimul(ar,u,[up,yp,ep])
.fi
.SH PARAMETERS
.TP 10
ar 
: an armax process. See armac. 
.TP
a
: is the matrix[Id,a1,...,a_r]     of dimension (n,(r+1)*n)
.TP
b
: is the matrix[b0,......,b_s]     of dimension (n,(s+1)*m)
.TP
d 
: is the matrix[Id,d_1,......,d_t] of dimension (n,(t+1)*n)
.TP
u
: is a matrix  (m,N), which gives the entry u(:,j)=u_j
.TP
sig
: is a  (n,n) matrix  e_{k} is an n-dimensional Gaussian process with variance I
.TP
up, yp 
: optional parameter which describe the past.
      up=[ u_0,u_{-1},...,u_{s-1}];
      yp=[ y_0,y_{-1},...,y_{r-1}];
      ep=[ e_0,e_{-1},...,e_{r-1}];
if they are omitted, the past value are supposed to be zero
.TP
z
: z=[      y(1),....,y(N)]
.SH DESCRIPTION
simulation of an n-dimensional armax process
   A(z^-1) z(k)= B(z^-1)u(k) + D(z^-1)*sig*e(k)

   A(z)= Id+a1*z+...+a_r*z^r;  ( r=0  => A(z)=Id)
   B(z)= b0+b1*z+...+b_s z^s;  ( s=-1 => B(z)=0)
   D(z)= Id+d1*z+...+d_t z^t;  ( t=0  => D(z)=Id)
   
   z et e are in   R^n et u in  R^m
.SH METHOD 
a state-space representation is constructed and ode with the option 
"discret" is used to compute z
.SH AUTHOR 
J-Ph.C.

