/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/names.e,v 4.22 2000/01/15 22:24:54 william Exp $
 */

#ifndef _NAMES_E_
#define _NAMES_E_

extern char	curDomainName[];
extern char	curDomainPath[];
extern char	curDir[];
extern char	curLocalDir[];
extern char	curSymDir[];

extern int	doubleClickInterval;
extern int	importFromLibrary;
extern int	curDirIsLocal;

extern int	ignoreDirectoryFlag;
		/* use to be ignoreDirectoryFlagInMakeNameDspItemArray; */

#ifdef _INCLUDE_FROM_NAMES_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_NAMES_C_*/

extern void	ParseSymPath ARGS_DECL((char*));
extern void	InitNames ARGS_DECL((void));
extern void	UpdateDirInfo ARGS_DECL((void));
extern void	UpdateSymInfo ARGS_DECL((void));
extern void	CleanUpNames ARGS_DECL((void));

extern int	DirInSymPath ARGS_DECL((char *DirName));
extern char	**MakeNameDspItemArray ARGS_DECL((int Entries, DspList*));

extern int	SelectFileName ARGS_DECL((char *MsgStr, char *SelStr));
extern int	SelectFileNameToPaste ARGS_DECL((char *MsgStr, char *SelStr));
extern int	SelectFileNameToImport ARGS_DECL((char *MsgStr, char *ExtStr,
		                                  char *SelStr));
extern int	GetSymbolPath ARGS_DECL((char *SymName, int Pin,
		                         char *PathName));
extern int	NameInCurDir ARGS_DECL((char *FileName));
extern void	ChangeDomain ARGS_DECL((void));
extern int	SelectSymDir ARGS_DECL((char *SelStr));
extern int	SelectFromLibrary ARGS_DECL((char *MsgStr, char *ExtStr,
		                             char *SelStr, char *PathStr));
extern void	SetCurDir ARGS_DECL((char *FileName));
extern void	SetCurSymDir ARGS_DECL((char *FileName));
extern void	SetCurImportDir ARGS_DECL((char *FileName));

extern void	CopyDomainInfoToIni ARGS_DECL((void));
extern void	EditDomainPaths ARGS_DECL((void));
extern void	SelectDefaultDomain ARGS_DECL((void));
extern void	AddADomain ARGS_DECL((void));
extern void	DeleteADomain ARGS_DECL((void));
extern void	ReloadDomainInfoFromX ARGS_DECL((void));

extern int	RefreshDomainMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateDomainMenu ARGS_DECL((TgMenu*, int X, int Y,
		                             TgMenuInfo*,
		                             int status_str_xlated));

#ifdef _INCLUDE_FROM_NAMES_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_NAMES_C_*/

#endif /*_NAMES_E_*/
