/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgMagnitude.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:47 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Magnitude"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2=NULL;
  int width=0,height=0,x,y,i,dim;
  it_float *flt_ptr,*flt_ptr2;
  it_complex *cpx_ptr;
  it_polar *plr_ptr;
  double max,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate the magnitude of a pixel vector\n",
	      PRGNAME);
      fprintf(stderr,"img%s [number]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float, Complex, Polar\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  number specifies the number of input images to include\n");
      exit(0);
    }

  imgStart(PRGNAME);
  dim=1;
  if(argc>1)
    dim=atoi(argv[1]);

  do {
    for(i=0;i<dim;i++)
      {
	i1=i_read_image_file(stdin,IT_FLOAT|IT_COMPLEX|IT_POLAR,IM_FRAGMENT);
	if(i1==NULL)
	  ERROR("can't import image file");

	if(i==0)
	  {
	    /* First time, so initialise */
	    width=i1->width;
	    height=i1->height;

	    i2=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
	    if(i2==NULL)
	      ERROR("out of memory");
	    i2->valid_x=i1->valid_x;
	    i2->valid_y=i1->valid_y;
	    i2->valid_width=i1->valid_width;
	    i2->valid_height=i1->valid_height;
    
	    /* Clear to 0.0 */
	    for(y=0;y<height;y++)
	      {
		flt_ptr=im_float_row(i2,y);
		for(x=0;x<width;x++)
		  *flt_ptr++ =0.0;
	      }
	  }
	else
	  if(i2->width!=width || i2->height!=height)
	    ERROR("images are of different sizes");

	/* Now accumulate the square of the magnitude */
	switch(i1->type)
	  {
	  case IT_COMPLEX:
	    /* Compute the square of the magnitude */
	    for(y=0;y<height;y++)
	      {
		cpx_ptr=im_complex_row(i1,y);
		flt_ptr=im_float_row(i2,y);
		for(x=0;x<width;x++,cpx_ptr++,flt_ptr++)
		  *flt_ptr+=((cpx_ptr->Re)*(cpx_ptr->Re)
			     +(cpx_ptr->Im)*(cpx_ptr->Im));
	      }
	    break;
	  case IT_FLOAT:
	    /* Accumulate the square of the value */
	    for(y=0;y<height;y++)
	      {
		flt_ptr2=im_float_row(i1,y);
		flt_ptr=im_float_row(i2,y);
		for(x=0;x<width;x++,flt_ptr++,flt_ptr2++)
		  *flt_ptr+=(*flt_ptr2)*(*flt_ptr2);
	      }
	    break;
	  default:
	    /* Just copy the polar magnitude and square it*/
	    for(y=0;y<height;y++)
	      {
		plr_ptr=im_polar_row(i1,y);
		flt_ptr=im_float_row(i2,y);
		for(x=0;x<width;x++,flt_ptr++,plr_ptr++)
		  *flt_ptr+=(plr_ptr->rad)*(plr_ptr->rad);
	      }
	    break;
	  }
	i_destroy_image(i1);	
      }

    /* Now we've got all the square magnitudes, sqrt and work out max */
    max=0.0;
    for(y=0;y<height;y++)
      {
	flt_ptr=im_float_row(i2,y);
	for(x=0;x<width;x++)
	  {
	    val=sqrt(*flt_ptr);
	    *flt_ptr++=val;
	    if(val>max)
	      max=val;
	  }
      }
    i2->min_value=0.0;
    i2->max_value=max;

    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
