/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFltToPgm.c                                                 */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:41 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "FltToPgm"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *flt_image,*pgm_image;
  double min,max,val;
  int x,y,xe,xs,ye,ys;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert Float image to pgm\n",
	      PRGNAME);
      fprintf(stderr,"img%s [min max]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: pgm\n");
      fprintf(stderr,"  min/max adjust scaling by overriding the input value range\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc!=1 && argc!=3)
    ERROR("invalid arguments");

  do {
    flt_image=i_read_image_file(stdin,IT_FLOAT,IM_CONTIG);
    if(flt_image==NULL)
      ERROR("can't import image file");

    if(argc==3)
      i_set_min_max_values(flt_image,atof(argv[1]),atof(argv[2]));

    pgm_image=i_create_image(flt_image->width,flt_image->height,
			     IT_BYTE,IM_CONTIG);
    if(pgm_image==NULL)
      ERROR("out of memory");

    if(flt_image->min_value==0.0 && flt_image->max_value==0.0)
      {
	imgInitMinMax(min,max);
	xs=flt_image->valid_x;
	ys=flt_image->valid_y;
	xe=xs+flt_image->valid_width;
	ye=ys+flt_image->valid_height;
	for(y=ys;y<ye;y++)
	  for(x=xs;x<xe;x++)
	    {
	      val=im_float_value(flt_image,x,y);
	      if(val>max)
		max=val;
	      if(val<min)
		min=val;
	    }
	flt_image->min_value=min;
	flt_image->max_value=max;
      }
    fprintf(stderr,"%s: (min = %g, max = %g)\n",PRGNAME,flt_image->min_value,
	    flt_image->max_value);
    i_float_to_byte(flt_image,pgm_image);

    i_write_image_file(stdout,pgm_image,IF_BINARY);
    i_destroy_image(flt_image);
    i_destroy_image(pgm_image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
