/****************************************************************************/
/*                                                                          */
/* Program:   i_convert.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Fri Jan 29 15:22:03 1993                                      */
/* Function:  image type conversion routines                                */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "lib.h"

/*#define debug(m) DEBUG("<convert> " m)*/
#define debug(m)

/*****************************************************************************/

/* Local function prototypes */
int ii_check_images(it_image *,int,it_image *,int);

int i_float_to_byte(it_image *float_image,it_image *byte_image)
{
  double min,max,val,scale,zero,low,high;
  int x,y,width,height;
  it_float *float_ptr;
  it_byte *byte_ptr;

  if(ii_check_images(byte_image,IT_BYTE,float_image,IT_FLOAT))
    return(1);
  low=0.0;
  high=255.0;
  min=float_image->min_value;
  max=float_image->max_value;
  width=float_image->width;
  height=float_image->height;
  if(min>max)
    {
      val=min;
      min=max;
      max=val;
    }
  if(min==0.0 && max==0.0)
    max=high;
  if(max>0.0 && min>0.0)
    min=0.0;
  if(min<0.0 && max<0.0)
    max=0.0;
  if(min<0.0 && max>0.0)
    {
      if(max>-min)
	scale=127.0/max;
      else
	scale= -127.0/min;
      zero=128.0;
    } else {
      if(max==min)
	scale=1.0;
      else
	scale=high/(max-min);
      zero= -min*scale;
    }
  for(y=0;y<height;y++)
    {
      float_ptr=im_float_row(float_image,y);
      byte_ptr=im_byte_row(byte_image,y);
      for(x=0;x<width;x++)
	{
	  val=zero+scale*(*float_ptr++);
	  if(val<low)
	    val=low;
	  if(val>high)
	    val=high;
	  *byte_ptr++=(it_byte) val;
	}
    }
  return(0);
}

int i_byte_to_float(it_image *byte_image,it_image *float_image)
{
  int width,height,x,y;
  it_byte *byte_ptr;
  it_float *float_ptr;

  if(ii_check_images(byte_image,IT_BYTE,float_image,IT_FLOAT))
    return(1);
  width=byte_image->width;
  height=byte_image->height;
  for(y=0;y<height;y++)
    {
      float_ptr=im_float_row(float_image,y);
      byte_ptr=im_byte_row(byte_image,y);
      for(x=0;x<width;x++)
	*float_ptr++ =(it_float) *byte_ptr++;
    }
  return(0);
}

int i_double_to_byte(it_image *double_image,it_image *byte_image)
{
  double min,max,val,scale,zero,low,high;
  int x,y,width,height;
  it_double *double_ptr;
  it_byte *byte_ptr;

  if(ii_check_images(byte_image,IT_BYTE,double_image,IT_DOUBLE))
    return(1);
  low=0.0;
  high=255.0;
  min=double_image->min_value;
  max=double_image->max_value;
  width=double_image->width;
  height=double_image->height;
  if(min>max)
    {
      val=min;
      min=max;
      max=val;
    }
  if(min==0.0 && max==0.0)
    max=high;
  if(max>0.0 && min>0.0)
    min=0.0;
  if(min<0.0 && max<0.0)
    max=0.0;
  if(min<0.0 && max>0.0)
    {
      if(max>-min)
	scale=127.0/max;
      else
	scale= -127.0/min;
      zero=128.0;
    } else {
      if(max==min)
	scale=1.0;
      else
	scale=high/(max-min);
      zero= -min*scale;
    }
  for(y=0;y<height;y++)
    {
      double_ptr=im_double_row(double_image,y);
      byte_ptr=im_byte_row(byte_image,y);
      for(x=0;x<width;x++)
	{
	  val=zero+scale*(*double_ptr++);
	  if(val<low)
	    val=low;
	  if(val>high)
	    val=high;
	  *byte_ptr++=(it_byte) val;
	}
    }
  return(0);
}

int i_byte_to_double(it_image *byte_image,it_image *double_image)
{
  int width,height,x,y;
  it_byte *byte_ptr;
  it_double *double_ptr;

  if(ii_check_images(byte_image,IT_BYTE,double_image,IT_DOUBLE))
    return(1);
  width=byte_image->width;
  height=byte_image->height;
  for(y=0;y<height;y++)
    {
      double_ptr=im_double_row(double_image,y);
      byte_ptr=im_byte_row(byte_image,y);
      for(x=0;x<width;x++)
	*double_ptr++ =(it_double) *byte_ptr++;
    }
  return(0);
}

int i_rgb_to_float(it_image *rgb_image,it_image *f1,it_image *f2,it_image *f3)
{
  it_rgb *rgb_ptr;
  it_float *f1_ptr,*f2_ptr,*f3_ptr;
  int x,y,width,height;
  
  if(ii_check_images(rgb_image,IT_RGB,f1,IT_FLOAT))
    return(1);
  if(ii_check_images(f2,IT_FLOAT,f3,IT_FLOAT))
    return(1);
  if(f1->width!=f2->width || f1->height!=f2->height)
    return(1);
  width=rgb_image->width;
  height=rgb_image->height;
  for(y=0;y<height;y++)
    {
      f1_ptr=im_float_row(f1,y);
      f2_ptr=im_float_row(f2,y);
      f3_ptr=im_float_row(f3,y);
      rgb_ptr=im_rgb_row(rgb_image,y);
      for(x=0;x<width;x++)
	{
	  *f1_ptr++ =(it_float) rgb_ptr->r;
	  *f2_ptr++ =(it_float) rgb_ptr->g;
	  *f3_ptr++ =(it_float) rgb_ptr->b;
	  rgb_ptr++;
	}
    }
  return(0);
}

int ii_check_images(it_image *im1,int t1,it_image *im2,int t2)
{
  if(im1==NULL || im2==NULL)
    return(1);
  if(im1->width!=im2->width || im1->height!=im2->height)
    return(1);
  if(im1->type!=t1 || im2->type!=t2)
    return(1);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
